/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseOptionArgsException;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.UnknownOptionArgsException;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;

public abstract class AbstractOption<T>
extends AbstractOperand<T>
implements Option<T> {
    private static final String LONG_OPTION_KEY = "LONG_OPTION";
    private static final String SHORT_OPTION_KEY = "SHORT_OPTION";
    private String _longOption;
    private Character _shortOption;

    public AbstractOption(Character aShortOption, String aLongOption, Class<T> aType, String aAlias, String aDescription) {
        this(aShortOption, aLongOption, aType, aAlias, aDescription, null);
    }

    public AbstractOption(Character aShortOption, String aLongOption, Class<T> aType, String aAlias, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aType, aAlias != null ? aAlias : (aLongOption != null ? aLongOption : (aShortOption != null ? aShortOption.toString() : null)), aDescription, aConsumer);
        if (aShortOption == null && (aLongOption == null || aLongOption.isEmpty())) {
            throw new IllegalArgumentException("At least the short option <" + (Serializable)(aShortOption != null ? "'" + aShortOption + "'" : aShortOption) + "> must not be null or the long option <" + (String)(aLongOption != null ? "\"" + aLongOption + "\"" : aLongOption) + "> must not be empty!");
        }
        this._shortOption = aShortOption;
        this._longOption = aLongOption;
    }

    public AbstractOption(Relation<String, T> aProperty, Class<T> aType) {
        this(aProperty, aType, null);
    }

    public AbstractOption(Relation<String, T> aProperty, Class<T> aType, Consumer<? extends Operand<T>> aConsumer) {
        super(aProperty, aType, aConsumer);
        this._shortOption = ((String)aProperty.getKey()).length() == 1 ? Character.valueOf(((String)aProperty.getKey()).charAt(0)) : null;
        this._longOption = ((String)aProperty.getKey()).length() > 1 ? (String)aProperty.getKey() : null;
    }

    public AbstractOption(String aLongOption, Class<T> aType, String aDescription) {
        this(null, aLongOption, aType, null, aDescription);
    }

    public AbstractOption(String aLongOption, Class<T> aType, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        this(null, aLongOption, aType, null, aDescription, aConsumer);
    }

    public AbstractOption(String aLongOption, Class<T> aType, String aAlias, String aDescription) {
        this(null, aLongOption, aType, aAlias, aDescription);
    }

    public AbstractOption(String aLongOption, Class<T> aType, String aAlias, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        this(null, aLongOption, aType, aAlias, aDescription, aConsumer);
    }

    protected AbstractOption(Character aShortOption, String aLongOption, Class<T> aType, String aDescription) {
        this(aShortOption, aLongOption, aType, null, aDescription);
    }

    protected AbstractOption(Character aShortOption, String aLongOption, Class<T> aType, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        this(aShortOption, aLongOption, aType, null, aDescription, aConsumer);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getLongOption() {
        return this._longOption;
    }

    @Override
    public Character getShortOption() {
        return this._shortOption;
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        Relation<String, String> theOptionArgument = this.toOptionArgument(aArgs, aOptions, aCliCtx);
        if (theOptionArgument != null) {
            this.setParsedArgs(new String[]{(String)theOptionArgument.getKey(), (String)theOptionArgument.getValue()});
            this.setValue(this.toType((String)theOptionArgument.getValue()));
            this._matchCount = 1;
            return new Operand[]{this};
        }
        if (AbstractOption.contains(aArgs, aCliCtx.toShortOption(this))) {
            this._exception = new ParseOptionArgsException("Missing value for option \"{0}\" requiring a value.", aArgs, aCliCtx.toShortOption(this), aCliCtx.toLongOption(this), (Term)this);
            throw this._exception;
        }
        if (AbstractOption.contains(aArgs, aCliCtx.toLongOption(this))) {
            this._exception = new ParseOptionArgsException("Missing value for option \"{1}\" requiring a value.", aArgs, aCliCtx.toShortOption(this), aCliCtx.toLongOption(this), (Term)this);
            throw this._exception;
        }
        this._exception = this.toException(aArgs, aCliCtx);
        throw this._exception;
    }

    @Override
    public CliSchema toSchema() {
        CliSchema theSchema = super.toSchema();
        theSchema.put(SHORT_OPTION_KEY, this._shortOption);
        theSchema.put(LONG_OPTION_KEY, this._longOption);
        return theSchema;
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return aCliCtx.toOptionEscapeCode() + aCliCtx.toOption(this) + aCliCtx.toResetEscapeCode() + (String)(this.getAlias() != null ? " " + aCliCtx.toArgumentSpec(this) : "") + aCliCtx.toResetEscapeCode();
    }

    protected UnknownArgsException toException(String[] aArgs, CliContext aCliCtx) {
        if (this.getShortOption() != null && this.getLongOption() != null) {
            return new UnknownOptionArgsException("Neither the short-option \"{0}\" nor the long-option \"{1}\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!", aArgs, aCliCtx.toShortOption(this), aCliCtx.toLongOption(this), (Term)this);
        }
        if (this.getShortOption() != null && this.getLongOption() == null) {
            return new UnknownOptionArgsException("No option \"{0}\" was found in the command line arguments, though it must be specified to match the according syntax branch!", aArgs, aCliCtx.toShortOption(this), aCliCtx.toLongOption(this), (Term)this);
        }
        if (this.getShortOption() == null && this.getLongOption() != null) {
            return new UnknownOptionArgsException("No option \"{1}\" was found in the command line arguments, though it must be specified to match the according syntax branch!", aArgs, aCliCtx.toShortOption(this), aCliCtx.toLongOption(this), (Term)this);
        }
        throw new IllegalStateException("At least a short-option or a long-option must be defined, but none has been configured!");
    }

    @Override
    protected void setParsedArgs(String[] aArgs) {
        super.setParsedArgs(aArgs);
    }

    @Override
    protected void setValue(T aValue) {
        super.setValue(aValue);
    }

    protected static boolean contains(String[] aArgs, String aArg) {
        if (aArg != null) {
            ArrayList<String> theList = new ArrayList<String>(Arrays.asList(aArgs));
            return theList.contains(aArg);
        }
        return false;
    }

    private Relation<String, String> toOptionArgument(String[] aArgs, String aOption, String[] aOptions) {
        for (int i = 0; i < aArgs.length - 1; ++i) {
            String eArg = aArgs[i];
            if (!eArg.equals(aOption)) continue;
            String eOptArg = aArgs[i + 1];
            for (String eOption : aOptions) {
                if (!eOptArg.equalsIgnoreCase(eOption)) continue;
                return null;
            }
            return new RelationImpl((Object)aOption, (Object)eOptArg);
        }
        return null;
    }

    private Relation<String, String> toOptionArgument(String[] aArgs, String[] aOptions, CliContext aCliCtx) {
        if (aArgs.length > 1) {
            Relation<String, String> theAttribute = this.toOptionArgument(aArgs, aCliCtx.toShortOption(this), aOptions);
            if (theAttribute != null) {
                return theAttribute;
            }
            theAttribute = this.toOptionArgument(aArgs, aCliCtx.toLongOption(this), aOptions);
            if (theAttribute != null) {
                return theAttribute;
            }
        }
        return null;
    }
}

