/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DoubleProperty;
import org.refcodes.cli.Flag;
import org.refcodes.cli.IntProperty;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.AsciiColorPalette;

public class MessageTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testErrorMessage1() {
        String[] stringArray = new String[]{"--string=someString", "--token=1234567890"};
        ArgsParser argsParser = MessageTest.createArgsParser();
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expected an exception of type <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            String string = argsSyntaxException.toMessage();
            String string2 = argsSyntaxException.toHeuristicMessage();
            if (IS_LOG_TEST_ENABLED) {
                System.out.println("toMessage() = " + string);
                System.out.println("toHeuristicMessage() = " + string2);
            }
            Assertions.assertEquals((Object)"No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: No option \"--name\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!", (Object)string);
            Assertions.assertEquals((Object)"Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: No option \"--name\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!", (Object)string2);
        }
    }

    @Test
    public void testErrorMessage2() {
        String[] stringArray = new String[]{"--string=someString", "--email=someEmail", "--token=1234567890"};
        ArgsParser argsParser = MessageTest.createArgsParser();
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expected an exception of type <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            String string = argsSyntaxException.toMessage();
            String string2 = argsSyntaxException.toHeuristicMessage();
            if (IS_LOG_TEST_ENABLED) {
                System.out.println("toMessage() = " + string);
                System.out.println("toHeuristicMessage() = " + string2);
            }
            Assertions.assertEquals((Object)"No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!", (Object)string);
            Assertions.assertEquals((Object)"Failed as of superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!", (Object)string2);
        }
    }

    private static ArgsParser createArgsParser() {
        ArgsParser argsParser = new ArgsParser();
        Flag flag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag flag2 = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty stringProperty = CliSugar.stringProperty((String)"string", (String)"...");
        StringProperty stringProperty2 = CliSugar.stringProperty((String)"string", (String)"...");
        BooleanProperty booleanProperty = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag flag3 = CliSugar.flag((String)"bool", (String)"...");
        StringProperty stringProperty3 = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty stringProperty4 = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty stringProperty5 = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty intProperty = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty doubleProperty = CliSugar.doubleProperty((String)"double", (String)"...");
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{stringProperty, CliSugar.optional((Term[])new Term[]{stringProperty2, CliSugar.xor((Term[])new Term[]{booleanProperty, flag3, CliSugar.and((Term[])new Term[]{stringProperty3, stringProperty4, stringProperty5})}), intProperty, doubleProperty})}), flag, flag2});
        return argsParser.withArgsSyntax((Term)casesCondition).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
    }
}

