/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Flag;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;

public class StackOverflowTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testParserStackOverflow1() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('r'), null, "opt1", "Your description for option r with argument opt1");
        StringOption stringOption2 = new StringOption(Character.valueOf('S'), null, "opt2", "Your description for option S with argument opt2");
        StringOperand stringOperand = new StringOperand("arg1", "Your description for arg1");
        StringOperand stringOperand2 = new StringOperand("arg2", "Your description for arg2");
        StringOperand stringOperand3 = new StringOperand("arg3", "Your description for arg3");
        StringOperand stringOperand4 = new StringOperand("arg4", "Your description for arg4");
        Flag flag = new Flag("test", null, "Your description for test");
        StringOption stringOption3 = new StringOption(Character.valueOf('A'), null, "opt3", "Your description for option A with argument opt3");
        AndCondition andCondition = new AndCondition(new Term[]{stringOption, stringOption2, stringOption3, stringOperand, stringOperand2, stringOperand3, stringOperand4, flag});
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        argsParser.withName("MyProgramm");
        argsParser.withSyntaxMetrics(SyntaxNotation.GNU_POSIX);
        argsParser.printSynopsis();
        argsParser.printSeparatorLn();
        argsParser.printOptions();
        argsParser.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "--test", "-A", "AAAAA"});
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("r    :=" + (String)stringOption.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("S    :=" + (String)stringOption2.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("arg1 :=" + (String)stringOperand.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("arg2 :=" + (String)stringOperand2.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("arg3 :=" + (String)stringOperand3.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("arg4 :=" + (String)stringOperand4.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("test :=" + flag.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("A    :=" + (String)stringOption3.getValue());
        }
        Assertions.assertEquals((Object)stringOption.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)stringOption2.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)stringOperand.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)stringOperand2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)stringOperand3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)stringOperand4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)flag.getValue(), (Object)true);
        Assertions.assertEquals((Object)stringOption3.getValue(), (Object)"AAAAA");
    }

    @Test
    public void testParserStackOverflow2() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('r'), null, "opt1", "Your description for option r with argument opt1");
        StringOption stringOption2 = new StringOption(Character.valueOf('S'), null, "opt2", "Your description for option S with argument opt2");
        StringOperand stringOperand = new StringOperand("arg1", "Your description for arg1");
        StringOperand stringOperand2 = new StringOperand("arg2", "Your description for arg2");
        StringOperand stringOperand3 = new StringOperand("arg3", "Your description for arg3");
        StringOperand stringOperand4 = new StringOperand("arg4", "Your description for arg4");
        Flag flag = new Flag(null, "test", null, "Your description for test");
        StringOption stringOption3 = new StringOption(Character.valueOf('A'), null, "opt3", "Your description for option A with argument opt3");
        AndCondition andCondition = new AndCondition(new Term[]{stringOption, stringOption2, stringOption3, stringOperand, stringOperand2, stringOperand3, stringOperand4, new AnyCondition(new Term[]{flag})});
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        argsParser.withName("MyProgramm");
        argsParser.withSyntaxMetrics(SyntaxNotation.GNU_POSIX);
        argsParser.printSynopsis();
        argsParser.printSeparatorLn();
        argsParser.printOptions();
        argsParser.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "-A", "AAAAA"});
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("r    :=" + (String)stringOption.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("S    :=" + (String)stringOption2.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("arg1 :=" + (String)stringOperand.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("arg2 :=" + (String)stringOperand2.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("arg3 :=" + (String)stringOperand3.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("arg4 :=" + (String)stringOperand4.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("test :=" + flag.getValue());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("A    :=" + (String)stringOption3.getValue());
        }
        Assertions.assertEquals((Object)stringOption.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)stringOption2.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)stringOperand.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)stringOperand2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)stringOperand3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)stringOperand4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)flag.getValue(), (Object)false);
        Assertions.assertEquals((Object)stringOption3.getValue(), (Object)"AAAAA");
    }

    @Test
    public void testParserStackOverflow3() throws ArgsSyntaxException {
        block2: {
            CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.none((String)"none"), CliSugar.optional((Term[])new Term[]{CliSugar.helpFlag()}), CliSugar.stringOperand((String)"operand", (String)"description")});
            ArgsParser argsParser = new ArgsParser().withArgsSyntax((Term)casesCondition);
            try {
                argsParser.evalArgs(new String[0]);
                Assertions.fail((String)("Expecting a <" + AmbiguousArgsException.class.getSimpleName() + ">!"));
            }
            catch (ArgsSyntaxException argsSyntaxException) {
                String string = argsSyntaxException.toMessage();
                if (!IS_LOG_TEST_ENABLED) break block2;
                System.out.println(string);
            }
        }
    }
}

