/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.Arrays;
import java.util.function.Consumer;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.mixin.Schema;
import org.refcodes.struct.Relation;

public abstract class AbstractOperand<T>
extends AbstractTerm
implements Operand<T> {
    private String _alias;
    private String[] _args = null;
    private Consumer<Operand<T>> _consumer;
    private Class<T> _type;
    private T _value = null;
    protected int _matchCount = 0;

    public AbstractOperand(Class<T> clazz, String string, String string2) {
        this(clazz, string, string2, null);
    }

    public AbstractOperand(Class<T> clazz, String string, String string2, Consumer<? extends Operand<T>> consumer) {
        super(string2);
        this._type = clazz;
        this._alias = string;
        this._consumer = consumer;
    }

    public AbstractOperand(Relation<String, T> relation, Class<T> clazz) {
        this(relation, clazz, null);
    }

    public AbstractOperand(Relation<String, T> relation, Class<T> clazz, Consumer<? extends Operand<T>> consumer) {
        this._alias = (String)relation.getKey();
        this._value = relation.getValue();
        this._consumer = consumer;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(Operand<?> operand) {
        if (operand instanceof Option) {
            Option option = (Option)operand;
            Object object = this;
            if (object instanceof Option) {
                Option option2 = (Option)object;
                object = option.getShortOption() != null ? option.getShortOption().toString() : option.getLongOption();
                String string = option2.getShortOption() != null ? option2.getShortOption().toString() : option2.getLongOption();
                return string.compareTo((String)object);
            }
            if (this instanceof Operand) {
                return 1;
            }
        }
        if (operand instanceof Operand && this instanceof Option) {
            return -11;
        }
        if (this.getAlias() != null && operand.getAlias() != null) {
            return this.getAlias().compareTo(operand.getAlias());
        }
        return this.toSyntax().compareTo(operand.toSyntax());
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public T getValue() {
        return this._value;
    }

    @Override
    public Operand<?>[] parseArgs(String[] stringArray, String[] stringArray2, CliContext cliContext) throws ArgsSyntaxException {
        int n = -1;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (cliContext.isOption(stringArray[i]) || n != -1 && n + -1 != i) continue;
            n = i;
        }
        if (n != -1) {
            this.setValue(this.toType(stringArray[n]));
            this.setParsedArgs(new String[]{stringArray[n]});
            this._matchCount = 1;
            return new Operand[]{this};
        }
        this._exception = new UnknownArgsException("Unable to parse any args (netiher being prefixed with \"" + cliContext.getSyntaxMetrics().getShortOptionPrefix() + "\" nor being prefixed with \"" + cliContext.getSyntaxMetrics().getLongOptionPrefix() + "\")!", stringArray, this);
        throw this._exception;
    }

    @Override
    public int getMatchCount() {
        return this._matchCount;
    }

    @Override
    public void reset() {
        super.reset();
        this._matchCount = 0;
        this._args = null;
        this._value = null;
    }

    @Override
    public String[] getArgs() {
        return this._args;
    }

    @Override
    public CliSchema toSchema() {
        CliSchema cliSchema = new CliSchema(this._alias, this.getClass(), this._value, this._description, new Schema[0]);
        cliSchema.put("MATCH_COUNT", this._matchCount);
        cliSchema.put("HAS_VALUE", this.hasValue());
        if (this._exception != null) {
            cliSchema.put("EXCEPTION", this._exception);
        }
        return cliSchema;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", args=" + Arrays.toString(this._args) + ", consumer=" + this._consumer + ", type=" + this._type + ", value=" + this._value + ", matchCount=" + this._matchCount + "]";
    }

    @Override
    public String toSyntax(CliContext cliContext) {
        return cliContext.toArgumentSpec(this);
    }

    protected void approve() {
        if (this._consumer != null) {
            this._consumer.accept(this);
        }
    }

    protected void setParsedArgs(String[] stringArray) {
        this._args = stringArray;
    }

    protected void setValue(T t) {
        this._value = t;
    }

    protected abstract T toType(String var1) throws ParseArgsException;
}

