/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseOptionArgsException;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.UnknownOptionArgsException;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;

public abstract class AbstractOption<T>
extends AbstractOperand<T>
implements Option<T> {
    private static final String LONG_OPTION_KEY = "LONG_OPTION";
    private static final String SHORT_OPTION_KEY = "SHORT_OPTION";
    private String _longOption;
    private Character _shortOption;

    public AbstractOption(Character c, String string, Class<T> clazz, String string2, String string3) {
        this(c, string, clazz, string2, string3, null);
    }

    public AbstractOption(Character c, String string, Class<T> clazz, String string2, String string3, Consumer<? extends Operand<T>> consumer) {
        super(clazz, string2 != null ? string2 : (string != null ? string : (c != null ? c.toString() : null)), string3, consumer);
        if (c == null && (string == null || string.isEmpty())) {
            throw new IllegalArgumentException("At least the short option <" + (Serializable)(c != null ? "'" + c + "'" : c) + "> must not be null or the long option <" + (String)(string != null ? "\"" + string + "\"" : string) + "> must not be empty!");
        }
        this._shortOption = c;
        this._longOption = string;
    }

    public AbstractOption(Relation<String, T> relation, Class<T> clazz) {
        this(relation, clazz, null);
    }

    public AbstractOption(Relation<String, T> relation, Class<T> clazz, Consumer<? extends Operand<T>> consumer) {
        super(relation, clazz, consumer);
        this._shortOption = ((String)relation.getKey()).length() == 1 ? Character.valueOf(((String)relation.getKey()).charAt(0)) : null;
        this._longOption = ((String)relation.getKey()).length() > 1 ? (String)relation.getKey() : null;
    }

    public AbstractOption(String string, Class<T> clazz, String string2) {
        this(null, string, clazz, null, string2);
    }

    public AbstractOption(String string, Class<T> clazz, String string2, Consumer<? extends Operand<T>> consumer) {
        this(null, string, clazz, null, string2, consumer);
    }

    public AbstractOption(String string, Class<T> clazz, String string2, String string3) {
        this(null, string, clazz, string2, string3);
    }

    public AbstractOption(String string, Class<T> clazz, String string2, String string3, Consumer<? extends Operand<T>> consumer) {
        this(null, string, clazz, string2, string3, consumer);
    }

    protected AbstractOption(Character c, String string, Class<T> clazz, String string2) {
        this(c, string, clazz, null, string2);
    }

    protected AbstractOption(Character c, String string, Class<T> clazz, String string2, Consumer<? extends Operand<T>> consumer) {
        this(c, string, clazz, null, string2, consumer);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getLongOption() {
        return this._longOption;
    }

    @Override
    public Character getShortOption() {
        return this._shortOption;
    }

    @Override
    public Operand<?>[] parseArgs(String[] stringArray, String[] stringArray2, CliContext cliContext) throws ArgsSyntaxException {
        Relation<String, String> relation = this.toOptionArgument(stringArray, stringArray2, cliContext);
        if (relation != null) {
            this.setParsedArgs(new String[]{(String)relation.getKey(), (String)relation.getValue()});
            this.setValue(this.toType((String)relation.getValue()));
            this._matchCount = 1;
            return new Operand[]{this};
        }
        if (AbstractOption.contains(stringArray, cliContext.toShortOption(this))) {
            this._exception = new ParseOptionArgsException("Missing value for option \"{0}\" requiring a value.", stringArray, cliContext.toShortOption(this), cliContext.toLongOption(this), (Term)this);
            throw this._exception;
        }
        if (AbstractOption.contains(stringArray, cliContext.toLongOption(this))) {
            this._exception = new ParseOptionArgsException("Missing value for option \"{1}\" requiring a value.", stringArray, cliContext.toShortOption(this), cliContext.toLongOption(this), (Term)this);
            throw this._exception;
        }
        this._exception = this.toException(stringArray, cliContext);
        throw this._exception;
    }

    @Override
    public CliSchema toSchema() {
        CliSchema cliSchema = super.toSchema();
        cliSchema.put(SHORT_OPTION_KEY, this._shortOption);
        cliSchema.put(LONG_OPTION_KEY, this._longOption);
        return cliSchema;
    }

    @Override
    public String toSyntax(CliContext cliContext) {
        return cliContext.toOptionEscapeCode() + cliContext.toOption(this) + cliContext.toResetEscapeCode() + (String)(this.getAlias() != null ? " " + cliContext.toArgumentSpec(this) : "") + cliContext.toResetEscapeCode();
    }

    protected UnknownArgsException toException(String[] stringArray, CliContext cliContext) {
        if (this.getShortOption() != null && this.getLongOption() != null) {
            return new UnknownOptionArgsException("Neither the short-option \"{0}\" nor the long-option \"{1}\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!", stringArray, cliContext.toShortOption(this), cliContext.toLongOption(this), (Term)this);
        }
        if (this.getShortOption() != null && this.getLongOption() == null) {
            return new UnknownOptionArgsException("No option \"{0}\" was found in the command line arguments, though it must be specified to match the according syntax branch!", stringArray, cliContext.toShortOption(this), cliContext.toLongOption(this), (Term)this);
        }
        if (this.getShortOption() == null && this.getLongOption() != null) {
            return new UnknownOptionArgsException("No option \"{1}\" was found in the command line arguments, though it must be specified to match the according syntax branch!", stringArray, cliContext.toShortOption(this), cliContext.toLongOption(this), (Term)this);
        }
        throw new IllegalStateException("At least a short-option or a long-option must be defined, but none has been configured!");
    }

    @Override
    protected void setParsedArgs(String[] stringArray) {
        super.setParsedArgs(stringArray);
    }

    @Override
    protected void setValue(T t) {
        super.setValue(t);
    }

    protected static boolean contains(String[] stringArray, String string) {
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            return arrayList.contains(string);
        }
        return false;
    }

    private Relation<String, String> toOptionArgument(String[] stringArray, String string, String[] stringArray2) {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string2 = stringArray[i];
            if (!string2.equals(string)) continue;
            String string3 = stringArray[i + 1];
            for (String string4 : stringArray2) {
                if (!string3.equalsIgnoreCase(string4)) continue;
                return null;
            }
            return new RelationImpl((Object)string, (Object)string3);
        }
        return null;
    }

    private Relation<String, String> toOptionArgument(String[] stringArray, String[] stringArray2, CliContext cliContext) {
        if (stringArray.length > 1) {
            Relation<String, String> relation = this.toOptionArgument(stringArray, cliContext.toShortOption(this), stringArray2);
            if (relation != null) {
                return relation;
            }
            relation = this.toOptionArgument(stringArray, cliContext.toLongOption(this), stringArray2);
            if (relation != null) {
                return relation;
            }
        }
        return null;
    }
}

