/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.ArgsFilter;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgs;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.cli.XorCondition;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.ArgsPrefix;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.Delimiter;
import org.refcodes.data.License;
import org.refcodes.data.Literal;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.mixin.Approvable;
import org.refcodes.runtime.Arguments;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.runtime.Terminal;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;
import org.refcodes.textual.AsciiArtBuilder;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxStyle;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParser
implements ParseArgs {
    private static final Logger LOGGER = Logger.getLogger(ArgsParser.class.getName());
    private static final String NULL_NAME = "<null>";
    private static final String DEFAULT_NAME = "foobar";
    private Term _argsSyntax;
    private String _argumentEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC});
    private String _bannerBorderEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT});
    private String _bannerEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private Font _bannerFont = new Font(FontFamily.DIALOG, FontStyle.PLAIN, 12);
    private char[] _bannerFontPalette = AsciiColorPalette.HALFTONE_GRAY.getPalette();
    private String _commandEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.ITALIC});
    private int _consoleWidth = Terminal.toPreferredWidth();
    private String _copyrightNote = License.COPYRIGHT_NOTE.getText();
    private String _description = "See the syntax declaration for usage, see the descriptions for the short- and the long-options. Option arguments are noted in angle brackets.";
    private String _descriptionEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR});
    private List<Example> _examples = null;
    private boolean _hasOverrideSeparatorLnChar = false;
    private boolean _isEscapeCodesEnabled = Terminal.isAnsiTerminalPreferred();
    private String _licenseNote = License.LICENSE_NOTE.getText();
    private String _lineBreak = Terminal.getLineBreak();
    private String _lineSeparatorEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT});
    private String _longOptionPrefix = SyntaxNotation.DEFAULT.getLongOptionPrefix();
    private int _maxConsoleWidth = -1;
    private String _name = "foobar";
    private String _optionEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _resetEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private Character _shortOptionPrefix = SyntaxNotation.DEFAULT.getShortOptionPrefix();
    private SyntaxMetrics _syntaxMetrics = SyntaxNotation.DEFAULT;
    private TextBoxGrid _textBoxGrid = TextBoxStyle.toExecutionTextBoxGrid();
    private char _separatorLnChar = ((Character)this._textBoxGrid.getInnerLine()).charValue();
    private String _title = null;
    protected PrintStream _errStream = Execution.toSystemErr();
    protected PrintStream _stdStream = Execution.toSystemOut();

    public ArgsParser() {
        this((Term)null);
    }

    public ArgsParser(CliContext cliContext) {
        this(null, cliContext);
    }

    public ArgsParser(Term term) {
        this._argsSyntax = term;
    }

    public ArgsParser(Term term, CliContext cliContext) {
        this._argsSyntax = term;
        this._syntaxMetrics = cliContext.getSyntaxMetrics();
        this._argumentEscapeCode = cliContext.getArgumentEscapeCode();
        this._optionEscapeCode = cliContext.getOptionEscapeCode();
        this._resetEscapeCode = cliContext.getResetEscapeCode();
        this._isEscapeCodesEnabled = cliContext.isEscapeCodesEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExample(Example example) {
        if (this._examples == null) {
            ArgsParser argsParser = this;
            synchronized (argsParser) {
                if (this._examples == null) {
                    this._examples = new ArrayList<Example>();
                }
            }
        }
        this._examples.add(example);
    }

    @Override
    public void errorLn(String string) {
        if (string == null) {
            string = "null";
        }
        String[] stringArray = ((TextBlockBuilder)new TextBlockBuilder().withText(new String[]{string})).withColumnWidth(this._consoleWidth).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._errStream.print(this.fromTextBlock(stringArray, this.toLineBreak()));
        this._errStream.flush();
    }

    @Override
    public Operand<?>[] evalArgs(String[] stringArray) throws ArgsSyntaxException {
        Object object;
        String string = SystemProperty.ARGS_FILTER.getValue();
        if (string != null && string.length() != 0) {
            object = ArgsFilter.toArgsFilter(string);
            if (object == null) {
                LOGGER.log(Level.WARNING, "The provided system property <" + SystemProperty.ARGS_FILTER.getKey() + "> with value <" + SystemProperty.ARGS_FILTER.getValue() + "> does not resolve to a valid args filter! Valid args filter values are: " + VerboseTextBuilder.asString((Object[])ArgsFilter.values()));
            } else {
                stringArray = object.toFiltered(stringArray);
            }
        }
        if (this._argsSyntax == null) {
            object = ArgsParser.fromArgs(stringArray, this.getDelimiter());
            ArgsParser.approve(object);
            return object;
        }
        object = this.toCliContext();
        stringArray = object.toExpandOptions(stringArray);
        Operand<?>[] operandArray = this._argsSyntax.parseArgs(stringArray, (CliContext)object);
        Object[] objectArray = AbstractTerm.toArgsDiff(stringArray, operandArray);
        if (objectArray != null && objectArray.length > 0) {
            throw new SuperfluousArgsException("Superfluous command arguments " + new VerboseTextBuilder().withElements(objectArray).toString() + " were provided but cannot be evaluated or are not supported as of the given combination of arguments.", (String[])objectArray, this._argsSyntax);
        }
        ArgsParser.approve(operandArray);
        return operandArray;
    }

    @Override
    public Term getArgsSyntax() {
        return this._argsSyntax;
    }

    @Override
    public String getArgumentEscapeCode() {
        return this._argumentEscapeCode;
    }

    @Override
    public String getBannerBorderEscapeCode() {
        return this._bannerBorderEscapeCode;
    }

    @Override
    public String getBannerEscapeCode() {
        return this._bannerEscapeCode;
    }

    @Override
    public Font getBannerFont() {
        return this._bannerFont;
    }

    @Override
    public char[] getBannerFontPalette() {
        return this._bannerFontPalette;
    }

    @Override
    public String getCommandEscapeCode() {
        return this._commandEscapeCode;
    }

    public int getConsoleWidth() {
        return this._consoleWidth;
    }

    @Override
    public String getCopyright() {
        return this._copyrightNote;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getDescriptionEscapeCode() {
        return this._descriptionEscapeCode;
    }

    @Override
    public Example[] getExamples() {
        return this._examples != null ? this._examples.toArray(new Example[this._examples.size()]) : null;
    }

    @Override
    public String getLicense() {
        return this._licenseNote;
    }

    public String getLineBreak() {
        return this._lineBreak;
    }

    @Override
    public String getLineSeparatorEscapeCode() {
        return this._lineSeparatorEscapeCode;
    }

    @Override
    public String getLongOptionPrefix() {
        return this._longOptionPrefix;
    }

    public int getMaxConsoleWidth() {
        return this._maxConsoleWidth;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public String getOptionEscapeCode() {
        return this._optionEscapeCode;
    }

    public String getResetEscapeCode() {
        return this._resetEscapeCode;
    }

    @Override
    public char getSeparatorLnChar() {
        return this._separatorLnChar;
    }

    @Override
    public Character getShortOptionPrefix() {
        return this._shortOptionPrefix;
    }

    @Override
    public SyntaxMetrics getSyntaxMetrics() {
        return this._syntaxMetrics;
    }

    public TextBoxGrid getTextBoxGrid() {
        return this._textBoxGrid;
    }

    public String getTitle() {
        return this._title;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscapeCodesEnabled;
    }

    @Override
    public void printBanner() {
        int n = this._consoleWidth - 4;
        String[] stringArray = ((AsciiArtBuilder)new AsciiArtBuilder().withText(new String[]{this._title != null ? this._title : (this._name != null ? this._name : NULL_NAME)})).withFont(this._bannerFont).withAsciiColors(this._bannerFontPalette).withColumnWidth(n).withAsciiArtMode(AsciiArtMode.NORMAL).withPixmapRatioMode(PixmapRatioMode.ONE_HALF).toStrings();
        boolean bl = this.hasBorder(stringArray);
        if (bl) {
            n = this._consoleWidth - 2;
        }
        stringArray = ((AsciiArtBuilder)new AsciiArtBuilder().withText(new String[]{this._title != null ? this._title : this._name})).withFont(this._bannerFont).withAsciiColors(this._bannerFontPalette).withColumnWidth(n).withAsciiArtMode(AsciiArtMode.NORMAL).withPixmapRatioMode(PixmapRatioMode.ONE_HALF).toStrings();
        stringArray = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(stringArray)).withColumnWidth(n).withFillChar(' ').toStrings();
        if (!bl) {
            stringArray = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(stringArray)).withBorderWidth(1).withBorderChar(' ').toStrings();
        }
        stringArray = ((TextBorderBuilder)new TextBorderBuilder().withTextBoxGrid(this._textBoxGrid).withText(stringArray)).withBoxBorderMode(BoxBorderMode.ALL).toStrings();
        if (this._isEscapeCodesEnabled) {
            stringArray[0] = this._bannerBorderEscapeCode + stringArray[0] + this._resetEscapeCode;
            if (stringArray.length > 1) {
                for (int i = 1; i < stringArray.length - 1; ++i) {
                    stringArray[i] = this._bannerBorderEscapeCode + stringArray[i].substring(0, 1) + this._resetEscapeCode + this._bannerEscapeCode + stringArray[i].substring(1, stringArray[i].length() - 1) + this._resetEscapeCode + this._bannerBorderEscapeCode + stringArray[i].substring(stringArray[i].length() - 1) + this._resetEscapeCode;
                }
            }
            stringArray[stringArray.length - 1] = this._bannerBorderEscapeCode + stringArray[stringArray.length - 1] + this._resetEscapeCode;
        }
        this._stdStream.print(this.fromTextBlock(stringArray, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printCopyright() {
        this._stdStream.println(this._copyrightNote);
        this._stdStream.flush();
    }

    @Override
    public void printDescription() {
        this._stdStream.println((this._isEscapeCodesEnabled ? this._descriptionEscapeCode : "") + this._description + (this._isEscapeCodesEnabled ? this._resetEscapeCode : ""));
        this._stdStream.flush();
    }

    @Override
    public void printExamples() {
        if (this._examples != null && this._examples.size() != 0) {
            int n = 0;
            for (Example object2 : this._examples) {
                String string = object2._description;
                if (string.length() <= n) continue;
                n = string.length();
            }
            if (n > this._consoleWidth / 2 && (n = this._consoleWidth / 2) < ConsoleDimension.MIN_WIDTH.getValue() / 2) {
                n = ConsoleDimension.MIN_WIDTH.getValue() / 2;
            }
            TableBuilder tableBuilder = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscapeCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(false);
            if (this._isEscapeCodesEnabled) {
                tableBuilder.setResetEscapeCode(this._resetEscapeCode);
            }
            tableBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(n, ColumnWidthType.ABSOLUTE);
            if (this._isEscapeCodesEnabled) {
                tableBuilder.withRowColumnEscapeCode(this._descriptionEscapeCode);
            }
            tableBuilder.addColumn().withColumnWidth(2, ColumnWidthType.ABSOLUTE);
            tableBuilder.addColumn().withColumnWidth(this._name.length(), ColumnWidthType.ABSOLUTE);
            tableBuilder.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            tableBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
            tableBuilder.withLineBreak(this.toLineBreak());
            String string = (this._isEscapeCodesEnabled ? this._commandEscapeCode : "") + this._name + (this._isEscapeCodesEnabled ? this._resetEscapeCode : "");
            for (Example example : this._examples) {
                Object object = "";
                for (Operand<?> operand : example.getOperands()) {
                    if (((String)object).length() != 0) {
                        object = (String)object + " ";
                    }
                    String string2 = operand.toSpec(this.toCliContext());
                    object = (String)object + string2;
                }
                tableBuilder.printRowContinue(new String[]{example.getDescription(), ": ", string, " ", object});
            }
        }
    }

    @Override
    public void printHeader() {
        int n;
        String[] stringArray = AsciiArtBuilder.asSimpleBanner((String)(this._title != null ? this._title : this._name), (int)(n = this._consoleWidth - 4), (AsciiArtMode)AsciiArtMode.NORMAL, (char[])this._bannerFontPalette);
        boolean bl = this.hasBorder(stringArray);
        if (bl) {
            n = this._consoleWidth - 2;
        }
        stringArray = AsciiArtBuilder.asSimpleBanner((String)(this._title != null ? this._title : this._name), (int)n, (AsciiArtMode)AsciiArtMode.NORMAL, (char[])this._bannerFontPalette);
        stringArray = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(stringArray)).withColumnWidth(n).withFillChar(' ').toStrings();
        if (!bl) {
            stringArray = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(stringArray)).withBorderWidth(1).withBorderChar(' ').toStrings();
        }
        stringArray = ((TextBorderBuilder)new TextBorderBuilder().withTextBoxGrid(this._textBoxGrid).withText(stringArray)).withBoxBorderMode(BoxBorderMode.ALL).toStrings();
        if (this._isEscapeCodesEnabled) {
            stringArray[0] = this._bannerBorderEscapeCode + stringArray[0] + this._resetEscapeCode;
            if (stringArray.length > 1) {
                for (int i = 1; i < stringArray.length - 1; ++i) {
                    stringArray[i] = this._bannerBorderEscapeCode + stringArray[i].substring(0, 1) + this._resetEscapeCode + this._bannerEscapeCode + stringArray[i].substring(1, stringArray[i].length() - 1) + this._resetEscapeCode + this._bannerBorderEscapeCode + stringArray[i].substring(stringArray[i].length() - 1) + this._resetEscapeCode;
                }
            }
            stringArray[stringArray.length - 1] = this._bannerBorderEscapeCode + stringArray[stringArray.length - 1] + this._resetEscapeCode;
        }
        this._stdStream.print(this.fromTextBlock(stringArray, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printLicense() {
        this._stdStream.println(this._licenseNote);
        this._stdStream.flush();
    }

    @Override
    public void printLn() {
        this._stdStream.println();
        this._stdStream.flush();
    }

    @Override
    public void printLn(String string) {
        String[] stringArray = ((TextBlockBuilder)new TextBlockBuilder().withText(new String[]{string})).withColumnWidth(this._consoleWidth).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._stdStream.print(this.fromTextBlock(stringArray, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printOptions() {
        if (this._argsSyntax != null) {
            TableBuilder tableBuilder;
            Object object;
            Term term = this._argsSyntax;
            if (term instanceof Condition) {
                object = (Condition)term;
                tableBuilder = object.toOperands();
            } else {
                term = this._argsSyntax;
                if (term instanceof Operand) {
                    Operand operand = (Operand)term;
                    tableBuilder = new Operand[]{operand};
                } else {
                    throw new IllegalStateException("The args syntax of type <" + this._argsSyntax.getClass().getName() + "> is neither of type <" + Condition.class.getName() + "> nor <" + Operand.class.getName() + "> and therefor no operands are available for processing!");
                }
            }
            object = new HashMap();
            int n = 0;
            for (Operand<?> operand : tableBuilder) {
                String string = operand.toSpec(this.toCliContext());
                int n2 = AnsiEscapeCode.toLength((String)string, (boolean)this._isEscapeCodesEnabled);
                if (n2 > n) {
                    n = n2;
                }
                object.put(string, new String[]{string, ":", " ", operand.getDescription()});
            }
            TableBuilder tableBuilder2 = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscapeCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(false);
            tableBuilder2.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(n, ColumnWidthType.ABSOLUTE);
            tableBuilder2.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            tableBuilder2.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            tableBuilder2.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
            if (this._isEscapeCodesEnabled) {
                tableBuilder2.withRowColumnEscapeCode(this._descriptionEscapeCode);
            }
            tableBuilder2.withLineBreak(this.toLineBreak());
            ArrayList arrayList = new ArrayList(object.keySet());
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string != null) {
                        while (string.startsWith("-")) {
                            string = string.substring(1);
                        }
                    }
                    if (string2 != null) {
                        while (string2.startsWith("-")) {
                            string2 = string2.substring(1);
                        }
                    }
                    return string.compareToIgnoreCase(string2);
                }
            });
            for (Operand<?> operand : arrayList) {
                tableBuilder2.printRowContinue((String[])object.get(operand));
            }
        }
    }

    @Override
    public void printSeparatorLn() {
        String string = new TextLineBuilder().withColumnWidth(this._consoleWidth).withLineChar(this._separatorLnChar).toString() + this.toLineBreak();
        if (this._isEscapeCodesEnabled) {
            string = this._lineSeparatorEscapeCode + string + this._resetEscapeCode;
        }
        this._stdStream.print(string);
        this._stdStream.flush();
    }

    @Override
    public void printSynopsis() {
        Term[] termArray;
        XorCondition xorCondition;
        Object object = this._argsSyntax;
        if (object instanceof XorCondition) {
            xorCondition = (XorCondition)object;
            termArray = xorCondition._children;
        } else {
            termArray = new Term[]{this._argsSyntax};
        }
        xorCondition = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscapeCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(true);
        if (this._isEscapeCodesEnabled) {
            xorCondition.setResetEscapeCode(this._resetEscapeCode);
        }
        xorCondition.addColumn().withColumnWidth(this._name != null ? this._name.length() : 0, ColumnWidthType.ABSOLUTE).withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        xorCondition.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
        xorCondition.withLineBreak(this.toLineBreak());
        object = (this._isEscapeCodesEnabled ? this._commandEscapeCode : "") + (this._name != null ? this._name : "") + (this._isEscapeCodesEnabled ? this._resetEscapeCode : "");
        for (Term term : termArray) {
            String string = term != null ? term.toSynopsis(this.toCliContext()) : "<?>";
            xorCondition.printRowContinue(new String[]{object, string});
        }
        this._stdStream.flush();
    }

    public void reset() {
        if (this._argsSyntax != null) {
            this._argsSyntax.reset();
        }
    }

    @Override
    public void setArgsSyntax(Term term) {
        this._argsSyntax = term;
    }

    @Override
    public void setArgumentEscapeCode(String string) {
        this._argumentEscapeCode = string;
    }

    @Override
    public void setBannerBorderEscapeCode(String string) {
        this._bannerBorderEscapeCode = string;
    }

    @Override
    public void setBannerEscapeCode(String string) {
        this._bannerEscapeCode = string;
    }

    @Override
    public void setBannerFont(Font font) {
        this._bannerFont = font;
    }

    @Override
    public void setBannerFontPalette(AsciiColorPalette asciiColorPalette) {
        this._bannerFontPalette = asciiColorPalette.getPalette();
    }

    @Override
    public void setBannerFontPalette(char[] cArray) {
        this._bannerFontPalette = cArray;
    }

    @Override
    public void setCommandEscapeCode(String string) {
        this._commandEscapeCode = string;
    }

    public void setConsoleWidth(int n) {
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < n ? this._maxConsoleWidth : n) : n;
    }

    @Override
    public void setCopyright(String string) {
        this._copyrightNote = string;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    @Override
    public void setDescriptionEscapeCode(String string) {
        this._descriptionEscapeCode = string;
    }

    @Override
    public void setErrorOut(PrintStream printStream) {
        this._errStream = printStream;
    }

    public void setEscapeCodesEnabled(boolean bl) {
        this._isEscapeCodesEnabled = bl;
    }

    @Override
    public void setExamples(Example[] exampleArray) {
        this._examples = new ArrayList<Example>(Arrays.asList(exampleArray));
    }

    @Override
    public void setLicense(String string) {
        this._licenseNote = string;
    }

    public void setLineBreak(String string) {
        if (string == null) {
            string = Terminal.getLineBreak();
        }
        this._lineBreak = string;
    }

    @Override
    public void setLineSeparatorEscapeCode(String string) {
        this._lineSeparatorEscapeCode = string;
    }

    @Override
    public void setLongOptionPrefix(String string) {
        this._longOptionPrefix = string;
    }

    public void setMaxConsoleWidth(int n) {
        this._maxConsoleWidth = n;
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < this._consoleWidth ? this._maxConsoleWidth : this._consoleWidth) : this._consoleWidth;
    }

    public void setName(String string) {
        this._name = string;
    }

    @Override
    public void setOptionEscapeCode(String string) {
        this._optionEscapeCode = string;
    }

    public void setResetEscapeCode(String string) {
        this._resetEscapeCode = string;
    }

    @Override
    public void setSeparatorLnChar(char c) {
        this._separatorLnChar = c;
        this._hasOverrideSeparatorLnChar = true;
    }

    @Override
    public void setShortOptionPrefix(Character c) {
        this._shortOptionPrefix = c;
    }

    @Override
    public void setStandardOut(PrintStream printStream) {
        this._stdStream = printStream;
    }

    @Override
    public void setSyntaxMetrics(SyntaxMetrics syntaxMetrics) {
        this._syntaxMetrics = syntaxMetrics;
    }

    public void setTextBoxGrid(TextBoxGrid textBoxGrid) {
        this._textBoxGrid = textBoxGrid;
        if (!this._hasOverrideSeparatorLnChar) {
            this._separatorLnChar = ((Character)textBoxGrid.getInnerLine()).charValue();
        }
    }

    public void setTitle(String string) {
        this._title = string;
    }

    @Override
    public ArgsParser withAddExample(Example example) {
        this.addExample(example);
        return this;
    }

    @Override
    public ArgsParser withAddExample(String string, Operand<?> ... operandArray) {
        this.addExample(string, operandArray);
        return this;
    }

    @Override
    public ArgsParser withArgsSyntax(Term term) {
        this.setArgsSyntax(term);
        return this;
    }

    @Override
    public ArgsParser withArgumentEscapeCode(String string) {
        this.setArgumentEscapeCode(string);
        return this;
    }

    @Override
    public ArgsParser withBannerBorderEscapeCode(String string) {
        this.setBannerBorderEscapeCode(string);
        return this;
    }

    @Override
    public ArgsParser withBannerEscapeCode(String string) {
        this.setBannerEscapeCode(string);
        return this;
    }

    @Override
    public ArgsParser withBannerFont(Font font) {
        this.setBannerFont(font);
        return this;
    }

    @Override
    public ArgsParser withBannerFontPalette(AsciiColorPalette asciiColorPalette) {
        this.setBannerFontPalette(asciiColorPalette);
        return this;
    }

    @Override
    public ArgsParser withBannerFontPalette(char[] cArray) {
        this.setBannerFontPalette(cArray);
        return this;
    }

    @Override
    public ArgsParser withCommandEscapeCode(String string) {
        this.setCommandEscapeCode(string);
        return this;
    }

    @Override
    public ArgsParser withConsoleWidth(int n) {
        this.setConsoleWidth(n);
        return this;
    }

    @Override
    public ArgsParser withCopyright(String string) {
        this.setCopyright(string);
        return this;
    }

    @Override
    public ArgsParser withDescription(String string) {
        this.setDescription(string);
        return this;
    }

    @Override
    public ArgsParser withDescriptionEscapeCode(String string) {
        this.setDescriptionEscapeCode(string);
        return this;
    }

    @Override
    public ArgsParser withErrorOut(PrintStream printStream) {
        this.setErrorOut(printStream);
        return this;
    }

    @Override
    public ArgsParser withEscapeCodesEnabled(boolean bl) {
        this.setEscapeCodesEnabled(bl);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(List<String> list) throws ArgsSyntaxException {
        this.evalArgs(list);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(List<String> list, ArgsFilter argsFilter) throws ArgsSyntaxException {
        this.evalArgs(list, argsFilter);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(List<String> list, Pattern pattern) throws ArgsSyntaxException {
        this.evalArgs(list, pattern);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(String[] stringArray) throws ArgsSyntaxException {
        this.evalArgs(stringArray);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(String[] stringArray, ArgsFilter argsFilter) throws ArgsSyntaxException {
        this.evalArgs(stringArray, argsFilter);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(String[] stringArray, Pattern pattern) throws ArgsSyntaxException {
        this.evalArgs(stringArray, pattern);
        return this;
    }

    @Override
    public ArgsParser withExamples(Collection<Example> collection) {
        this.setExamples(collection);
        return this;
    }

    @Override
    public ArgsParser withExamples(Example[] exampleArray) {
        this.setExamples(exampleArray);
        return this;
    }

    @Override
    public ArgsParser withLicense(String string) {
        this.setLicense(string);
        return this;
    }

    @Override
    public ArgsParser withLineBreak(String string) {
        this.setLineBreak(string);
        return this;
    }

    @Override
    public ArgsParser withLineSeparatorEscapeCode(String string) {
        this.setLineSeparatorEscapeCode(string);
        return this;
    }

    @Override
    public ArgsParser withLongOptionPrefix(String string) {
        this.setLongOptionPrefix(string);
        return this;
    }

    @Override
    public ArgsParser withMaxConsoleWidth(int n) {
        this.setMaxConsoleWidth(n);
        return this;
    }

    @Override
    public ArgsParser withName(String string) {
        this.setName(string);
        return this;
    }

    @Override
    public ArgsParser withOptionEscapeCode(String string) {
        this.setOptionEscapeCode(string);
        return this;
    }

    @Override
    public ArgsParser withResetEscapeCode(String string) {
        this.setResetEscapeCode(string);
        return this;
    }

    @Override
    public ArgsParser withSeparatorLnChar(char c) {
        this.setSeparatorLnChar(c);
        return this;
    }

    @Override
    public ArgsParser withShortOptionPrefix(Character c) {
        this.setShortOptionPrefix(c);
        return this;
    }

    @Override
    public ArgsParser withStandardOut(PrintStream printStream) {
        this.setStandardOut(printStream);
        return this;
    }

    @Override
    public ArgsParser withSyntaxMetrics(SyntaxMetrics syntaxMetrics) {
        this.setSyntaxMetrics(syntaxMetrics);
        return this;
    }

    @Override
    public ArgsParser withSyntaxMetrics(SyntaxNotation syntaxNotation) {
        this.setSyntaxMetrics(syntaxNotation);
        return this;
    }

    @Override
    public ArgsParser withTextBoxGrid(TextBoxGrid textBoxGrid) {
        this.setTextBoxGrid(textBoxGrid);
        return this;
    }

    @Override
    public ArgsParser withTextBoxGrid(TextBoxStyle textBoxStyle) {
        this.setTextBoxGrid(textBoxStyle);
        return this;
    }

    @Override
    public ArgsParser withTitle(String string) {
        this.setTitle(string);
        return this;
    }

    private String fromTextBlock(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (string != null && string.length() != 0 && stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString() + this.toLineBreak();
    }

    private boolean hasBorder(String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            int n;
            char c = stringArray[0].length() != 0 ? (char)stringArray[0].charAt(0) : (char)' ';
            for (n = 0; n < stringArray[0].length(); ++n) {
                if (c != stringArray[0].charAt(n)) {
                    return false;
                }
                c = stringArray[0].charAt(n);
            }
            for (n = 0; n < stringArray[stringArray.length - 1].length(); ++n) {
                if (c != stringArray[stringArray.length - 1].charAt(n)) {
                    return false;
                }
                c = stringArray[stringArray.length - 1].charAt(n);
            }
            for (String string : stringArray) {
                if (c != string.charAt(0)) {
                    return false;
                }
                c = string.charAt(0);
            }
            for (String string : stringArray) {
                if (c != string.charAt(string.length() - 1)) {
                    return false;
                }
                c = string.charAt(string.length() - 1);
            }
        }
        return true;
    }

    protected char getDelimiter() {
        return Delimiter.INDEX.getChar();
    }

    private CliContext toCliContext() {
        String string = SystemProperty.ARGS_NOTATION.getValue();
        SyntaxNotation syntaxNotation = SyntaxNotation.toSyntaxNotation(string);
        CliContext cliContext = new CliContext(this, syntaxNotation);
        return cliContext;
    }

    private String toLineBreak() {
        if (Terminal.isLineBreakRequired((int)this._consoleWidth)) {
            return this._lineBreak;
        }
        return "";
    }

    private static void approve(Operand<?>[] operandArray) {
        for (Operand<?> operand : operandArray) {
            if (operand instanceof AbstractOperand) {
                AbstractOperand abstractOperand = (AbstractOperand)operand;
                abstractOperand.approve();
                continue;
            }
            if (!(operand instanceof Approvable)) continue;
            Approvable approvable = (Approvable)operand;
            approvable.approve();
        }
    }

    private static Operand<?>[] fromArgs(String[] stringArray, char c) {
        ArrayList<AbstractOperand> arrayList = new ArrayList<AbstractOperand>();
        Map map = Arguments.toProperties((String[])stringArray, (String[])ArgsPrefix.toPrefixes(), (char)c);
        for (String string : map.keySet()) {
            if (Literal.TRUE.getValue().equalsIgnoreCase((String)map.get(string))) {
                arrayList.add(new Flag((Relation<String, Boolean>)new RelationImpl((Object)string, (Object)Boolean.TRUE)));
                continue;
            }
            arrayList.add(new StringOperand((Relation<String, String>)new PropertyImpl(string, (String)map.get(string))));
        }
        return arrayList.toArray(new Operand[arrayList.size()]);
    }
}

