/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.refcodes.cli.ArgumentEscapeCodeAccessor;
import org.refcodes.cli.ArrayOperand;
import org.refcodes.cli.CliMetrics;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Flag;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.OptionEscapeCodeAccessor;
import org.refcodes.cli.Optionable;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxMetricsAccessor;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.runtime.Terminal;

public class CliContext
implements CliMetrics,
Optionable {
    private String _argumentEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC});
    private boolean _isEscapeCodesEnabled = Terminal.isAnsiTerminalPreferred();
    private String _optionEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _resetEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private SyntaxMetrics _syntaxMetrics = SyntaxNotation.LOGICAL;

    public CliContext() {
    }

    public CliContext(boolean bl) {
        this._isEscapeCodesEnabled = bl;
    }

    public CliContext(CliMetrics cliMetrics) {
        this._syntaxMetrics = cliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = cliMetrics.isEscapeCodesEnabled();
        this._argumentEscapeCode = cliMetrics.getArgumentEscapeCode();
        this._optionEscapeCode = cliMetrics.getOptionEscapeCode();
        this._resetEscapeCode = cliMetrics.getResetEscapeCode();
    }

    public CliContext(CliMetrics cliMetrics, SyntaxMetrics syntaxMetrics) {
        this._syntaxMetrics = syntaxMetrics != null ? syntaxMetrics : cliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = cliMetrics.isEscapeCodesEnabled();
        this._argumentEscapeCode = cliMetrics.getArgumentEscapeCode();
        this._optionEscapeCode = cliMetrics.getOptionEscapeCode();
        this._resetEscapeCode = cliMetrics.getResetEscapeCode();
    }

    public CliContext(String string, String string2, String string3) {
        this._argumentEscapeCode = string;
        this._optionEscapeCode = string2;
        this._resetEscapeCode = string3;
    }

    public CliContext(SyntaxMetrics syntaxMetrics) {
        this._syntaxMetrics = syntaxMetrics;
    }

    public CliContext(SyntaxMetrics syntaxMetrics, boolean bl) {
        this._syntaxMetrics = syntaxMetrics;
        this._isEscapeCodesEnabled = bl;
    }

    public CliContext(SyntaxMetrics syntaxMetrics, Character c, String string, boolean bl, String string2, String string3, String string4) {
        this._syntaxMetrics = syntaxMetrics;
        this._isEscapeCodesEnabled = bl;
        this._argumentEscapeCode = string2;
        this._optionEscapeCode = string3;
        this._resetEscapeCode = string4;
    }

    public CliContext(SyntaxMetrics syntaxMetrics, String string, String string2, String string3) {
        this._syntaxMetrics = syntaxMetrics;
        this._argumentEscapeCode = string;
        this._optionEscapeCode = string2;
        this._resetEscapeCode = string3;
    }

    private CliContext(Builder builder) {
        this._syntaxMetrics = builder.syntaxMetrics;
        this._argumentEscapeCode = builder.argumentEscapeCode;
        this._optionEscapeCode = builder.optionEscapeCode;
        this._resetEscapeCode = builder.resetEscapeCode;
        this._isEscapeCodesEnabled = builder.isEscapeCodesEnabled;
    }

    @Override
    public String getArgumentEscapeCode() {
        return this._argumentEscapeCode;
    }

    @Override
    public String getOptionEscapeCode() {
        return this._optionEscapeCode;
    }

    public String getResetEscapeCode() {
        return this._resetEscapeCode;
    }

    @Override
    public SyntaxMetrics getSyntaxMetrics() {
        return this._syntaxMetrics;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscapeCodesEnabled;
    }

    public boolean isOption(String string) {
        if (string != null && string.length() != 0) {
            if (this._syntaxMetrics.getLongOptionPrefix() != null && string.startsWith(this._syntaxMetrics.getLongOptionPrefix())) {
                return true;
            }
            if (this._syntaxMetrics.getShortOptionPrefix() != null && this._syntaxMetrics.getShortOptionPrefix().equals(Character.valueOf(string.charAt(0)))) {
                return true;
            }
        }
        return false;
    }

    public String[] toAllOptions(Term term) {
        Term term2;
        HashSet<String> hashSet = new HashSet<String>();
        if (term instanceof Condition) {
            term2 = (Condition)term;
            for (Operand<?> operand : term2.toOperands()) {
                String[] stringArray = this.toAllOptions(operand);
                if (stringArray == null || stringArray.length == 0) continue;
                hashSet.addAll(Arrays.asList(stringArray));
            }
        }
        if (term instanceof Option) {
            term2 = (Option)term;
            String string = this.toShortOption((Option<?>)term2);
            String string2 = this.toLongOption((Option<?>)term2);
            if (string != null) {
                hashSet.add(string);
            }
            if (string2 != null) {
                hashSet.add(string2);
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String toArgumentEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._argumentEscapeCode != null ? this._argumentEscapeCode : "") : "";
    }

    public String toArgumentSpec(Operand<?> operand) {
        if (operand instanceof ArrayOperand) {
            ArrayOperand arrayOperand = (ArrayOperand)operand;
            return this.toArgumentSpec(operand, arrayOperand.getMinLength(), arrayOperand.getMaxLength());
        }
        return this.toArgumentSpec(operand, -1, -1);
    }

    public String toArgumentSpec(Operand<?> operand, int n, int n2) {
        if (operand.getAlias() == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!(operand instanceof Flag) && operand.getAlias() != null) {
            if (operand instanceof Option) {
                stringBuilder.append(this.getSyntaxMetrics().getArgumentPrefix());
            }
            stringBuilder.append((String)(operand instanceof NoneOperand ? operand.toSyntax(this) : this.toArgumentEscapeCode() + operand.getAlias()) + this.toResetEscapeCode());
            if (operand.getType().isArray()) {
                stringBuilder.append(this._syntaxMetrics.getBeginArraySymbol());
            } else if (n != -1 || n2 != -1) {
                stringBuilder.append(this._syntaxMetrics.getBeginRangeSymbol());
            }
            if (n != -1 && n == n2) {
                stringBuilder.append(n);
            } else {
                if (n != -1) {
                    stringBuilder.append(n);
                }
                if (operand.getType().isArray() || n != -1 || n2 != -1) {
                    stringBuilder.append(this._syntaxMetrics.getIntervalSymbol());
                }
                if (n2 != -1) {
                    stringBuilder.append(n2);
                }
            }
            if (operand.getType().isArray()) {
                stringBuilder.append(this._syntaxMetrics.getEndArraySymbol());
            } else if (n != -1 || n2 != -1) {
                stringBuilder.append(this._syntaxMetrics.getEndRangeSymbol());
            }
            if (operand instanceof Option) {
                stringBuilder.append(this._syntaxMetrics.getArgumentSuffix());
            }
        }
        return stringBuilder.toString();
    }

    public String[] toExpandOptions(String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.getSyntaxMetrics().getShortOptionPrefix() != null) {
            for (String string : stringArray) {
                if (string.length() > 2 && string.charAt(2) != '=' && (this.getSyntaxMetrics().getLongOptionPrefix() == null || this.getSyntaxMetrics().getLongOptionPrefix().isEmpty() || !string.startsWith(this.getSyntaxMetrics().getLongOptionPrefix())) && string.charAt(0) == this.getSyntaxMetrics().getShortOptionPrefix().charValue()) {
                    for (int i = 1; i < string.length(); ++i) {
                        arrayList.add(this.getSyntaxMetrics().getShortOptionPrefix().toString() + string.charAt(i));
                    }
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toLongOption(Option<?> option) {
        return option != null && option.getLongOption() != null ? this._syntaxMetrics.getLongOptionPrefix() + option.getLongOption() : null;
    }

    public String toOption(Option<?> option) {
        String string = this.toShortOption(option);
        return string != null ? string : this.toLongOption(option);
    }

    public String toOptionEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._optionEscapeCode != null ? this._optionEscapeCode : "") : "";
    }

    @Override
    public String[] toOptions(Option<?> option) {
        return CliContext.toOptions(option, this._syntaxMetrics.getShortOptionPrefix(), this._syntaxMetrics.getLongOptionPrefix());
    }

    public String toResetEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._resetEscapeCode != null ? this._resetEscapeCode : "") : "";
    }

    public String toShortOption(Option<?> option) {
        return option != null && option.getShortOption() != null ? this._syntaxMetrics.getShortOptionPrefix().toString() + option.getShortOption() : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    static String[] toOptions(Option<?> option, Character c, String string) {
        String string2;
        String string3;
        int n = 0;
        String string4 = option != null && option.getShortOption() != null ? (c != null ? c.toString() : "") + option.getShortOption() : (string3 = null);
        String string5 = option != null && option.getLongOption() != null ? (string != null ? string : "") + option.getLongOption() : (string2 = null);
        if (string3 != null) {
            ++n;
        }
        if (string2 != null) {
            ++n;
        }
        String[] stringArray = new String[n];
        n = 0;
        if (string3 != null) {
            stringArray[n] = string3;
            ++n;
        }
        if (string2 != null) {
            stringArray[n] = string2;
        }
        return stringArray;
    }

    public static final class Builder
    implements SyntaxMetricsAccessor.SyntaxMetricsBuilder<Builder>,
    ArgumentEscapeCodeAccessor.ArgumentEscapeCodeBuilder<Builder>,
    OptionEscapeCodeAccessor.OptionEscapeCodeBuilder<Builder>,
    ResetEscapeCodeAccessor.ResetEscapeCodeBuilder<Builder>,
    EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<Builder> {
        private String argumentEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC});
        private boolean isEscapeCodesEnabled = Terminal.isAnsiTerminalPreferred();
        private String optionEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
        private String resetEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
        private SyntaxMetrics syntaxMetrics = SyntaxNotation.LOGICAL;

        private Builder() {
        }

        public CliContext build() {
            return new CliContext(this);
        }

        @Override
        public Builder withArgumentEscapeCode(String string) {
            this.argumentEscapeCode = string;
            return this;
        }

        public Builder withEscapeCodesEnabled(boolean bl) {
            this.isEscapeCodesEnabled = bl;
            return this;
        }

        @Override
        public Builder withOptionEscapeCode(String string) {
            this.optionEscapeCode = string;
            return this;
        }

        public Builder withResetEscapeCode(String string) {
            this.resetEscapeCode = string;
            return this;
        }

        @Override
        public Builder withSyntaxMetrics(SyntaxMetrics syntaxMetrics) {
            this.syntaxMetrics = syntaxMetrics;
            return this;
        }
    }
}

