/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Term;

public class OrCondition
extends AbstractCondition {
    public OrCondition(Term ... termArray) {
        super("At least one (OR) syntax branch must match from the command line arguments.", termArray);
    }

    @Override
    public Operand<?>[] parseArgs(String[] stringArray, String[] stringArray2, CliContext cliContext) throws ArgsSyntaxException {
        ArrayList arrayList = null;
        ArgsSyntaxException argsSyntaxException = null;
        for (Term term : this._children) {
            try {
                Operand<?>[] operandArray = term.parseArgs(stringArray, stringArray2, cliContext);
                if (operandArray != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    for (Operand<?> operand : operandArray) {
                        arrayList.add(operand);
                    }
                }
                stringArray = OrCondition.toArgsDiff(stringArray, operandArray);
            }
            catch (ArgsSyntaxException argsSyntaxException2) {
                if (argsSyntaxException == null) {
                    argsSyntaxException = argsSyntaxException2;
                    continue;
                }
                argsSyntaxException.addSuppressed((Throwable)((Object)argsSyntaxException2));
            }
        }
        if (arrayList != null) {
            return arrayList.toArray(new Operand[arrayList.size()]);
        }
        this._exception = new ArgsSyntaxException("Not any syntax branch matched the command line arguments, though at least one (OR) syntax branch must be matched by the command line arguments!", stringArray, (Term)this, (Throwable)((Object)argsSyntaxException));
        throw this._exception;
    }

    @Override
    public String toSynopsis(CliContext cliContext) {
        Object object = "";
        for (Term term : this._children) {
            if (((String)object).length() != 0) {
                object = (String)object + (String)(cliContext.getSyntaxMetrics().getOrSymbol() != null && cliContext.getSyntaxMetrics().getOrSymbol().length() != 0 ? " " + cliContext.getSyntaxMetrics().getOrSymbol() + " " : " ");
            }
            object = (String)object + term.toSyntax(cliContext);
        }
        return object;
    }
}

