/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.data.ArgsPrefix;

public enum SyntaxNotation implements SyntaxMetrics
{
    GNU_POSIX(Character.valueOf(ArgsPrefix.POSIX_SHORT_OPTION.getPrefix().charAt(0)), ArgsPrefix.POSIX_LONG_OPTION.getPrefix(), "<", ">", "{", "}", "[", "]", "[", "]", "{", "}", "...", "{}", null, null, null, "?", "|"),
    LOGICAL(Character.valueOf(ArgsPrefix.POSIX_SHORT_OPTION.getPrefix().charAt(0)), ArgsPrefix.POSIX_LONG_OPTION.getPrefix(), "<", ">", "(", ")", "[", "]", "[", "]", "{", "}", "\u2026", "\u2205", "\u2200", "?", "&", "|", "^"),
    VERBOSE(Character.valueOf(ArgsPrefix.POSIX_SHORT_OPTION.getPrefix().charAt(0)), ArgsPrefix.POSIX_LONG_OPTION.getPrefix(), "<", ">", "{", "}", "{", "}", "[", "]", "{", "}", "-", "EMPTY", "ALL", "ANY", "AND", "OR", "XOR"),
    WINDOWS(Character.valueOf(ArgsPrefix.WINDOWS_SHORT_OPTION.getPrefix().charAt(0)), ArgsPrefix.WINDOWS_LONG_OPTION.getPrefix(), "$", "", "{", "}", "[", "]", "[", "]", "{", "}", "...", "{}", null, null, null, "?", "|");

    public static final SyntaxNotation DEFAULT;
    private String _allSymString;
    private String _andSymbol;
    private String _anySymbol;
    private String _argumentPrefix;
    private String _argumentSuffix;
    private String _beginArraySymbol;
    private String _beginListSymbol;
    private String _beginOptionalSymbol;
    private String _beginRangeSymbol;
    private String _emptySymbol;
    private String _endArraySymbol;
    private String _endListSymbol;
    private String _endOptionalSymbol;
    private String _endRangeSymbol;
    private String _intervalSymbol;
    private String _longOptionPrefix;
    private String _orSymbol;
    private Character _shortOptionPrefix;
    private String _xorSymString;

    private SyntaxNotation(Character c, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19) {
        this._argumentPrefix = string3;
        this._argumentSuffix = string4;
        this._shortOptionPrefix = c;
        this._longOptionPrefix = string2;
        this._beginListSymbol = string5;
        this._endListSymbol = string6;
        this._xorSymString = string19;
        this._orSymbol = string18;
        this._allSymString = string15;
        this._andSymbol = string17;
        this._anySymbol = string16;
        this._beginOptionalSymbol = string9;
        this._endOptionalSymbol = string10;
        this._intervalSymbol = string13;
        this._beginRangeSymbol = string11;
        this._endRangeSymbol = string12;
        this._beginArraySymbol = string7;
        this._endArraySymbol = string8;
        this._emptySymbol = string14;
    }

    @Override
    public String getAllSymbol() {
        return this._allSymString;
    }

    @Override
    public String getAndSymbol() {
        return this._andSymbol;
    }

    @Override
    public String getAnySymbol() {
        return this._anySymbol;
    }

    @Override
    public String getArgumentPrefix() {
        return this._argumentPrefix;
    }

    @Override
    public String getArgumentSuffix() {
        return this._argumentSuffix;
    }

    @Override
    public String getBeginArraySymbol() {
        return this._beginArraySymbol;
    }

    @Override
    public String getBeginListSymbol() {
        return this._beginListSymbol;
    }

    @Override
    public String getBeginOptionalSymbol() {
        return this._beginOptionalSymbol;
    }

    @Override
    public String getBeginRangeSymbol() {
        return this._beginRangeSymbol;
    }

    @Override
    public String getEmptySymbol() {
        return this._emptySymbol;
    }

    @Override
    public String getEndArraySymbol() {
        return this._endArraySymbol;
    }

    @Override
    public String getEndListSymbol() {
        return this._endListSymbol;
    }

    @Override
    public String getEndOptionalSymbol() {
        return this._endOptionalSymbol;
    }

    @Override
    public String getEndRangeSymbol() {
        return this._endRangeSymbol;
    }

    @Override
    public String getIntervalSymbol() {
        return this._intervalSymbol;
    }

    @Override
    public String getLongOptionPrefix() {
        return this._longOptionPrefix;
    }

    @Override
    public String getOrSymbol() {
        return this._orSymbol;
    }

    @Override
    public Character getShortOptionPrefix() {
        return this._shortOptionPrefix;
    }

    @Override
    public String getXorSymbol() {
        return this._xorSymString;
    }

    public static SyntaxNotation toSyntaxNotation(String string) {
        string = string != null ? string.replaceAll("-", "").replaceAll("_", "") : string;
        for (SyntaxNotation syntaxNotation : SyntaxNotation.values()) {
            if (!syntaxNotation.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(string)) continue;
            return syntaxNotation;
        }
        return null;
    }

    static {
        DEFAULT = GNU_POSIX;
    }
}

