/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;

public class XorCondition
extends AbstractCondition {
    public XorCondition(Term ... termArray) {
        super("Exactly one (XOR) syntax branch must match from the command line arguments.", termArray);
    }

    protected XorCondition(String string, Term ... termArray) {
        super(string, termArray);
    }

    @Override
    public Operand<?>[] parseArgs(String[] stringArray, String[] stringArray2, CliContext cliContext) throws ArgsSyntaxException {
        ArrayList<AnyCondition> arrayList = new ArrayList<AnyCondition>();
        Operand<?>[] operandArray = null;
        Term term = null;
        Operand<?>[] operandArray2 = null;
        int n = this._children.length;
        ArgsSyntaxException argsSyntaxException = null;
        for (Term term2 : this._children) {
            if (term2 instanceof AnyCondition) {
                arrayList.add((AnyCondition)term2);
            }
            try {
                operandArray2 = operandArray != null && term2 instanceof Operand && term instanceof Option ? term2.parseArgs(XorCondition.toArgsDiff(stringArray, operandArray), stringArray2, cliContext) : term2.parseArgs(stringArray, stringArray2, cliContext);
                if (operandArray2 != null && operandArray2.length == 0) {
                    operandArray2 = null;
                }
            }
            catch (ArgsSyntaxException argsSyntaxException2) {
                if (argsSyntaxException == null) {
                    argsSyntaxException = argsSyntaxException2;
                } else {
                    argsSyntaxException.addSuppressed((Throwable)((Object)argsSyntaxException2));
                }
                --n;
            }
            operandArray = XorCondition.removeDuplicates(operandArray, operandArray2);
            if (operandArray != null && operandArray2 != null) {
                this._exception = new AmbiguousArgsException("More than one syntax branch matched the command line arguments, though exactly one (XOR) syntax branch must match!", stringArray, (Term)this, (Throwable)((Object)argsSyntaxException));
                throw this._exception;
            }
            if (operandArray2 != null && operandArray2.length != 0 && operandArray == null) {
                operandArray = operandArray2;
                term = term2;
            }
            operandArray2 = null;
        }
        if (n == 0) {
            this._exception = new UnknownArgsException("No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match!", stringArray, (Term)this, (Throwable)((Object)argsSyntaxException));
            throw this._exception;
        }
        if (n > 1) {
            if (arrayList.size() > 1 && stringArray != null && stringArray.length > 0) {
                this._exception = new AmbiguousArgsException("No syntax branch (fully) matched the command line arguments causing exclusive (XOR) ambiguity for the according syntax branch!", stringArray, (Term)this, (Throwable)((Object)argsSyntaxException));
                throw this._exception;
            }
            if ((n -= arrayList.size()) > 1) {
                this._exception = new AmbiguousArgsException("No syntax branch (fully) matched the command line arguments causing exclusive (XOR) ambiguity for the according syntax branch!", stringArray, (Term)this, (Throwable)((Object)argsSyntaxException));
                throw this._exception;
            }
        }
        if (operandArray != null) {
            return operandArray;
        }
        if (arrayList.size() == 0) {
            return new Operand[0];
        }
        this._exception = new UnknownArgsException("No syntax branch (fully) matched the provided command line arguments, though one (XOR) syntax branch must match!", stringArray, (Term)this, (Throwable)((Object)argsSyntaxException));
        throw this._exception;
    }

    @Override
    public String toSynopsis(CliContext cliContext) {
        Object object = "";
        for (Term term : this._children) {
            if (((String)object).length() != 0) {
                object = (String)object + (String)(cliContext.getSyntaxMetrics().getXorSymbol() != null && cliContext.getSyntaxMetrics().getXorSymbol().length() != 0 ? " " + cliContext.getSyntaxMetrics().getXorSymbol() + " " : " ");
            }
            object = (String)object + term.toSyntax(cliContext);
        }
        return object;
    }

    private static Operand<?>[] removeDuplicates(Operand<?>[] operandArray, Operand<?>[] operandArray2) {
        if (operandArray != null && operandArray2 != null) {
            ArrayList arrayList = new ArrayList();
            for (Operand<?> operand : operandArray) {
                arrayList.add(operand);
            }
            for (Operand<?> operand : operandArray2) {
                if (!arrayList.contains(operand)) continue;
                arrayList.remove(operand);
            }
            operandArray = arrayList.isEmpty() ? null : arrayList.toArray(new Operand[arrayList.size()]);
        }
        return operandArray;
    }
}

