// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import static org.refcodes.cli.CliSugar.*;
import org.junit.jupiter.api.Test;
import org.refcodes.runtime.SystemProperty;

public class SyntaxNotationTest {

	// /////////////////////////////////////////////////////////////////////////
	// TESTS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testSyntaxNotations() {
		if ( SystemProperty.LOG_TESTS.isEnabled() ) {
			for ( SyntaxNotation eNotation : SyntaxNotation.values() ) {
				System.out.println( eNotation + ".emptySymbol=" + eNotation.getEmptySymbol() );
				System.out.println( eNotation + ".allSymbol=" + eNotation.getAllSymbol() );
				System.out.println( eNotation + ".andSymbol=" + eNotation.getAndSymbol() );
				System.out.println( eNotation + ".anySymbol=" + eNotation.getAnySymbol() );
				System.out.println( eNotation + ".orSymbol=" + eNotation.getOrSymbol() );
				System.out.println( eNotation + ".xorSymbol=" + eNotation.getXorSymbol() );
				System.out.println( eNotation + ".argumentPrefix=" + eNotation.getArgumentPrefix() );
				System.out.println( eNotation + ".argumentSuffix=" + eNotation.getArgumentSuffix() );
				System.out.println( eNotation + ".beginArraySymbol=" + eNotation.getBeginArraySymbol() );
				System.out.println( eNotation + ".beginListSymbol=" + eNotation.getBeginListSymbol() );
				System.out.println( eNotation + ".beginOptionalSymbol=" + eNotation.getBeginOptionalSymbol() );
				System.out.println( eNotation + ".beginRangeSymbol=" + eNotation.getBeginRangeSymbol() );
				System.out.println( eNotation + ".endArraySymbol=" + eNotation.getEndArraySymbol() );
				System.out.println( eNotation + ".endListSymbol=" + eNotation.getEndListSymbol() );
				System.out.println( eNotation + ".endOptionalSymbol=" + eNotation.getEndOptionalSymbol() );
				System.out.println( eNotation + ".endRangeSymbol=" + eNotation.getEndRangeSymbol() );
				System.out.println( eNotation + ".intervalSymbol=" + eNotation.getIntervalSymbol() );
				System.out.println( eNotation + ".longOptionPrefix=" + eNotation.getLongOptionPrefix() );
				System.out.println( eNotation + ".shortOptionPrefix=" + eNotation.getShortOptionPrefix() );
				System.out.println();
			}
		}
	}

	@Test
	public void testSynopsis() {
		if ( SystemProperty.LOG_TESTS.isEnabled() ) {
			final Condition theArgsSyntax = cases( and( debugFlag(), verboseFlag() ), xor( helpFlag(), and( sysInfoFlag(), any( verboseFlag() ) ) ) );
			System.out.println( theArgsSyntax.toSynopsis( SyntaxNotation.GNU_POSIX ) );
			System.out.println();
			System.out.println( theArgsSyntax.toSchema() );
		}
	}
}
