/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.function.Consumer;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.mixin.EnabledAccessor;

public class Operation
extends AbstractOperand<Boolean>
implements EnabledAccessor {
    private String _operation;

    public Operation(String aOperation, String aDescription) {
        this(aOperation, aOperation, aDescription, null);
    }

    public Operation(String aOperation, String aDescription, Consumer<Operation> aConsumer) {
        this(aOperation, aOperation, aDescription, aConsumer);
    }

    public Operation(String aOperation, String aAlias, String aDescription) {
        this(aOperation, aAlias, aDescription, null);
    }

    public Operation(String aOperation, String aAlias, String aDescription, Consumer<Operation> aConsumer) {
        super(Boolean.class, aAlias, aDescription, aConsumer);
        if (aOperation == null) {
            throw new IllegalArgumentException("The operation argument must not be null!");
        }
        this._operation = aOperation;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getOperation() {
        return this._operation;
    }

    public boolean isEnabled() {
        Boolean theValue = (Boolean)this.getValue();
        if (theValue != null) {
            return theValue;
        }
        return false;
    }

    @Override
    public Operand<Boolean>[] parseArgs(String[] aArgs, String[] aOptions, CliContext aCliContext) throws ArgsSyntaxException {
        boolean hasOperation;
        if (aArgs != null) {
            for (String aArg : aArgs) {
                if (!this.getOperation().equals(aArg)) continue;
                hasOperation = true;
                break;
            }
        } else {
            hasOperation = false;
        }
        if (hasOperation) {
            this.setParsedArgs(new String[]{this.getOperation()});
            this.setValue(true);
            this._matchCount = 1;
            return new Operand[]{this};
        }
        this._exception = new UnknownArgsException("The operation \"" + this.getOperation() + "\" was found in the command line arguments.", aArgs, this);
        throw this._exception;
    }

    @Override
    public void reset() {
        super.reset();
        super.setValue(false);
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return aCliCtx.toOptionEscapeCode() + this.getOperation() + (String)(this.getAlias() != null ? " " + aCliCtx.toArgumentSpec(this) : "") + aCliCtx.toResetEscapeCode();
    }

    @Override
    protected Boolean toType(String aArg) throws ParseArgsException {
        throw new UnsupportedOperationException("*** NOT REQUIRED BY THIS IMPLEMENTATION ***");
    }
}

