/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class OptionalConditionTest {
    @Test
    public void testOptionalEdgeCase() {
        IntOption theWidth = CliSugar.intOption((Character)Character.valueOf('w'), (String)"width", (String)"width", (String)"Sets the console width");
        IntOption thePortOption = CliSugar.intOption((Character)Character.valueOf('p'), (String)"port", (String)"port", (String)"Sets the port for the server");
        IntOption theMaxConns = CliSugar.intOption((Character)Character.valueOf('c'), (String)"connections", (String)"connections", (String)"Sets the number of max. connections");
        StringOption theUsername = CliSugar.stringOption((Character)Character.valueOf('u'), (String)"user", (String)"username", (String)"The username for HTTP Basic-Authentication");
        StringOption theSecret = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"secret", (String)"secret", (String)"The password for HTTP Basic-Authentication");
        Flag theSysInfo = CliSugar.flag(null, (String)"sysinfo", (String)"sysInfo", (String)"Shows some system information");
        IntOption theMgmPortOption = CliSugar.intOption((Character)Character.valueOf('m'), (String)"management-port", (String)"management-port", (String)"The management-port on which to listen for shutdown...");
        HelpFlag theHelp = CliSugar.helpFlag((String)"Shows this help");
        AnyCondition theRoot = CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{thePortOption, theMaxConns, CliSugar.and((Term[])new Term[]{theUsername, theSecret}), theWidth, theMgmPortOption}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theHelp, theSysInfo})})})});
        ArgsParser theParseArgs = new ArgsParser((Term)theRoot);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        theParseArgs.withName("TinyRestful").withTitle("TINYRESTFUL").withCopyright("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicense("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        theParseArgs.withBannerFont(new Font(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        theParseArgs.withDescription("Tiny evil RESTful server. TinyRestfulServer makes heavy use of the REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        String[] args = new String[]{"-p", "8080", "--sysinfo"};
        try {
            theParseArgs.evalArgs(args);
            Assertions.fail((String)("Expecting a <" + SuperfluousArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(new VerboseTextBuilder().withElements((Object[])e.getArgs()).toString());
            }
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(e.toHeuristicMessage());
            }
            Assertions.assertEquals((int)3, (int)e.getArgs().length);
        }
    }
}

