/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.ArgsFilter;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgs;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.cli.XorCondition;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.ArgsPrefix;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.Delimiter;
import org.refcodes.data.License;
import org.refcodes.data.Literal;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.mixin.Approvable;
import org.refcodes.runtime.Arguments;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.runtime.Terminal;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;
import org.refcodes.textual.AsciiArtBuilder;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxStyle;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParser
implements ParseArgs {
    private static final Logger LOGGER = Logger.getLogger(ArgsParser.class.getName());
    private static final String NULL_NAME = "<null>";
    private static final String DEFAULT_NAME = "foobar";
    private Term _argsSyntax;
    private String _argumentEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC});
    private String _bannerBorderEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT});
    private String _bannerEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private Font _bannerFont = new Font(FontFamily.DIALOG, FontStyle.PLAIN, 12);
    private char[] _bannerFontPalette = AsciiColorPalette.HALFTONE_GRAY.getPalette();
    private String _commandEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.ITALIC});
    private int _consoleWidth = Terminal.toHeuristicWidth();
    private String _copyrightNote = License.COPYRIGHT_NOTE.getText();
    private String _description = "See the syntax declaration for usage, see the descriptions for the short- and the long-options. Option arguments are noted in angle brackets.";
    private String _descriptionEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR});
    private List<Example> _examples = null;
    private boolean _hasOverrideSeparatorLnChar = false;
    private boolean _isEscapeCodesEnabled = Terminal.isAnsiTerminalEnabled();
    private String _licenseNote = License.LICENSE_NOTE.getText();
    private String _lineBreak = Terminal.getLineBreak();
    private String _lineSeparatorEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT});
    private String _longOptionPrefix = SyntaxNotation.DEFAULT.getLongOptionPrefix();
    private int _maxConsoleWidth = -1;
    private String _name = "foobar";
    private String _optionEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _resetEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private Character _shortOptionPrefix = SyntaxNotation.DEFAULT.getShortOptionPrefix();
    private SyntaxMetrics _syntaxMetrics = SyntaxNotation.DEFAULT;
    private TextBoxGrid _textBoxGrid = TextBoxStyle.toExecutionTextBoxGrid();
    private char _separatorLnChar = ((Character)this._textBoxGrid.getInnerLine()).charValue();
    private String _title = null;
    protected PrintStream _errStream = Execution.toSystemErr();
    protected PrintStream _stdStream = Execution.toSystemOut();

    public ArgsParser() {
        this((Term)null);
    }

    public ArgsParser(CliContext aCliCtx) {
        this(null, aCliCtx);
    }

    public ArgsParser(Term aArgsSyntax) {
        this._argsSyntax = aArgsSyntax;
    }

    public ArgsParser(Term aArgsSyntax, CliContext aCliCtx) {
        this._argsSyntax = aArgsSyntax;
        this._syntaxMetrics = aCliCtx.getSyntaxMetrics();
        this._argumentEscapeCode = aCliCtx.getArgumentEscapeCode();
        this._optionEscapeCode = aCliCtx.getOptionEscapeCode();
        this._resetEscapeCode = aCliCtx.getResetEscapeCode();
        this._isEscapeCodesEnabled = aCliCtx.isEscapeCodesEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExample(Example aExampleUsage) {
        if (this._examples == null) {
            ArgsParser argsParser = this;
            synchronized (argsParser) {
                if (this._examples == null) {
                    this._examples = new ArrayList<Example>();
                }
            }
        }
        this._examples.add(aExampleUsage);
    }

    @Override
    public void errorLn(String aLine) {
        if (aLine == null) {
            aLine = "null";
        }
        String[] theLines = ((TextBlockBuilder)new TextBlockBuilder().withText(new String[]{aLine})).withColumnWidth(this._consoleWidth).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._errStream.print(this.fromTextBlock(theLines, this.toLineBreak()));
        this._errStream.flush();
    }

    @Override
    public Operand<?>[] evalArgs(String[] aArgs) throws ArgsSyntaxException {
        String theFilterProperty = SystemProperty.ARGS_FILTER.getValue();
        if (theFilterProperty != null && theFilterProperty.length() != 0) {
            ArgsFilter theArgsFilter = ArgsFilter.toArgsFilter(theFilterProperty);
            if (theArgsFilter == null) {
                LOGGER.log(Level.WARNING, "The provided system property <" + SystemProperty.ARGS_FILTER.getKey() + "> with value <" + SystemProperty.ARGS_FILTER.getValue() + "> does not resolve to a valid args filter! Valid args filter values are: " + VerboseTextBuilder.asString((Object[])ArgsFilter.values()));
            } else {
                aArgs = theArgsFilter.toFiltered(aArgs);
            }
        }
        CliContext theCliCtx = this.toCliContext(false);
        if (this._argsSyntax == null) {
            Operand<?>[] theOperands = ArgsParser.fromArgs(aArgs, this.getDelimiter());
            ArgsParser.approve(theOperands, theCliCtx);
            return theOperands;
        }
        aArgs = theCliCtx.toExpandOptions(aArgs);
        Operand<?>[] theOperands = this._argsSyntax.parseArgs(aArgs, theCliCtx);
        Object[] theSuperflousArgs = AbstractTerm.toArgsDiff(aArgs, theOperands);
        if (theSuperflousArgs != null && theSuperflousArgs.length > 0) {
            throw new SuperfluousArgsException("Superfluous command arguments " + new VerboseTextBuilder().withElements(theSuperflousArgs).toString() + " were provided but cannot be evaluated or are not supported as of the given combination of arguments.", (String[])theSuperflousArgs, this._argsSyntax);
        }
        ArgsParser.approve(theOperands, theCliCtx);
        return theOperands;
    }

    @Override
    public Term getArgsSyntax() {
        return this._argsSyntax;
    }

    @Override
    public String getArgumentEscapeCode() {
        return this._argumentEscapeCode;
    }

    @Override
    public String getBannerBorderEscapeCode() {
        return this._bannerBorderEscapeCode;
    }

    @Override
    public String getBannerEscapeCode() {
        return this._bannerEscapeCode;
    }

    @Override
    public Font getBannerFont() {
        return this._bannerFont;
    }

    @Override
    public char[] getBannerFontPalette() {
        return this._bannerFontPalette;
    }

    @Override
    public String getCommandEscapeCode() {
        return this._commandEscapeCode;
    }

    public int getConsoleWidth() {
        return this._consoleWidth;
    }

    @Override
    public String getCopyright() {
        return this._copyrightNote;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getDescriptionEscapeCode() {
        return this._descriptionEscapeCode;
    }

    @Override
    public Example[] getExamples() {
        return this._examples != null ? this._examples.toArray(new Example[this._examples.size()]) : null;
    }

    @Override
    public String getLicense() {
        return this._licenseNote;
    }

    public String getLineBreak() {
        return this._lineBreak;
    }

    @Override
    public String getLineSeparatorEscapeCode() {
        return this._lineSeparatorEscapeCode;
    }

    @Override
    public String getLongOptionPrefix() {
        return this._longOptionPrefix;
    }

    public int getMaxConsoleWidth() {
        return this._maxConsoleWidth;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public String getOptionEscapeCode() {
        return this._optionEscapeCode;
    }

    public String getResetEscapeCode() {
        return this._resetEscapeCode;
    }

    @Override
    public char getSeparatorLnChar() {
        return this._separatorLnChar;
    }

    @Override
    public Character getShortOptionPrefix() {
        return this._shortOptionPrefix;
    }

    @Override
    public SyntaxMetrics getSyntaxMetrics() {
        return this._syntaxMetrics;
    }

    public TextBoxGrid getTextBoxGrid() {
        return this._textBoxGrid;
    }

    public String getTitle() {
        return this._title;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscapeCodesEnabled;
    }

    @Override
    public void printBanner() {
        int theBannerWidth = this._consoleWidth - 4;
        String[] theCanvas = ((AsciiArtBuilder)new AsciiArtBuilder().withText(new String[]{this._title != null ? this._title : (this._name != null ? this._name : NULL_NAME)})).withFont(this._bannerFont).withAsciiColors(this._bannerFontPalette).withColumnWidth(theBannerWidth).withAsciiArtMode(AsciiArtMode.NORMAL).withPixmapRatioMode(PixmapRatioMode.ONE_HALF).toStrings();
        boolean hasBorder = this.hasBorder(theCanvas);
        if (hasBorder) {
            theBannerWidth = this._consoleWidth - 2;
        }
        theCanvas = ((AsciiArtBuilder)new AsciiArtBuilder().withText(new String[]{this._title != null ? this._title : this._name})).withFont(this._bannerFont).withAsciiColors(this._bannerFontPalette).withColumnWidth(theBannerWidth).withAsciiArtMode(AsciiArtMode.NORMAL).withPixmapRatioMode(PixmapRatioMode.ONE_HALF).toStrings();
        theCanvas = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(theCanvas)).withColumnWidth(theBannerWidth).withFillChar(' ').toStrings();
        if (!hasBorder) {
            theCanvas = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(theCanvas)).withBorderWidth(1).withBorderChar(' ').toStrings();
        }
        theCanvas = ((TextBorderBuilder)new TextBorderBuilder().withTextBoxGrid(this._textBoxGrid).withText(theCanvas)).withBoxBorderMode(BoxBorderMode.ALL).toStrings();
        if (this._isEscapeCodesEnabled) {
            theCanvas[0] = this._bannerBorderEscapeCode + theCanvas[0] + this._resetEscapeCode;
            if (theCanvas.length > 1) {
                for (int i = 1; i < theCanvas.length - 1; ++i) {
                    theCanvas[i] = this._bannerBorderEscapeCode + theCanvas[i].substring(0, 1) + this._resetEscapeCode + this._bannerEscapeCode + theCanvas[i].substring(1, theCanvas[i].length() - 1) + this._resetEscapeCode + this._bannerBorderEscapeCode + theCanvas[i].substring(theCanvas[i].length() - 1) + this._resetEscapeCode;
                }
            }
            theCanvas[theCanvas.length - 1] = this._bannerBorderEscapeCode + theCanvas[theCanvas.length - 1] + this._resetEscapeCode;
        }
        this._stdStream.print(this.fromTextBlock(theCanvas, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printCopyright() {
        this._stdStream.println(this._copyrightNote);
        this._stdStream.flush();
    }

    @Override
    public void printDescription() {
        this._stdStream.println((this._isEscapeCodesEnabled ? this._descriptionEscapeCode : "") + this._description + (this._isEscapeCodesEnabled ? this._resetEscapeCode : ""));
        this._stdStream.flush();
    }

    @Override
    public void printExamples() {
        if (this._examples != null && this._examples.size() != 0) {
            int theMaxLength = 0;
            for (Example eUsage : this._examples) {
                String eDescription = eUsage._description;
                if (eDescription.length() <= theMaxLength) continue;
                theMaxLength = eDescription.length();
            }
            if (theMaxLength > this._consoleWidth / 2 && (theMaxLength = this._consoleWidth / 2) < ConsoleDimension.MIN_WIDTH.getValue() / 2) {
                theMaxLength = ConsoleDimension.MIN_WIDTH.getValue() / 2;
            }
            TableBuilder theTable = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscapeCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(false);
            if (this._isEscapeCodesEnabled) {
                theTable.setResetEscapeCode(this._resetEscapeCode);
            }
            theTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(theMaxLength, ColumnWidthType.ABSOLUTE);
            if (this._isEscapeCodesEnabled) {
                theTable.withRowColumnEscapeCode(this._descriptionEscapeCode);
            }
            theTable.addColumn().withColumnWidth(2, ColumnWidthType.ABSOLUTE);
            theTable.addColumn().withColumnWidth(this._name.length(), ColumnWidthType.ABSOLUTE);
            theTable.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            theTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
            theTable.withLineBreak(this.toLineBreak());
            String theCommand = (this._isEscapeCodesEnabled ? this._commandEscapeCode : "") + this._name + (this._isEscapeCodesEnabled ? this._resetEscapeCode : "");
            if (this._examples != null && this._examples.size() != 0) {
                CliContext theCliContext = this.toCliContext();
                for (Example eUsage : this._examples) {
                    Object eArgs = "";
                    for (Operand<?> eOperand : eUsage.getOperands()) {
                        if (((String)eArgs).length() != 0) {
                            eArgs = (String)eArgs + " ";
                        }
                        String eOpt = eOperand.toUsage(theCliContext);
                        eArgs = (String)eArgs + eOpt;
                    }
                    theTable.printRowContinue(new String[]{eUsage.getDescription(), ": ", theCommand, " ", eArgs});
                }
            }
        }
    }

    @Override
    public void printHeader() {
        int theBannerWidth;
        String[] theCanvas = AsciiArtBuilder.asSimpleBanner((String)(this._title != null ? this._title : this._name), (int)(theBannerWidth = this._consoleWidth - 4), (AsciiArtMode)AsciiArtMode.NORMAL, (char[])this._bannerFontPalette);
        boolean hasBorder = this.hasBorder(theCanvas);
        if (hasBorder) {
            theBannerWidth = this._consoleWidth - 2;
        }
        theCanvas = AsciiArtBuilder.asSimpleBanner((String)(this._title != null ? this._title : this._name), (int)theBannerWidth, (AsciiArtMode)AsciiArtMode.NORMAL, (char[])this._bannerFontPalette);
        theCanvas = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(theCanvas)).withColumnWidth(theBannerWidth).withFillChar(' ').toStrings();
        if (!hasBorder) {
            theCanvas = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(theCanvas)).withBorderWidth(1).withBorderChar(' ').toStrings();
        }
        theCanvas = ((TextBorderBuilder)new TextBorderBuilder().withTextBoxGrid(this._textBoxGrid).withText(theCanvas)).withBoxBorderMode(BoxBorderMode.ALL).toStrings();
        if (this._isEscapeCodesEnabled) {
            theCanvas[0] = this._bannerBorderEscapeCode + theCanvas[0] + this._resetEscapeCode;
            if (theCanvas.length > 1) {
                for (int i = 1; i < theCanvas.length - 1; ++i) {
                    theCanvas[i] = this._bannerBorderEscapeCode + theCanvas[i].substring(0, 1) + this._resetEscapeCode + this._bannerEscapeCode + theCanvas[i].substring(1, theCanvas[i].length() - 1) + this._resetEscapeCode + this._bannerBorderEscapeCode + theCanvas[i].substring(theCanvas[i].length() - 1) + this._resetEscapeCode;
                }
            }
            theCanvas[theCanvas.length - 1] = this._bannerBorderEscapeCode + theCanvas[theCanvas.length - 1] + this._resetEscapeCode;
        }
        this._stdStream.print(this.fromTextBlock(theCanvas, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printLicense() {
        this._stdStream.println(this._licenseNote);
        this._stdStream.flush();
    }

    @Override
    public void printLn() {
        this._stdStream.println();
        this._stdStream.flush();
    }

    @Override
    public void printLn(String aLine) {
        String[] theLines = ((TextBlockBuilder)new TextBlockBuilder().withText(new String[]{aLine})).withColumnWidth(this._consoleWidth).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._stdStream.print(this.fromTextBlock(theLines, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printOptions() {
        if (this._argsSyntax != null) {
            Operand<?>[] theOperands;
            Term term = this._argsSyntax;
            if (term instanceof Condition) {
                Condition theCondition = (Condition)term;
                theOperands = theCondition.toOperands();
            } else {
                term = this._argsSyntax;
                if (term instanceof Operand) {
                    Operand theOperand = (Operand)term;
                    theOperands = new Operand[]{theOperand};
                } else {
                    throw new IllegalStateException("The args syntax of type <" + this._argsSyntax.getClass().getName() + "> is neither of type <" + Condition.class.getName() + "> nor <" + Operand.class.getName() + "> and therefor no operands are available for processing!");
                }
            }
            HashMap<String, String[]> theOptArgs = new HashMap<String, String[]>();
            int theMaxLength = 0;
            if (theOperands != null && theOperands.length != 0) {
                CliContext theCliContext = this.toCliContext();
                for (Operand<?> eOperand : theOperands) {
                    String eOpt = theCliContext.toSpec(eOperand);
                    int eEffectiveLength = AnsiEscapeCode.toLength((String)eOpt, (boolean)this._isEscapeCodesEnabled);
                    if (eEffectiveLength > theMaxLength) {
                        theMaxLength = eEffectiveLength;
                    }
                    theOptArgs.put(eOpt, new String[]{eOpt, ":", " ", eOperand.getDescription()});
                }
            }
            TableBuilder theTable = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscapeCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(false);
            theTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(theMaxLength, ColumnWidthType.ABSOLUTE);
            theTable.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            theTable.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            theTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
            if (this._isEscapeCodesEnabled) {
                theTable.withRowColumnEscapeCode(this._descriptionEscapeCode);
            }
            theTable.withLineBreak(this.toLineBreak());
            ArrayList theKeys = new ArrayList(theOptArgs.keySet());
            theKeys.sort(new Comparator<String>(){

                @Override
                public int compare(String a, String b) {
                    if (a != null) {
                        while (a.startsWith("-")) {
                            a = a.substring(1);
                        }
                    }
                    if (b != null) {
                        while (b.startsWith("-")) {
                            b = b.substring(1);
                        }
                    }
                    return a.compareToIgnoreCase(b);
                }
            });
            for (String eKey : theKeys) {
                theTable.printRowContinue((String[])theOptArgs.get(eKey));
            }
        }
    }

    @Override
    public void printSeparatorLn() {
        String theLine = new TextLineBuilder().withColumnWidth(this._consoleWidth).withLineChar(this._separatorLnChar).toString() + this.toLineBreak();
        if (this._isEscapeCodesEnabled) {
            theLine = this._lineSeparatorEscapeCode + theLine + this._resetEscapeCode;
        }
        this._stdStream.print(theLine);
        this._stdStream.flush();
    }

    @Override
    public void printSynopsis() {
        Term[] theChildren;
        Term term = this._argsSyntax;
        if (term instanceof XorCondition) {
            XorCondition theCases = (XorCondition)term;
            theChildren = theCases._children;
        } else {
            theChildren = new Term[]{this._argsSyntax};
        }
        TableBuilder theTable = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscapeCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(true);
        if (this._isEscapeCodesEnabled) {
            theTable.setResetEscapeCode(this._resetEscapeCode);
        }
        theTable.addColumn().withColumnWidth(this._name != null ? this._name.length() : 0, ColumnWidthType.ABSOLUTE).withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        theTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
        theTable.withLineBreak(this.toLineBreak());
        String theCommand = (this._isEscapeCodesEnabled ? this._commandEscapeCode : "") + (this._name != null ? this._name : "") + (this._isEscapeCodesEnabled ? this._resetEscapeCode : "");
        for (Term eChild : theChildren) {
            String eUsage = eChild != null ? eChild.toSynopsis(this.toCliContext()) : "<?>";
            theTable.printRowContinue(new String[]{theCommand, eUsage});
        }
        this._stdStream.flush();
    }

    public void reset() {
        if (this._argsSyntax != null) {
            this._argsSyntax.reset();
        }
    }

    @Override
    public void setArgsSyntax(Term aArgsSyntax) {
        this._argsSyntax = aArgsSyntax;
    }

    @Override
    public void setArgumentEscapeCode(String aParamEscapeCode) {
        this._argumentEscapeCode = aParamEscapeCode;
    }

    @Override
    public void setBannerBorderEscapeCode(String aBannerBorderEscapeCode) {
        this._bannerBorderEscapeCode = aBannerBorderEscapeCode;
    }

    @Override
    public void setBannerEscapeCode(String aBannerEscapeCode) {
        this._bannerEscapeCode = aBannerEscapeCode;
    }

    @Override
    public void setBannerFont(Font aBannerFont) {
        this._bannerFont = aBannerFont;
    }

    @Override
    public void setBannerFontPalette(AsciiColorPalette aBannerFontPalette) {
        this._bannerFontPalette = aBannerFontPalette.getPalette();
    }

    @Override
    public void setBannerFontPalette(char[] aColorPalette) {
        this._bannerFontPalette = aColorPalette;
    }

    @Override
    public void setCommandEscapeCode(String aCommandEscapeCode) {
        this._commandEscapeCode = aCommandEscapeCode;
    }

    public void setConsoleWidth(int aConsoleWidth) {
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < aConsoleWidth ? this._maxConsoleWidth : aConsoleWidth) : aConsoleWidth;
    }

    @Override
    public void setCopyright(String aCopyrightNote) {
        this._copyrightNote = aCopyrightNote;
    }

    public void setDescription(String aDescription) {
        this._description = aDescription;
    }

    @Override
    public void setDescriptionEscapeCode(String aDescriptionEscapeCode) {
        this._descriptionEscapeCode = aDescriptionEscapeCode;
    }

    @Override
    public void setErrorOut(PrintStream aErrorOut) {
        this._errStream = aErrorOut;
    }

    public void setEscapeCodesEnabled(boolean isEscapeCodesEnabled) {
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
    }

    @Override
    public void setExamples(Example[] aExamples) {
        this._examples = new ArrayList<Example>(Arrays.asList(aExamples));
    }

    @Override
    public void setLicense(String aLicenseNote) {
        this._licenseNote = aLicenseNote;
    }

    public void setLineBreak(String aLineBreak) {
        if (aLineBreak == null) {
            aLineBreak = Terminal.getLineBreak();
        }
        this._lineBreak = aLineBreak;
    }

    @Override
    public void setLineSeparatorEscapeCode(String aLineSeparatorEscapeCode) {
        this._lineSeparatorEscapeCode = aLineSeparatorEscapeCode;
    }

    @Override
    public void setLongOptionPrefix(String aLongOptionPrefix) {
        this._longOptionPrefix = aLongOptionPrefix;
    }

    public void setMaxConsoleWidth(int aMaxConsoleWidth) {
        this._maxConsoleWidth = aMaxConsoleWidth;
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < this._consoleWidth ? this._maxConsoleWidth : this._consoleWidth) : this._consoleWidth;
    }

    public void setName(String aName) {
        this._name = aName;
    }

    @Override
    public void setOptionEscapeCode(String aOptEscapeCode) {
        this._optionEscapeCode = aOptEscapeCode;
    }

    public void setResetEscapeCode(String aResetEscapeCode) {
        this._resetEscapeCode = aResetEscapeCode;
    }

    @Override
    public void setSeparatorLnChar(char aSeparatorLnChar) {
        this._separatorLnChar = aSeparatorLnChar;
        this._hasOverrideSeparatorLnChar = true;
    }

    @Override
    public void setShortOptionPrefix(Character aShortOptionPrefix) {
        this._shortOptionPrefix = aShortOptionPrefix;
    }

    @Override
    public void setStandardOut(PrintStream aStandardOut) {
        this._stdStream = aStandardOut;
    }

    @Override
    public void setSyntaxMetrics(SyntaxMetrics aSyntaxMetrics) {
        this._syntaxMetrics = aSyntaxMetrics;
    }

    public void setTextBoxGrid(TextBoxGrid aTextBoxGrid) {
        this._textBoxGrid = aTextBoxGrid;
        if (!this._hasOverrideSeparatorLnChar) {
            this._separatorLnChar = ((Character)aTextBoxGrid.getInnerLine()).charValue();
        }
    }

    public void setTitle(String aTitle) {
        this._title = aTitle;
    }

    @Override
    public ArgsParser withAddExample(Example aExamples) {
        this.addExample(aExamples);
        return this;
    }

    @Override
    public ArgsParser withAddExample(String aDescription, Operand<?> ... aOperands) {
        this.addExample(aDescription, aOperands);
        return this;
    }

    @Override
    public ArgsParser withArgsSyntax(Term aArgsSyntax) {
        this.setArgsSyntax(aArgsSyntax);
        return this;
    }

    @Override
    public ArgsParser withArgumentEscapeCode(String aParamEscCode) {
        this.setArgumentEscapeCode(aParamEscCode);
        return this;
    }

    @Override
    public ArgsParser withBannerBorderEscapeCode(String aBannerBorderEscCode) {
        this.setBannerBorderEscapeCode(aBannerBorderEscCode);
        return this;
    }

    @Override
    public ArgsParser withBannerEscapeCode(String aBannerEscCode) {
        this.setBannerEscapeCode(aBannerEscCode);
        return this;
    }

    @Override
    public ArgsParser withBannerFont(Font aBannerFont) {
        this.setBannerFont(aBannerFont);
        return this;
    }

    @Override
    public ArgsParser withBannerFontPalette(AsciiColorPalette aBannerFontPalette) {
        this.setBannerFontPalette(aBannerFontPalette);
        return this;
    }

    @Override
    public ArgsParser withBannerFontPalette(char[] aColorPalette) {
        this.setBannerFontPalette(aColorPalette);
        return this;
    }

    @Override
    public ArgsParser withCommandEscapeCode(String aCommandEscCode) {
        this.setCommandEscapeCode(aCommandEscCode);
        return this;
    }

    @Override
    public ArgsParser withConsoleWidth(int aConsoleWidth) {
        this.setConsoleWidth(aConsoleWidth);
        return this;
    }

    @Override
    public ArgsParser withCopyright(String aCopyright) {
        this.setCopyright(aCopyright);
        return this;
    }

    @Override
    public ArgsParser withDescription(String aDescription) {
        this.setDescription(aDescription);
        return this;
    }

    @Override
    public ArgsParser withDescriptionEscapeCode(String aDescriptionEscCode) {
        this.setDescriptionEscapeCode(aDescriptionEscCode);
        return this;
    }

    @Override
    public ArgsParser withErrorOut(PrintStream aErrorOut) {
        this.setErrorOut(aErrorOut);
        return this;
    }

    @Override
    public ArgsParser withEscapeCodesEnabled(boolean aIsEscCodeEnabled) {
        this.setEscapeCodesEnabled(aIsEscCodeEnabled);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(List<String> aArgs) throws ArgsSyntaxException {
        this.evalArgs(aArgs);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(List<String> aArgs, ArgsFilter aArgsFilter) throws ArgsSyntaxException {
        this.evalArgs(aArgs, aArgsFilter);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(List<String> aArgs, Pattern aFilterExp) throws ArgsSyntaxException {
        this.evalArgs(aArgs, aFilterExp);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(String[] aArgs) throws ArgsSyntaxException {
        this.evalArgs(aArgs);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(String[] aArgs, ArgsFilter aArgsFilter) throws ArgsSyntaxException {
        this.evalArgs(aArgs, aArgsFilter);
        return this;
    }

    @Override
    public ArgsParser withEvalArgs(String[] aArgs, Pattern aFilterExp) throws ArgsSyntaxException {
        this.evalArgs(aArgs, aFilterExp);
        return this;
    }

    @Override
    public ArgsParser withExamples(Collection<Example> aExamples) {
        this.setExamples(aExamples);
        return this;
    }

    @Override
    public ArgsParser withExamples(Example[] aExamples) {
        this.setExamples(aExamples);
        return this;
    }

    @Override
    public ArgsParser withLicense(String aLicense) {
        this.setLicense(aLicense);
        return this;
    }

    @Override
    public ArgsParser withLineBreak(String aLineBreak) {
        this.setLineBreak(aLineBreak);
        return this;
    }

    @Override
    public ArgsParser withLineSeparatorEscapeCode(String aLineSeparatorEscCode) {
        this.setLineSeparatorEscapeCode(aLineSeparatorEscCode);
        return this;
    }

    @Override
    public ArgsParser withLongOptionPrefix(String aLongOptionPrefix) {
        this.setLongOptionPrefix(aLongOptionPrefix);
        return this;
    }

    @Override
    public ArgsParser withMaxConsoleWidth(int aMaxConsoleWidth) {
        this.setMaxConsoleWidth(aMaxConsoleWidth);
        return this;
    }

    @Override
    public ArgsParser withName(String aName) {
        this.setName(aName);
        return this;
    }

    @Override
    public ArgsParser withOptionEscapeCode(String aOptEscCode) {
        this.setOptionEscapeCode(aOptEscCode);
        return this;
    }

    @Override
    public ArgsParser withResetEscapeCode(String aResetEscCode) {
        this.setResetEscapeCode(aResetEscCode);
        return this;
    }

    @Override
    public ArgsParser withSeparatorLnChar(char aSeparatorLnChar) {
        this.setSeparatorLnChar(aSeparatorLnChar);
        return this;
    }

    @Override
    public ArgsParser withShortOptionPrefix(Character aShortOptionPrefix) {
        this.setShortOptionPrefix(aShortOptionPrefix);
        return this;
    }

    @Override
    public ArgsParser withStandardOut(PrintStream aStandardOut) {
        this.setStandardOut(aStandardOut);
        return this;
    }

    @Override
    public ArgsParser withSyntaxMetrics(SyntaxMetrics aSyntaxMetrics) {
        this.setSyntaxMetrics(aSyntaxMetrics);
        return this;
    }

    @Override
    public ArgsParser withSyntaxMetrics(SyntaxNotation aSyntaxNotation) {
        this.setSyntaxMetrics(aSyntaxNotation);
        return this;
    }

    @Override
    public ArgsParser withTextBoxGrid(TextBoxGrid aTextBoxGrid) {
        this.setTextBoxGrid(aTextBoxGrid);
        return this;
    }

    @Override
    public ArgsParser withTextBoxGrid(TextBoxStyle aTextBoxStyle) {
        this.setTextBoxGrid(aTextBoxStyle);
        return this;
    }

    @Override
    public ArgsParser withTitle(String aTitle) {
        this.setTitle(aTitle);
        return this;
    }

    private String fromTextBlock(String[] aTextBlock, String aDelimeter) {
        StringBuilder theBuilder = new StringBuilder();
        for (String eString : aTextBlock) {
            if (aDelimeter != null && aDelimeter.length() != 0 && theBuilder.length() > 0) {
                theBuilder.append(aDelimeter);
            }
            theBuilder.append(eString);
        }
        return theBuilder.toString() + this.toLineBreak();
    }

    private boolean hasBorder(String[] aCanvas) {
        if (aCanvas != null && aCanvas.length != 0) {
            int i;
            char ePrevChar = aCanvas[0].length() != 0 ? (char)aCanvas[0].charAt(0) : (char)' ';
            for (i = 0; i < aCanvas[0].length(); ++i) {
                if (ePrevChar != aCanvas[0].charAt(i)) {
                    return false;
                }
                ePrevChar = aCanvas[0].charAt(i);
            }
            for (i = 0; i < aCanvas[aCanvas.length - 1].length(); ++i) {
                if (ePrevChar != aCanvas[aCanvas.length - 1].charAt(i)) {
                    return false;
                }
                ePrevChar = aCanvas[aCanvas.length - 1].charAt(i);
            }
            for (String aCanva : aCanvas) {
                if (ePrevChar != aCanva.charAt(0)) {
                    return false;
                }
                ePrevChar = aCanva.charAt(0);
            }
            for (String aCanva : aCanvas) {
                if (ePrevChar != aCanva.charAt(aCanva.length() - 1)) {
                    return false;
                }
                ePrevChar = aCanva.charAt(aCanva.length() - 1);
            }
        }
        return true;
    }

    protected char getDelimiter() {
        return Delimiter.INDEX.getChar();
    }

    private CliContext toCliContext() {
        return this.toCliContext(true);
    }

    private CliContext toCliContext(boolean isEscapeCodesEnabled) {
        String theNotationProperty = SystemProperty.ARGS_NOTATION.getValue();
        SyntaxNotation theSyntaxNotation = SyntaxNotation.toSyntaxNotation(theNotationProperty);
        CliContext theCliCtx = new CliContext(this, theSyntaxNotation, isEscapeCodesEnabled);
        return theCliCtx;
    }

    private String toLineBreak() {
        if (Terminal.isLineBreakRequired((int)this._consoleWidth)) {
            return this._lineBreak;
        }
        return "";
    }

    private static void approve(Operand<?>[] aOperands, CliContext aCliCtx) throws ArgsSyntaxException {
        for (Operand<?> eOperand : aOperands) {
            if (eOperand instanceof AbstractOperand) {
                AbstractOperand e = (AbstractOperand)eOperand;
                try {
                    e.approve();
                    continue;
                }
                catch (RuntimeException exc) {
                    String theSpec = eOperand.toSpec(aCliCtx);
                    throw new ParseArgsException("Unable to parse provided argument(s) {0} for operand \"" + theSpec + "\"!", eOperand.getParsedArgs(), eOperand, exc);
                }
            }
            if (!(eOperand instanceof Approvable)) continue;
            Approvable e = (Approvable)eOperand;
            try {
                e.approve();
            }
            catch (RuntimeException exc) {
                String theSpec = eOperand.toSpec(aCliCtx);
                throw new ParseArgsException("Unable to parse provided argument(s) {0} for operand \"" + theSpec + "\"!", eOperand.getParsedArgs(), eOperand, exc);
            }
        }
    }

    private static Operand<?>[] fromArgs(String[] aArgs, char aDelimiter) {
        ArrayList<AbstractOperand> theResult = new ArrayList<AbstractOperand>();
        Map theArgs = Arguments.toProperties((String[])aArgs, (String[])ArgsPrefix.toPrefixes(), (char)aDelimiter);
        for (String eKey : theArgs.keySet()) {
            if (Literal.TRUE.getValue().equalsIgnoreCase((String)theArgs.get(eKey))) {
                theResult.add(new Flag((Relation<String, Boolean>)new RelationImpl((Object)eKey, (Object)Boolean.TRUE)));
                continue;
            }
            theResult.add(new StringOperand((Relation<String, String>)new PropertyImpl(eKey, (String)theArgs.get(eKey))));
        }
        return theResult.toArray(new Operand[theResult.size()]);
    }
}

