/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.Term;
import org.refcodes.runtime.SystemProperty;

public class LambdaTest {
    @Test
    public void testStringOptionLambda1() throws ArgsSyntaxException {
        String theExpected = "Hello World!";
        String[] theResult = new String[1];
        Term[] termArray = new Term[1];
        StringOption theStringOption = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", s -> {
            System.out.println(s.getAlias() + "=" + (String)s.getValue());
            theResult[0] = (String)s.getValue();
        });
        termArray[0] = theStringOption;
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])termArray);
        String[] theArgs = new String[]{"-s", "Hello World!"};
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax);
        theParser.evalArgs(theArgs);
        Assertions.assertEquals((Object)"Hello World!", (Object)theResult[0]);
        Assertions.assertEquals((Object)theStringOption.getValue(), (Object)theResult[0]);
    }

    @Test
    public void testStringOptionLambda2() throws ArgsSyntaxException {
        String theExpected = "Hello World!";
        String[] theResult = new String[1];
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        StringOption theStringOption1 = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", s -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(s.getAlias() + "=" + (String)s.getValue());
            }
            theResult[0] = (String)s.getValue();
        });
        termArray2[0] = theStringOption1;
        termArray2[1] = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT", (String)"Don't invoke lambda upon parsing", t -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(t.getAlias() + "=" + (String)t.getValue());
            }
            Assertions.fail((String)"This option did NOT match any of the provided arguments!");
        });
        termArray[0] = CliSugar.any((Term[])termArray2);
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])termArray);
        String[] theArgs = new String[]{"-s", "Hello World!"};
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax);
        theParser.evalArgs(theArgs);
        Assertions.assertEquals((Object)"Hello World!", (Object)theResult[0]);
        Assertions.assertEquals((Object)theStringOption1.getValue(), (Object)theResult[0]);
    }

    @Test
    public void testStringOptionLambda3() throws ArgsSyntaxException {
        String theExpected1 = "Hello World!";
        String theExpected2 = "Hallo Welt!";
        String[] theResult = new String[2];
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        StringOption theStringOption1 = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", s -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(s.getAlias() + "=" + (String)s.getValue());
            }
            theResult[0] = (String)s.getValue();
        });
        termArray2[0] = theStringOption1;
        StringOption theStringOption2 = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT", (String)"Invoke lambda upon parsing", t -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(t.getAlias() + "=" + (String)t.getValue());
            }
            theResult[1] = (String)t.getValue();
        });
        termArray2[1] = theStringOption2;
        termArray[0] = CliSugar.any((Term[])termArray2);
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])termArray);
        String[] theArgs = new String[]{"-s", "Hello World!", "-t", "Hallo Welt!"};
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax);
        theParser.evalArgs(theArgs);
        Assertions.assertEquals((Object)"Hello World!", (Object)theResult[0]);
        Assertions.assertEquals((Object)"Hallo Welt!", (Object)theResult[1]);
        Assertions.assertEquals((Object)theStringOption1.getValue(), (Object)theResult[0]);
        Assertions.assertEquals((Object)theStringOption2.getValue(), (Object)theResult[1]);
    }

    @Test
    public void testStringPropertyLambda1() throws ArgsSyntaxException {
        String theExpected = "Hello World!";
        String[] theResult = new String[1];
        Term[] termArray = new Term[1];
        StringProperty theStringProperty = CliSugar.stringProperty((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", s -> {
            System.out.println(s.getAlias() + "=" + (String)s.getValue());
            theResult[0] = (String)s.getValue();
        });
        termArray[0] = theStringProperty;
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])termArray);
        String[] theArgs = new String[]{"-s=Hello World!"};
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax);
        theParser.evalArgs(theArgs);
        Assertions.assertEquals((Object)"Hello World!", (Object)theResult[0]);
        Assertions.assertEquals((Object)theStringProperty.getValue(), (Object)theResult[0]);
    }

    @Test
    public void testStringPropertyLambda2() throws ArgsSyntaxException {
        String theExpected = "Hello World!";
        String[] theResult = new String[1];
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        StringProperty theStringProperty1 = CliSugar.stringProperty((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", s -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(s.getAlias() + "=" + (String)s.getValue());
            }
            theResult[0] = (String)s.getValue();
        });
        termArray2[0] = theStringProperty1;
        termArray2[1] = CliSugar.stringProperty((Character)Character.valueOf('t'), (String)"text", (String)"TEXT", (String)"Don't invoke lambda upon parsing", t -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(t.getAlias() + "=" + (String)t.getValue());
            }
            Assertions.fail((String)"This option did NOT match any of the provided arguments!");
        });
        termArray[0] = CliSugar.any((Term[])termArray2);
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])termArray);
        String[] theArgs = new String[]{"-s=Hello World!"};
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax);
        theParser.evalArgs(theArgs);
        Assertions.assertEquals((Object)"Hello World!", (Object)theResult[0]);
        Assertions.assertEquals((Object)theStringProperty1.getValue(), (Object)theResult[0]);
    }

    @Test
    public void testStringPropertyLambda3() throws ArgsSyntaxException {
        String theExpected1 = "Hello World!";
        String theExpected2 = "Hallo Welt!";
        String[] theResult = new String[2];
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        StringProperty theStringProperty1 = CliSugar.stringProperty((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", s -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(s.getAlias() + "=" + (String)s.getValue());
            }
            theResult[0] = (String)s.getValue();
        });
        termArray2[0] = theStringProperty1;
        StringProperty theStringProperty2 = CliSugar.stringProperty((Character)Character.valueOf('t'), (String)"text", (String)"TEXT", (String)"Invoke lambda upon parsing", t -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(t.getAlias() + "=" + (String)t.getValue());
            }
            theResult[1] = (String)t.getValue();
        });
        termArray2[1] = theStringProperty2;
        termArray[0] = CliSugar.any((Term[])termArray2);
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])termArray);
        String[] theArgs = new String[]{"-s=Hello World!", "-t=Hallo Welt!"};
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax);
        theParser.evalArgs(theArgs);
        Assertions.assertEquals((Object)"Hello World!", (Object)theResult[0]);
        Assertions.assertEquals((Object)"Hallo Welt!", (Object)theResult[1]);
        Assertions.assertEquals((Object)theStringProperty1.getValue(), (Object)theResult[0]);
        Assertions.assertEquals((Object)theStringProperty2.getValue(), (Object)theResult[1]);
    }

    @Test
    public void testIllegalArgumentLambda() throws ArgsSyntaxException {
        String theExpected = "Unable to parse provided argument(s) [\"-s\", \"Hello World!\"] for operand \"-s --string <STRING>\"! Caused by: Bad input!";
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.stringOption((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", s -> {
            throw new IllegalArgumentException("Bad input!");
        })});
        String[] theArgs = new String[]{"-s", "Hello World!"};
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax);
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expecting an exception of type <" + ArgsSyntaxException.class.getName() + ">!"));
        }
        catch (ArgsSyntaxException expected) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("Expected  = " + theExpected);
                System.out.println("Exception = " + expected.toHeuristicMessage());
            }
            Assertions.assertEquals((Object)theExpected, (Object)expected.toHeuristicMessage());
        }
    }
}

