/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.mixin.Schema;

public class ArrayOperand<T>
extends AbstractTerm
implements Operand<T[]> {
    private static final String MAX_LENGTH = "MAX_LENGTH";
    private static final String MIN_LENGTH = "MIN_LENGTH";
    private int _maxLength;
    private int _minLength;
    private Operand<T> _operand;
    private Class<T[]> _type;
    private T[] _values = null;

    public ArrayOperand(Operand<T> aOperand) {
        this(aOperand, -1, -1);
    }

    public ArrayOperand(Operand<T> aOperand, int aLength) {
        this(aOperand, aLength, aLength);
    }

    public ArrayOperand(Operand<T> aOperand, int aMinLength, int aMaxLength) {
        if (aMaxLength == 0 || aMinLength != -1 && aMaxLength != -1 && aMinLength > aMaxLength || aMaxLength < -1 || aMaxLength < -1) {
            throw new IllegalArgumentException("The minimum length <" + aMinLength + "> must be less or equal than the maximum length <" + aMaxLength + ">, both values must be greater (minimum and maximum) or equal (minimum) than <0> (or <-1> when to be ignored)!");
        }
        this._operand = aOperand;
        this._minLength = aMinLength;
        this._maxLength = aMaxLength;
        this._type = Array.newInstance(aOperand.getType(), 0).getClass();
    }

    @Override
    public int getMatchCount() {
        return this._values != null ? this._values.length : 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(Operand<?> o) {
        return this._operand.compareTo(o);
    }

    @Override
    public String getAlias() {
        return this._operand.getAlias();
    }

    @Override
    public String getDescription() {
        return this._operand.getDescription();
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public Class<T[]> getType() {
        return this._type;
    }

    @Override
    public T[] getValue() {
        return this._values;
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aOperands, CliContext aCliCtx) throws ArgsSyntaxException {
        int index;
        ArrayList<Operand> theResult;
        ArrayList<T> theValues;
        block7: {
            theValues = new ArrayList<T>();
            theResult = new ArrayList<Operand>();
            index = 0;
            try {
                while (this._maxLength == -1 || index < this._maxLength) {
                    Operand<?>[] eOperands;
                    Operand<?>[] operandArray = eOperands = this._operand.parseArgs(aArgs, aOperands, aCliCtx);
                    int n = eOperands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object eObj;
                        Operand<?> eOperand = operandArray[n2];
                        try {
                            eObj = eOperand.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            this._exception = new ParseArgsException("The type <" + this._operand.getType().getSimpleName() + "> does not support cloning!", aArgs, (Term)this, e);
                            throw this._exception;
                        }
                        theResult.add((Operand)eObj);
                        ++n2;
                    }
                    theValues.add(this._operand.getValue());
                    aArgs = AbstractTerm.toArgsDiff(aArgs, eOperands);
                    ++index;
                }
            }
            catch (AmbiguousArgsException | ParseArgsException | UnknownArgsException e) {
                if (this._maxLength == -1 || index <= this._maxLength) break block7;
                this._exception = e;
                throw this._exception;
            }
        }
        if (theValues.size() == 0 || this._minLength != -1 && index < this._minLength) {
            this._exception = new UnknownArgsException("Not one argument matched (as of \"" + this.toUsage(aCliCtx) + "\")", aArgs, this);
            throw this._exception;
        }
        this._values = theValues.toArray((Object[])Array.newInstance(this._operand.getType(), theValues.size()));
        return theResult.toArray(new Operand[theResult.size()]);
    }

    @Override
    public void reset() {
        super.reset();
        this._operand.reset();
        this._values = null;
    }

    @Override
    public String[] getParsedArgs() {
        return this._operand.getParsedArgs();
    }

    @Override
    public CliSchema toSchema() {
        CliSchema theSchema = new CliSchema(this._operand.getDescription(), this.getClass(), this.getValue(), this._operand.getAlias(), new Schema[0]);
        theSchema.put(MAX_LENGTH, this._maxLength);
        theSchema.put(MIN_LENGTH, this._minLength);
        if (this._exception != null) {
            theSchema.put("EXCEPTION", this._exception);
        }
        return theSchema;
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return aCliCtx.toArgumentSpec(this, this._minLength, this._maxLength);
    }

    protected Operand<T> getOperand() {
        return this._operand;
    }
}

