/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsParserTest;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class SyntaxNotationTest {
    @Test
    public void testVisibility1() throws ArgsSyntaxException {
        EnumOption theEncodingArg = CliSugar.enumOption((String)"encoding", ArgsParserTest.BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.BaseMetricsConfig.values())));
        Flag theBase64Flag = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag theDecryptFlag = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the aMessage (stream, file, text or bytes).");
        Flag theEncryptFlag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the aMessage (stream, file, text or bytes).");
        Flag theVerifyFlag = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        IntOption theLineWidthArg = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.").withVisible(true);
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        AndCondition theCondition = CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theEncryptFlag, CliSugar.any((Term[])new Term[]{theVerifyFlag, CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theBase64Flag, CliSugar.any((Term[])new Term[]{theLineWidthArg})}), CliSugar.and((Term[])new Term[]{theEncodingArg, CliSugar.any((Term[])new Term[]{theLineWidthArg})})})})}), theDecryptFlag}), CliSugar.any((Term[])new Term[]{theInputFileArg, theOutputFileArg})});
        ArgsParser theParser = new ArgsParser((Term)theCondition).withConsoleWidth(180).withEscapeCodesEnabled(false);
        ByteArrayOutputStream theBytes = new ByteArrayOutputStream();
        PrintStream theOutHook = new PrintStream(theBytes);
        theParser.printSynopsis(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printDescription(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printOptions(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printExamples(theOutHook);
        String theResult = theBytes.toString();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theResult);
        }
        Assertions.assertTrue((boolean)theResult.toLowerCase().contains("line-width"));
        Assertions.assertEquals((int)2495, (int)theResult.length());
    }

    @Test
    public void testVisibility2() throws ArgsSyntaxException {
        EnumOption theEncodingArg = CliSugar.enumOption((String)"encoding", ArgsParserTest.BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.BaseMetricsConfig.values())));
        Flag theBase64Flag = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag theDecryptFlag = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the aMessage (stream, file, text or bytes).");
        Flag theEncryptFlag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the aMessage (stream, file, text or bytes).");
        Flag theVerifyFlag = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        IntOption theLineWidthArg = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.").withVisible(false);
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        AndCondition theCondition = CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theEncryptFlag, CliSugar.any((Term[])new Term[]{theVerifyFlag, CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theBase64Flag, CliSugar.any((Term[])new Term[]{theLineWidthArg})}), CliSugar.and((Term[])new Term[]{theEncodingArg, CliSugar.any((Term[])new Term[]{theLineWidthArg})})})})}), theDecryptFlag}), CliSugar.any((Term[])new Term[]{theInputFileArg, theOutputFileArg})});
        ArgsParser theParser = new ArgsParser((Term)theCondition).withConsoleWidth(180).withEscapeCodesEnabled(false);
        ByteArrayOutputStream theBytes = new ByteArrayOutputStream();
        PrintStream theOutHook = new PrintStream(theBytes);
        theParser.printSynopsis(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printDescription(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printOptions(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printExamples(theOutHook);
        String theResult = theBytes.toString();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theResult);
        }
        Assertions.assertFalse((boolean)theResult.toLowerCase().contains("line-width"));
        Assertions.assertEquals((int)2133, (int)theResult.length());
    }

    @Test
    public void testEscapeCodes1() {
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{CliSugar.debugFlag(), CliSugar.verboseFlag()}), CliSugar.xor((Term[])new Term[]{CliSugar.helpFlag(), CliSugar.and((Term[])new Term[]{CliSugar.sysInfoFlag(), CliSugar.any((Term[])new Term[]{CliSugar.verboseFlag()})})})});
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax).withEscapeCodesEnabled(true).withConsoleWidth(180);
        ByteArrayOutputStream theBytes = new ByteArrayOutputStream();
        PrintStream theOutHook = new PrintStream(theBytes);
        theParser.printBanner(theOutHook);
        theParser.printLicense(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printSynopsis(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printDescription(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printOptions(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printExamples(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printCopyright(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        String theResult = theBytes.toString();
        int count = 0;
        for (int i = 0; i < theResult.length(); ++i) {
            if (theResult.charAt(i) != AnsiEscapeCode.ESCAPE) continue;
            ++count;
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theResult);
        }
        Assertions.assertEquals((int)330, (int)count);
    }

    @Test
    public void testEscapeCodes2() {
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{CliSugar.debugFlag(), CliSugar.verboseFlag()}), CliSugar.xor((Term[])new Term[]{CliSugar.helpFlag(), CliSugar.and((Term[])new Term[]{CliSugar.sysInfoFlag(), CliSugar.any((Term[])new Term[]{CliSugar.verboseFlag()})})})});
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax).withEscapeCodesEnabled(false).withConsoleWidth(180);
        ByteArrayOutputStream theBytes = new ByteArrayOutputStream();
        PrintStream theOutHook = new PrintStream(theBytes);
        theParser.printBanner(theOutHook);
        theParser.printLicense(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printSynopsis(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printDescription(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printOptions(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printExamples(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        theParser.printCopyright(theOutHook);
        theParser.printSeparatorLn(theOutHook);
        String theResult = theBytes.toString();
        int count = 0;
        for (int i = 0; i < theResult.length(); ++i) {
            if (theResult.charAt(i) != AnsiEscapeCode.ESCAPE) continue;
            ++count;
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theResult);
        }
        Assertions.assertEquals((int)0, (int)count);
    }

    @Test
    public void testSyntaxNotations() {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (SyntaxNotation eNotation : SyntaxNotation.values()) {
                System.out.println(eNotation + ".emptySymbol=" + eNotation.getEmptySymbol());
                System.out.println(eNotation + ".allSymbol=" + eNotation.getAllSymbol());
                System.out.println(eNotation + ".andSymbol=" + eNotation.getAndSymbol());
                System.out.println(eNotation + ".anySymbol=" + eNotation.getAnySymbol());
                System.out.println(eNotation + ".orSymbol=" + eNotation.getOrSymbol());
                System.out.println(eNotation + ".xorSymbol=" + eNotation.getXorSymbol());
                System.out.println(eNotation + ".argumentPrefix=" + eNotation.getArgumentPrefix());
                System.out.println(eNotation + ".argumentSuffix=" + eNotation.getArgumentSuffix());
                System.out.println(eNotation + ".beginArraySymbol=" + eNotation.getBeginArraySymbol());
                System.out.println(eNotation + ".beginListSymbol=" + eNotation.getBeginListSymbol());
                System.out.println(eNotation + ".beginOptionalSymbol=" + eNotation.getBeginOptionalSymbol());
                System.out.println(eNotation + ".beginRangeSymbol=" + eNotation.getBeginRangeSymbol());
                System.out.println(eNotation + ".endArraySymbol=" + eNotation.getEndArraySymbol());
                System.out.println(eNotation + ".endListSymbol=" + eNotation.getEndListSymbol());
                System.out.println(eNotation + ".endOptionalSymbol=" + eNotation.getEndOptionalSymbol());
                System.out.println(eNotation + ".endRangeSymbol=" + eNotation.getEndRangeSymbol());
                System.out.println(eNotation + ".intervalSymbol=" + eNotation.getIntervalSymbol());
                System.out.println(eNotation + ".longOptionPrefix=" + eNotation.getLongOptionPrefix());
                System.out.println(eNotation + ".shortOptionPrefix=" + eNotation.getShortOptionPrefix());
                System.out.println();
            }
        }
    }

    @Test
    public void testSynopsis() {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{CliSugar.debugFlag(), CliSugar.verboseFlag()}), CliSugar.xor((Term[])new Term[]{CliSugar.helpFlag(), CliSugar.and((Term[])new Term[]{CliSugar.sysInfoFlag(), CliSugar.any((Term[])new Term[]{CliSugar.verboseFlag()})})})});
            System.out.println(theArgsSyntax.toSynopsis(SyntaxNotation.GNU_POSIX));
            System.out.println();
            System.out.println(theArgsSyntax.toSchema());
        }
    }
}

