/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsFilter;
import org.refcodes.runtime.SystemProperty;

public class ArgsFilterTest {
    @Test
    public void testNoneFilter1() {
        String[] stringArray = new String[]{"-Dconsole.width=130", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-Dconsole.width=130", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.NONE, stringArray, stringArray2);
    }

    @Test
    public void testNoneFilter2() {
        String[] stringArray = new String[]{"-Dconsole.width=130\n", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-Dconsole.width=130\n", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.NONE, stringArray, stringArray2);
    }

    @Test
    public void testDFilter1() {
        String[] stringArray = new String[]{"-Dconsole.width=130", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, stringArray, stringArray2);
    }

    @Test
    public void testDFilter2() {
        String[] stringArray = new String[]{"-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, stringArray, stringArray2);
    }

    @Test
    public void testDFilter3() {
        String[] stringArray = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        String[] stringArray2 = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, stringArray, stringArray2);
    }

    @Test
    public void testDFilter4() {
        String[] stringArray = new String[]{"-a", "-b", "<someB>", "--Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-a", "-b", "<someB>", "--Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, stringArray, stringArray2);
    }

    @Test
    public void testDFilter5() {
        String[] stringArray = new String[]{"-a", "-b", "<someB>", "Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-a", "-b", "<someB>", "Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, stringArray, stringArray2);
    }

    @Test
    public void testDFilter6() {
        String[] stringArray = new String[]{"-Dconsole.width=130", "-Dconsole.linebreak=\n", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, stringArray, stringArray2);
    }

    @Test
    public void testXXFilter1() {
        String[] stringArray = new String[]{"-XX:codecachetotal", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.XX, stringArray, stringArray2);
    }

    @Test
    public void testXXFilter2() {
        String[] stringArray = new String[]{"-XXwhatever", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-XXwhatever", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.XX, stringArray, stringArray2);
    }

    @Test
    public void testDXXFilter1() {
        String[] stringArray = new String[]{"-XX:codecachetotal", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D_XX, stringArray, stringArray2);
    }

    @Test
    public void testDXXFilter2() {
        String[] stringArray = new String[]{"-XXwhatever", "-XX:codecachetotal", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] stringArray2 = new String[]{"-XXwhatever", "-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D_XX, stringArray, stringArray2);
    }

    private static void validate(ArgsFilter argsFilter, String[] stringArray, String[] stringArray2) {
        Object[] objectArray = argsFilter.toFiltered(stringArray);
        List<String> list = Arrays.asList(stringArray);
        List list2 = argsFilter.toFiltered(list);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Args := " + Arrays.toString(stringArray));
            System.out.println("Expected := " + Arrays.toString(stringArray2));
            System.out.println("Result := " + Arrays.toString(objectArray));
            System.out.println("Filtered := " + String.valueOf(list2));
            System.out.println();
        }
        Assertions.assertArrayEquals((Object[])stringArray2, (Object[])objectArray);
        Assertions.assertArrayEquals((Object[])stringArray2, (Object[])list2.toArray(new String[list2.size()]));
    }
}

