/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AllCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.BooleanOption;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Operation;
import org.refcodes.cli.Option;
import org.refcodes.cli.OrCondition;
import org.refcodes.cli.ParseArgs;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.cli.XorCondition;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParserTest {
    private static final String[][] ARGS = new String[][]{{"--name", "FILE", "--boolean", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "NULL"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "--name", "NAME0", "--name", "NAME1", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "/name", "NAME1", "/boolean", "/alias", "ALIAS", "NIL"}, {"NULL", "-name", "NAME0", "-name", "NAME1", "-boolean", "-alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "-name", "NAME1", "--boolean", "/alias", "ALIAS", "NIL"}};
    private static final String[][] PROPERTIES = new String[][]{{"name=FILE", "boolean=true", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null=NULL"}, {"null=NULL", "name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}};

    @Test
    public void testEdgeCase1() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag helpFlag = CliSugar.helpFlag();
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{stringOption, stringOption2, CliSugar.any((Term[])new Term[]{debugFlag})}), CliSugar.xor((Term[])new Term[]{helpFlag, CliSugar.and((Term[])new Term[]{sysInfoFlag, CliSugar.any((Term[])new Term[]{verboseFlag})})})});
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(new String[]{"-i", "in", "-o", "out"});
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(casesCondition.toSchema());
        }
    }

    @Test
    public void testEdgeCase2() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag helpFlag = CliSugar.helpFlag();
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{stringOption, stringOption2, CliSugar.any((Term[])new Term[]{debugFlag})}), CliSugar.xor((Term[])new Term[]{helpFlag, CliSugar.and((Term[])new Term[]{sysInfoFlag, CliSugar.any((Term[])new Term[]{verboseFlag})})})});
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        try {
            argsParser.evalArgs(new String[0]);
            Assertions.fail((String)("Expected an <" + UnknownArgsException.class.getName() + ">!"));
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgeCase3() throws ArgsSyntaxException {
        EnumOption enumOption = CliSugar.enumOption((String)"encoding", BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])BaseMetricsConfig.values())));
        Flag flag = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag flag2 = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the aMessage (stream, file, text or bytes).");
        Flag flag3 = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the aMessage (stream, file, text or bytes).");
        Flag flag4 = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        IntOption intOption = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.");
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        AndCondition andCondition = CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag3, CliSugar.any((Term[])new Term[]{flag4, CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag, CliSugar.any((Term[])new Term[]{intOption})}), CliSugar.and((Term[])new Term[]{enumOption, CliSugar.any((Term[])new Term[]{intOption})})})})}), flag2}), CliSugar.any((Term[])new Term[]{stringOption, stringOption2})});
        String[] stringArray = new String[]{"-e", "-i", "input.dat", "-o", "output.txt"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        argsParser.evalArgs(stringArray);
    }

    @Test
    public void testEdgeCase4() throws ArgsSyntaxException {
        EnumOption enumOption = CliSugar.enumOption((String)"chaos-mode", ChaosMode.class, (String)"CHAOS_MODE_PROPERTY", (String)("The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString((Object[])ChaosMode.values())));
        EnumOption enumOption2 = CliSugar.enumOption((String)"context", SystemContext.class, (String)"CONTEXT_PROPERTY", (String)("The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values())));
        Flag flag = CliSugar.flag((String)"prompt", (String)"PROMPT_PASSWORD_PROPERTY", (String)"Prompt for the password to use for encryption or decryption.");
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('c'), (String)"cert-file", (String)"CERT_FILE_PROPERTY", (String)"The cert file file which to use.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('p'), (String)"password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag, stringOption2, enumOption2}), enumOption}), CliSugar.and((Term[])new Term[]{stringOption, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag, stringOption2, enumOption2})})})})});
        String[] stringArray = new String[]{"-p", "Hallo Welt!", "--cert-file", "C"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(stringArray);
    }

    @Test
    public void testEdgeCase5() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('e'), (String)"echo", (String)"TEXT_PROPERTY", (String)"Echoes the provided aMessage to the standard out stream.");
        ConfigOption configOption = CliSugar.configOption();
        InitFlag initFlag = CliSugar.initFlag();
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag();
        HelpFlag helpFlag = CliSugar.helpFlag();
        DebugFlag debugFlag = CliSugar.debugFlag();
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{stringOption, CliSugar.any((Term[])new Term[]{configOption, verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{initFlag, CliSugar.any((Term[])new Term[]{configOption, verboseFlag})}), CliSugar.xor((Term[])new Term[]{helpFlag, CliSugar.and((Term[])new Term[]{sysInfoFlag, CliSugar.any((Term[])new Term[]{verboseFlag})})})});
        String[] stringArray = new String[]{};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getSimpleName() + "> exception!"));
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgeCase6() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag helpFlag = CliSugar.helpFlag();
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{stringOption, CliSugar.and((Term[])new Term[]{stringOption2, CliSugar.any((Term[])new Term[]{verboseFlag})}), debugFlag}), CliSugar.and((Term[])new Term[]{stringOption, CliSugar.and((Term[])new Term[]{debugFlag, CliSugar.any((Term[])new Term[]{verboseFlag})})}), CliSugar.xor((Term[])new Term[]{helpFlag, CliSugar.and((Term[])new Term[]{sysInfoFlag, CliSugar.any((Term[])new Term[]{verboseFlag})})})});
        String[] stringArray = new String[]{"-i", "someInputFile", "-o", "someOutputFile"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(stringArray);
    }

    @Test
    public void testEdgeCase7() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag helpFlag = CliSugar.helpFlag();
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{stringOption, CliSugar.and((Term[])new Term[]{stringOption2, CliSugar.any((Term[])new Term[]{verboseFlag})}), debugFlag}), CliSugar.and((Term[])new Term[]{stringOption, CliSugar.and((Term[])new Term[]{debugFlag, CliSugar.any((Term[])new Term[]{verboseFlag})})}), CliSugar.xor((Term[])new Term[]{helpFlag, CliSugar.and((Term[])new Term[]{sysInfoFlag, CliSugar.any((Term[])new Term[]{verboseFlag})})})});
        String[] stringArray = new String[]{"-i", "someInputFile"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertEquals((int)1, (int)operandArray.length);
        Assertions.assertEquals((Object)"someInputFile", (Object)stringOption.getValue());
    }

    @Test
    public void testEdgeCase8() {
        StringProperty stringProperty = CliSugar.stringProperty((Character)Character.valueOf('f'), (String)"filename", (String)"The kernel's project file");
        StringProperty stringProperty2 = CliSugar.stringProperty((String)"csv", (String)"The kernel's poulation CSV file");
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{stringProperty, CliSugar.optional((Term[])new Term[]{stringProperty2})})});
        ArgsParser argsParser = new ArgsParser((Term)casesCondition).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
        try {
            argsParser.evalArgs(new String[]{"-f=filename", "--csv=csv"});
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            argsParser.printBody();
            System.out.println(argsSyntaxException.toMessage());
        }
    }

    @Test
    public void testAnyCase1() {
        DebugFlag debugFlag = CliSugar.debugFlag();
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        QuietFlag quietFlag = CliSugar.quietFlag();
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{debugFlag, verboseFlag}), quietFlag});
        String[] stringArray = new String[]{};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        try {
            argsParser.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(argsSyntaxException.toMessage());
                argsSyntaxException.printStackTrace();
            }
            Assertions.fail((String)argsSyntaxException.getMessage());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
        Assertions.assertFalse((boolean)debugFlag.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)quietFlag.isEnabled());
    }

    @Test
    public void testAnyCase2() {
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)true);
        VerboseFlag verboseFlag = CliSugar.verboseFlag((boolean)true);
        QuietFlag quietFlag = CliSugar.quietFlag((boolean)true);
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{debugFlag, verboseFlag}), quietFlag});
        String[] stringArray = new String[]{"-q"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        try {
            argsParser.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(argsSyntaxException.toMessage());
                argsSyntaxException.printStackTrace();
            }
            Assertions.fail((String)argsSyntaxException.getMessage());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
        Assertions.assertFalse((boolean)debugFlag.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertTrue((boolean)quietFlag.isEnabled());
    }

    @Test
    public void testAnyCase3() {
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)true);
        VerboseFlag verboseFlag = CliSugar.verboseFlag((boolean)true);
        QuietFlag quietFlag = CliSugar.quietFlag((boolean)true);
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{debugFlag, verboseFlag}), quietFlag});
        String[] stringArray = new String[]{"-d", "-v"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        try {
            argsParser.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(argsSyntaxException.toMessage());
                argsSyntaxException.printStackTrace();
            }
            Assertions.fail((String)argsSyntaxException.getMessage());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
        Assertions.assertTrue((boolean)debugFlag.isEnabled());
        Assertions.assertTrue((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)quietFlag.isEnabled());
    }

    @Test
    public void testAnyCase4() {
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)true);
        VerboseFlag verboseFlag = CliSugar.verboseFlag((boolean)true);
        QuietFlag quietFlag = CliSugar.quietFlag((boolean)true);
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{debugFlag, verboseFlag}), quietFlag});
        String[] stringArray = new String[]{"-d"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        try {
            argsParser.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(argsSyntaxException.toMessage());
                argsSyntaxException.printStackTrace();
            }
            Assertions.fail((String)argsSyntaxException.getMessage());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
        Assertions.assertTrue((boolean)debugFlag.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)quietFlag.isEnabled());
    }

    @Test
    public void testAnyCase5() throws ArgsSyntaxException {
        QuietFlag quietFlag;
        VerboseFlag verboseFlag;
        DebugFlag debugFlag;
        block3: {
            debugFlag = CliSugar.debugFlag();
            verboseFlag = CliSugar.verboseFlag();
            quietFlag = CliSugar.quietFlag();
            CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{debugFlag, verboseFlag}), quietFlag});
            String[] stringArray = new String[]{"-q", "-d"};
            ArgsParser argsParser = new ArgsParser((Term)casesCondition);
            try {
                argsParser.evalArgs(stringArray);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException unknownArgsException) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println(unknownArgsException.toMessage());
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyCase6() throws ArgsSyntaxException {
        QuietFlag quietFlag;
        VerboseFlag verboseFlag;
        DebugFlag debugFlag;
        block3: {
            debugFlag = CliSugar.debugFlag();
            verboseFlag = CliSugar.verboseFlag();
            quietFlag = CliSugar.quietFlag();
            CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{debugFlag, verboseFlag}), quietFlag});
            String[] stringArray = new String[]{"-v", "-q"};
            ArgsParser argsParser = new ArgsParser((Term)casesCondition);
            try {
                argsParser.evalArgs(stringArray);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException unknownArgsException) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println(unknownArgsException.toMessage());
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyCase7() throws ArgsSyntaxException {
        QuietFlag quietFlag;
        VerboseFlag verboseFlag;
        DebugFlag debugFlag;
        block3: {
            debugFlag = CliSugar.debugFlag();
            verboseFlag = CliSugar.verboseFlag();
            quietFlag = CliSugar.quietFlag();
            CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{debugFlag, verboseFlag}), quietFlag});
            String[] stringArray = new String[]{"-d", "-v", "-q"};
            ArgsParser argsParser = new ArgsParser((Term)casesCondition);
            try {
                argsParser.evalArgs(stringArray);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException unknownArgsException) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println(unknownArgsException.toMessage());
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyXor1() throws ArgsSyntaxException {
        QuietFlag quietFlag;
        VerboseFlag verboseFlag;
        DebugFlag debugFlag;
        block3: {
            debugFlag = CliSugar.debugFlag((boolean)true);
            verboseFlag = CliSugar.verboseFlag((boolean)true);
            quietFlag = CliSugar.quietFlag((boolean)true);
            XorCondition xorCondition = CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{debugFlag, verboseFlag}), quietFlag});
            String[] stringArray = new String[]{"-q", "-d"};
            ArgsParser argsParser = new ArgsParser((Term)xorCondition);
            try {
                argsParser.evalArgs(stringArray);
                Assertions.fail((String)("Expected a <" + AmbiguousArgsException.class.getName() + "> exception!"));
            }
            catch (AmbiguousArgsException ambiguousArgsException) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println(ambiguousArgsException.toMessage());
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
    }

    @Test
    public void testParser1() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringOption});
        String[] stringArray = new String[]{"-f", "someFile", "-a"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser2() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AnyCondition anyCondition = new AnyCondition(new Term[]{xorCondition});
        AndCondition andCondition = new AndCondition(new Term[]{anyCondition, stringOption});
        String[] stringArray = new String[]{"-f", "someFile", "-d"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(andCondition.toSynopsis());
        }
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertFalse((boolean)((Boolean)flag.getValue()));
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser3() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a", "anOperand"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser4() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            // empty catch block
        }
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser5() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            Assertions.assertEquals((int)1, (int)superfluousArgsException.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)superfluousArgsException.getArgs()[0]);
        }
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser6() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser7() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-t", "toFile", "anOperand", "-f", "fromFile", "-a"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser8() {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag2, flag});
        AndCondition andCondition = new AndCondition(new Term[]{stringOperand, xorCondition, stringOption, stringOption2});
        Operand[] operandArray = andCondition.toOperands();
        this.doLogOperands(operandArray);
    }

    @Test
    public void testParser9() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail braking.");
        StringOption stringOption2 = new StringOption(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('c'), null, null, "Creates the specified file");
        OrCondition orCondition = new OrCondition(new Term[]{flag, flag2});
        Flag flag3 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition xorCondition = new XorCondition(new Term[]{orCondition, flag3});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser10() throws ArgsSyntaxException {
        BooleanOption booleanOption = new BooleanOption("bool1", "The 1st boolean");
        BooleanOption booleanOption2 = new BooleanOption("bool2", "The 2nd boolean");
        BooleanOption booleanOption3 = new BooleanOption("bool3", "The 3rd boolean");
        BooleanOption booleanOption4 = new BooleanOption("bool4", "The 4th boolean");
        AndCondition andCondition = new AndCondition(new Term[]{booleanOption, booleanOption2, booleanOption3, booleanOption4});
        String[] stringArray = new String[]{"--bool1", "true", "--bool2", "on", "--bool3", "yes", "--bool4", "1"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)booleanOption.getValue());
        Assertions.assertTrue((boolean)booleanOption2.getValue());
        Assertions.assertTrue((boolean)booleanOption3.getValue());
        Assertions.assertTrue((boolean)booleanOption4.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParser11() throws ArgsSyntaxException {
        BooleanOption booleanOption = CliSugar.booleanOption((String)"bool1", (String)"The 1st boolean");
        BooleanOption booleanOption2 = CliSugar.booleanOption((String)"bool2", (String)"The 2nd boolean");
        BooleanOption booleanOption3 = CliSugar.booleanOption((String)"bool3", (String)"The 3rd boolean");
        BooleanOption booleanOption4 = CliSugar.booleanOption((String)"bool4", (String)"The 4th boolean");
        AndCondition andCondition = CliSugar.and((Term[])new Term[]{booleanOption, booleanOption2, booleanOption3, booleanOption4});
        String[] stringArray = new String[]{"--bool1", "false", "--bool2", "off", "--bool3", "no", "--bool4", "0"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertFalse((boolean)booleanOption.getValue());
        Assertions.assertFalse((boolean)booleanOption2.getValue());
        Assertions.assertFalse((boolean)booleanOption3.getValue());
        Assertions.assertFalse((boolean)booleanOption4.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties1() throws ArgsSyntaxException {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringProperty});
        String[] stringArray = new String[]{"-f=someFile", "-a"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties2() throws ArgsSyntaxException {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AnyCondition anyCondition = new AnyCondition(new Term[]{xorCondition});
        AndCondition andCondition = new AndCondition(new Term[]{anyCondition, stringProperty});
        String[] stringArray = new String[]{"-f=someFile", "-d"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(andCondition.toSynopsis());
        }
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertFalse((boolean)((Boolean)flag.getValue()));
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties3() throws ArgsSyntaxException {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringProperty, stringOperand});
        String[] stringArray = new String[]{"-f=someFile", "-a", "anOperand"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties4() throws ArgsSyntaxException {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringProperty, stringOperand});
        String[] stringArray = new String[]{"-f=someFile", "-a"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            // empty catch block
        }
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties5() throws ArgsSyntaxException {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringProperty, stringOperand});
        String[] stringArray = new String[]{"-f=someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            Assertions.assertEquals((int)1, (int)superfluousArgsException.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)superfluousArgsException.getArgs()[0]);
        }
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties6() throws ArgsSyntaxException {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringProperty stringProperty2 = new StringProperty(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringProperty, stringProperty2, stringOperand});
        String[] stringArray = new String[]{"-f=fromFile", "-t=toFile", "-a", "anOperand"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties7() throws ArgsSyntaxException {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringProperty stringProperty2 = new StringProperty(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringProperty, stringProperty2, stringOperand});
        String[] stringArray = new String[]{"-t=toFile", "anOperand", "-f=fromFile", "-a"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties8() {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringProperty stringProperty2 = new StringProperty(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Term[]{flag2, flag});
        AndCondition andCondition = new AndCondition(new Term[]{stringOperand, xorCondition, stringProperty, stringProperty2});
        Operand[] operandArray = andCondition.toOperands();
        this.doLogOperands(operandArray);
    }

    @Test
    public void testParserWithProperties9() throws ArgsSyntaxException {
        StringProperty stringProperty = new StringProperty(Character.valueOf('f'), "from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail braking.");
        StringProperty stringProperty2 = new StringProperty(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('c'), null, null, "Creates the specified file");
        OrCondition orCondition = new OrCondition(new Term[]{flag, flag2});
        Flag flag3 = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition xorCondition = new XorCondition(new Term[]{orCondition, flag3});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringProperty, stringProperty2, stringOperand});
        String[] stringArray = new String[]{"-f=fromFile", "-t=toFile", "-a", "anOperand"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties10() throws ArgsSyntaxException {
        BooleanProperty booleanProperty = new BooleanProperty("bool1", "The 1st boolean");
        BooleanProperty booleanProperty2 = new BooleanProperty("bool2", "The 2nd boolean");
        BooleanProperty booleanProperty3 = new BooleanProperty("bool3", "The 3rd boolean");
        BooleanProperty booleanProperty4 = new BooleanProperty("bool4", "The 4th boolean");
        AndCondition andCondition = new AndCondition(new Term[]{booleanProperty, booleanProperty2, booleanProperty3, booleanProperty4});
        String[] stringArray = new String[]{"--bool1=true", "--bool2=on", "--bool3=yes", "--bool4=1"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)booleanProperty.getValue());
        Assertions.assertTrue((boolean)booleanProperty2.getValue());
        Assertions.assertTrue((boolean)booleanProperty3.getValue());
        Assertions.assertTrue((boolean)booleanProperty4.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testParserWithProperties11() throws ArgsSyntaxException {
        BooleanProperty booleanProperty = CliSugar.booleanProperty((String)"bool1", (String)"The 1st boolean");
        BooleanProperty booleanProperty2 = CliSugar.booleanProperty((String)"bool2", (String)"The 2nd boolean");
        BooleanProperty booleanProperty3 = CliSugar.booleanProperty((String)"bool3", (String)"The 3rd boolean");
        BooleanProperty booleanProperty4 = CliSugar.booleanProperty((String)"bool4", (String)"The 4th boolean");
        AndCondition andCondition = CliSugar.and((Term[])new Term[]{booleanProperty, booleanProperty2, booleanProperty3, booleanProperty4});
        String[] stringArray = new String[]{"--bool1=false", "--bool2=off", "--bool3=no", "--bool4=0"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        Assertions.assertFalse((boolean)booleanProperty.getValue());
        Assertions.assertFalse((boolean)booleanProperty2.getValue());
        Assertions.assertFalse((boolean)booleanProperty3.getValue());
        Assertions.assertFalse((boolean)booleanProperty4.getValue());
        this.doLogArgs((ParseArgs)argsParser, stringArray);
    }

    @Test
    public void testAliasSyntaxTreeLookup() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption(Character.valueOf('f'), "from", "from", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail braking.");
        StringOption stringOption2 = new StringOption(Character.valueOf('t'), "to", "to", "The destination file to be processed");
        Flag flag = new Flag(Character.valueOf('a'), "--add", "add", "Add the specified file");
        Flag flag2 = new Flag(Character.valueOf('c'), "create", "create", "Creates the specified file");
        OrCondition orCondition = new OrCondition(new Term[]{flag, flag2});
        Flag flag3 = new Flag(Character.valueOf('d'), "delete", "delete", "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition xorCondition = new XorCondition(new Term[]{orCondition, flag3});
        AndCondition andCondition = new AndCondition(new Term[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(andCondition.toSynopsis());
        }
        argsParser.evalArgs(stringArray);
        String string = (String)andCondition.toValue("from");
        String string2 = (String)andCondition.toValue("to");
        boolean bl = (Boolean)andCondition.toValue("add");
        boolean bl2 = (Boolean)andCondition.toValue("create");
        boolean bl3 = (Boolean)andCondition.toValue("delete");
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("From := " + string);
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("To := " + string2);
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Add := " + bl);
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Create := " + bl2);
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Delete := " + bl3);
        }
        Assertions.assertEquals((Object)"fromFile", (Object)string);
        Assertions.assertEquals((Object)"toFile", (Object)string2);
        Assertions.assertTrue((boolean)bl);
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertFalse((boolean)bl3);
    }

    @Test
    public void testArgsProperties() throws ArgsSyntaxException {
        for (int i = 0; i < ARGS.length; ++i) {
            this.testArgs(i);
        }
    }

    @Test
    public void testProductionError() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-l", "1", "-s", "100", "-f", "1"};
        DoubleOption doubleOption = CliSugar.doubleOption((Character)Character.valueOf('f'), (String)"frequency", (String)"FREQUENCY_HZ", (String)"The frequency (Hz) to use when generating the values.");
        IntOption intOption = CliSugar.intOption((Character)Character.valueOf('s'), (String)"sampling-rate", (String)"SAMPLING_RATE", (String)"The sample rate (per second) for the generated values (defaults to DEFAULT_SAMPLING_RATE_PER_SEC samples/second).");
        DoubleOption doubleOption2 = CliSugar.doubleOption((Character)Character.valueOf('l'), (String)"length", (String)"LENGTH_SEC", (String)"The length (in seconds) for the generated values (defaults to DFAULT_LENGTH_SEC seconds).");
        AndCondition andCondition = CliSugar.and((Term[])new Term[]{doubleOption, CliSugar.any((Term[])new Term[]{doubleOption2, intOption})});
        ArgsParser argsParser = new ArgsParser((Term)andCondition);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        argsParser.withName("Waves").withTitle("~waves~").withCopyright("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicense("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        argsParser.withBannerFont(new Font(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        argsParser.withDescription("Generate (sound) wave tables for given frequencies and amplitudes. Export them as CSV for further processing. Makes heavy use of the  REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        argsParser.evalArgs(stringArray);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(andCondition.toSchema());
        }
    }

    @Test
    public void testXorEdgeCase1() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT_PROPERTY", (String)"The text aMessage which to process.");
        Flag flag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given aMessage.");
        XorCondition xorCondition = CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag, stringOption}), new AllCondition((Term)flag)});
        String[] stringArray = new String[]{"-t", "text", "-e"};
        ArgsParser argsParser = new ArgsParser((Term)xorCondition);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        argsParser.evalArgs(stringArray);
        Assertions.assertEquals((Object)"text", (Object)stringOption.getValue());
    }

    @Test
    public void testXorEdgeCase2() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT_PROPERTY", (String)"The text aMessage which to process.");
        Flag flag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given aMessage.");
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag, stringOption}), flag});
        String[] stringArray = new String[]{"-t", "text", "-e"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        argsParser.evalArgs(stringArray);
        Assertions.assertEquals((Object)"text", (Object)stringOption.getValue());
    }

    @Test
    public void testArrayOption1() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"), 1, 3);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParser argsParser = new ArgsParser((Term)arrayOption);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        argsParser.evalArgs(stringArray);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption2() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"), 3);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParser argsParser = new ArgsParser((Term)arrayOption);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption3() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3", "-t", "text4"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"), 1, 3);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParser argsParser = new ArgsParser((Term)arrayOption);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <SuperfluousArgsException>!");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption4() throws ArgsSyntaxException {
        String[] stringArray = new String[]{};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"), 1, 3);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParser argsParser = new ArgsParser((Term)arrayOption);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption5() throws ArgsSyntaxException {
        String[] stringArray = new String[]{};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"));
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParser argsParser = new ArgsParser((Term)new AnyCondition(new Term[]{arrayOption}));
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        argsParser.evalArgs(stringArray);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        Assertions.assertFalse((boolean)arrayOption.hasValue());
        Assertions.assertNull((Object)arrayOption.getValue());
    }

    @Test
    public void testArrayOption6() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"));
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParser argsParser = new ArgsParser((Term)arrayOption);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        argsParser.evalArgs(stringArray);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption7() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"));
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParser argsParser = new ArgsParser((Term)new AnyCondition(new Term[]{arrayOption}));
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        argsParser.evalArgs(stringArray);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
        Assertions.assertEquals((int)(stringArray.length / 2), (int)((String[])arrayOption.getValue()).length);
    }

    @Test
    public void testOperation1() throws ArgsSyntaxException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        VerboseFlag verboseFlag = new VerboseFlag();
        XorCondition xorCondition = new XorCondition(new Term[]{new AndCondition(new Term[]{operation, verboseFlag}), operation2});
        ArgsParser argsParser = new ArgsParser((Term)xorCondition);
        String[] stringArray = new String[]{"ls", "--verbose"};
        argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)operation.isEnabled());
        Assertions.assertTrue((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        xorCondition.reset();
        stringArray = new String[]{"cd"};
        argsParser.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertTrue((boolean)operation2.isEnabled());
    }

    @Test
    public void testNone1() throws ArgsSyntaxException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        NoneOperand noneOperand = new NoneOperand("none", "No arguments at all");
        VerboseFlag verboseFlag = new VerboseFlag(true);
        XorCondition xorCondition = new XorCondition(new Term[]{noneOperand, new AndCondition(new Term[]{operation, verboseFlag}), operation2});
        ArgsParser argsParser = new ArgsParser((Term)xorCondition);
        String[] stringArray = new String[]{"ls", "--verbose"};
        argsParser.evalArgs(stringArray);
        Assertions.assertTrue((boolean)operation.isEnabled());
        Assertions.assertTrue((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        xorCondition.reset();
        stringArray = new String[]{"cd"};
        argsParser.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertTrue((boolean)operation2.isEnabled());
        Assertions.assertFalse((boolean)noneOperand.isEnabled());
    }

    @Test
    public void testNone2() throws ArgsSyntaxException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        NoneOperand noneOperand = new NoneOperand("none", "No arguments at all");
        VerboseFlag verboseFlag = new VerboseFlag();
        XorCondition xorCondition = new XorCondition(new Term[]{noneOperand, new AndCondition(new Term[]{operation, verboseFlag}), operation2});
        String[] stringArray = new String[]{};
        ArgsParser argsParser = new ArgsParser((Term)xorCondition);
        argsParser.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        Assertions.assertTrue((boolean)noneOperand.isEnabled());
    }

    @Test
    public void testNone3() throws ArgsSyntaxException {
        boolean[] blArray = new boolean[]{false};
        NoneOperand noneOperand2 = CliSugar.none((String)"Some Description", noneOperand -> {
            blArray[0] = true;
        });
        HelpFlag helpFlag = CliSugar.helpFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag();
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{sysInfoFlag, CliSugar.xor((Term[])new Term[]{noneOperand2, helpFlag})});
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(new String[]{"--help"});
        Assertions.assertFalse((boolean)noneOperand2.isEnabled());
        Assertions.assertFalse((boolean)blArray[0]);
        Assertions.assertTrue((boolean)helpFlag.isEnabled());
    }

    @Test
    public void testNone4() throws ArgsSyntaxException {
        boolean[] blArray = new boolean[]{false};
        NoneOperand noneOperand2 = CliSugar.none((String)"Some Description", noneOperand -> {
            blArray[0] = true;
        });
        HelpFlag helpFlag = CliSugar.helpFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag();
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{sysInfoFlag, CliSugar.xor((Term[])new Term[]{noneOperand2, helpFlag})});
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(new String[0]);
        Assertions.assertTrue((boolean)noneOperand2.isEnabled());
        Assertions.assertTrue((boolean)blArray[0]);
        Assertions.assertFalse((boolean)helpFlag.isEnabled());
    }

    private void testArgs(int n) throws ArgsSyntaxException {
        ArgsParser argsParser = new ArgsParser();
        HashMap<String, CallSite> hashMap = new HashMap<String, CallSite>();
        String[] stringArray = ARGS[n];
        Operand[] operandArray = argsParser.evalArgs(stringArray);
        for (Operand operand : operandArray) {
            hashMap.put(operand.getAlias(), (CallSite)((Object)String.valueOf(operand.getValue())));
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Line <" + n + ">:");
        }
        Object object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
            System.out.println(string + " := " + (String)hashMap.get(string));
        }
        for (Object object2 : object = PROPERTIES[n]) {
            PropertyImpl propertyImpl = new PropertyImpl((String)object2);
            if ("null".equals(propertyImpl.getKey())) {
                propertyImpl = new PropertyImpl(null, (String)propertyImpl.getValue());
            }
            Assertions.assertEquals((Object)propertyImpl.getValue(), hashMap.get(propertyImpl.getKey()), (String)("Line <" + n + "> (" + propertyImpl.toString() + ")"));
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogArgs(ParseArgs parseArgs, String[] stringArray) {
        Term term = parseArgs.getArgsSyntax();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(Execution.getCallerStackTraceElement().getMethodName());
        }
        ((ParseArgs)parseArgs.withSyntaxMetrics(SyntaxNotation.GNU_POSIX)).printHelp();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (SyntaxNotation syntaxNotation : SyntaxNotation.values()) {
                System.out.println("[" + String.valueOf(syntaxNotation) + " SYNTAX NOTATION]  " + term.toSynopsis(syntaxNotation));
            }
            System.out.println("[COMMAND LINE ARGS] " + new VerboseTextBuilder().withElements((Object[])stringArray).toString());
            System.out.println("[INTERNAL STATUS] " + term.toString());
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogOperands(Operand<?>[] operandArray) {
        Arrays.sort(operandArray);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(Execution.getCallerStackTraceElement().getMethodName());
        }
        for (Operand<?> operand : operandArray) {
            if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
            System.out.println("[OPERAND] " + operand.toSyntax(SyntaxNotation.LOGICAL));
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    static enum BaseMetricsConfig {
        A,
        B,
        C;

    }

    static enum ChaosMode {
        X,
        Y,
        Z;

    }

    static enum SystemContext {
        S0,
        S1,
        S2;

    }

    static enum TrigonometricFunction {
        SINE,
        COSINE;

    }
}

