/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsParserTest;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Condition;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.DoubleProperty;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.IntProperty;
import org.refcodes.cli.LongOption;
import org.refcodes.cli.Operand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.SystemContext;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsSyntaxTest {
    @Test
    public void testConditionsByArgs() {
        String[] stringArray = new String[]{"--string1=someString", "--email=someEmail", "--token=1234567890"};
        ArgsParser argsParser = new ArgsParser();
        Flag flag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag flag2 = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty stringProperty = CliSugar.stringProperty((String)"string1", (String)"...");
        StringProperty stringProperty2 = CliSugar.stringProperty((String)"string2", (String)"...");
        BooleanProperty booleanProperty = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag flag3 = CliSugar.flag((String)"bool", (String)"...");
        StringProperty stringProperty3 = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty stringProperty4 = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty stringProperty5 = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty intProperty = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty doubleProperty = CliSugar.doubleProperty((String)"double", (String)"...");
        Term[] termArray = new Term[3];
        Term[] termArray2 = new Term[2];
        termArray2[0] = stringProperty;
        Term[] termArray3 = new Term[4];
        termArray3[0] = stringProperty2;
        Term[] termArray4 = new Term[3];
        termArray4[0] = booleanProperty;
        termArray4[1] = flag3;
        AndCondition andCondition = CliSugar.and((Term[])new Term[]{stringProperty3, stringProperty4, stringProperty5});
        termArray4[2] = andCondition;
        termArray3[1] = CliSugar.xor((Term[])termArray4);
        termArray3[2] = intProperty;
        termArray3[3] = doubleProperty;
        termArray2[1] = CliSugar.optional((Term[])termArray3);
        termArray[0] = CliSugar.and((Term[])termArray2);
        termArray[1] = flag;
        termArray[2] = flag2;
        CasesCondition casesCondition = CliSugar.cases((Term[])termArray);
        argsParser.withArgsSyntax((Term)casesCondition).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            Condition[] conditionArray = ((Condition)argsParser.getArgsSyntax()).toConditions(argsSyntaxException.getArgs());
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(conditionArray[0]);
            }
            Assertions.assertEquals((int)1, (int)conditionArray.length);
            Assertions.assertEquals((Object)andCondition, (Object)conditionArray[0]);
        }
    }

    @Test
    public void testOperandsByArgs() {
        String[] stringArray = new String[]{"--string1=someString", "--email=someEmail", "--token=1234567890"};
        ArgsParser argsParser = new ArgsParser();
        Flag flag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag flag2 = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty stringProperty = CliSugar.stringProperty((String)"string1", (String)"...");
        StringProperty stringProperty2 = CliSugar.stringProperty((String)"string2", (String)"...");
        BooleanProperty booleanProperty = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag flag3 = CliSugar.flag((String)"bool", (String)"...");
        StringProperty stringProperty3 = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty stringProperty4 = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty stringProperty5 = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty intProperty = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty doubleProperty = CliSugar.doubleProperty((String)"double", (String)"...");
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{stringProperty, CliSugar.optional((Term[])new Term[]{stringProperty2, CliSugar.xor((Term[])new Term[]{booleanProperty, flag3, CliSugar.and((Term[])new Term[]{stringProperty3, stringProperty4, stringProperty5})}), intProperty, doubleProperty})}), flag, flag2});
        argsParser.withArgsSyntax((Term)casesCondition).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            Operand[] operandArray = ((Condition)argsParser.getArgsSyntax()).toOperands(argsSyntaxException.getArgs());
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                for (Operand operand : operandArray) {
                    System.out.println(operand);
                }
            }
            Assertions.assertEquals((int)3, (int)operandArray.length);
            List<Operand> list = Arrays.asList(operandArray);
            Assertions.assertTrue((boolean)list.contains(stringProperty));
            Assertions.assertTrue((boolean)list.contains(stringProperty3));
            Assertions.assertTrue((boolean)list.contains(stringProperty5));
        }
    }

    @Test
    public void testEdgeCase1() {
        Flag flag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the message (stream, file, text or bytes).");
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        StringOption stringOption3 = CliSugar.stringOption((Character)Character.valueOf('p'), (String)"password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
        Term term = this.createEdgeCaseSyntax(flag, stringOption, stringOption2, stringOption3);
        String[] stringArray = new String[]{"-e", "-i", "in.txt", "-o", "out.txt", "-p", "Secret123!"};
        ArgsParser argsParser = new ArgsParser(term);
        try {
            Operand[] operandArray = argsParser.evalArgs(stringArray);
            Assertions.assertEquals((int)4, (int)operandArray.length);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(term.toSchema());
                System.out.println(argsSyntaxException.toHeuristicMessage());
            }
            Assertions.fail((String)"Expecting the arguments syntax to be parsed correctly!");
        }
        Assertions.assertTrue((boolean)flag.isEnabled());
        Assertions.assertEquals((Object)"in.txt", (Object)stringOption.getValue());
        Assertions.assertEquals((Object)"out.txt", (Object)stringOption2.getValue());
        Assertions.assertEquals((Object)"Secret123!", (Object)stringOption3.getValue());
    }

    @Test
    public void testEdgeCase2() {
        block3: {
            Flag flag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the message (stream, file, text or bytes).");
            StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
            StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
            StringOption stringOption3 = CliSugar.stringOption((Character)Character.valueOf('p'), (String)"password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
            Term term = this.createEdgeCaseSyntax(flag, stringOption, stringOption2, stringOption3);
            String[] stringArray = new String[]{"-d", "-e", "-i", "in.txt", "-o", "out.txt", "-p", "Secret123!"};
            ArgsParser argsParser = new ArgsParser(term);
            try {
                argsParser.evalArgs(stringArray);
                if (SystemProperty.LOG_TESTS.isEnabled()) {
                    System.out.println(term.toSchema());
                }
                Assertions.fail((String)("Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!"));
            }
            catch (ArgsSyntaxException argsSyntaxException) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println(argsSyntaxException.toHeuristicMessage());
            }
        }
    }

    private Term createEdgeCaseSyntax(Flag flag, StringOption stringOption, StringOption stringOption2, StringOption stringOption3) {
        EnumOption enumOption = CliSugar.enumOption((String)"encoding", ArgsParserTest.BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.BaseMetricsConfig.values())));
        EnumOption enumOption2 = CliSugar.enumOption((String)"cert-mode", ArgsParserTest.ChaosMode.class, (String)"CERT_MODE_PROPERTY", (String)("The chaos options (mode) to be used for the cert itself: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.ChaosMode.values())));
        EnumOption enumOption3 = CliSugar.enumOption((String)"chaos-mode", ArgsParserTest.ChaosMode.class, (String)"CHAOS_MODE_PROPERTY", (String)("The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.ChaosMode.values())));
        EnumOption enumOption4 = CliSugar.enumOption((String)"context", SystemContext.class, (String)"CONTEXT_PROPERTY", (String)("The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values())));
        Flag flag2 = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag flag3 = CliSugar.flag((String)"cert-info", (String)"CERT_INFO_PROPERTY", (String)"Prints out information of a given cert.");
        Flag flag4 = CliSugar.flag((String)"create-cert", (String)"CREATE_CERT_PROPERTY", (String)"Create an according cert record (file).");
        Flag flag5 = CliSugar.flag((String)"create-spec", (String)"CREATE_SPEC_PROPERTY", (String)"Create an according spec record (file).");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        Flag flag6 = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the message (stream, file, text or bytes).");
        Flag flag7 = CliSugar.flag((String)"encoded-length", (String)"ENCODED_LENGTH_PROPERTY", (String)"Prints length in bytes of a single chaos key encoding (being the addional length of a salted encryption).");
        HelpFlag helpFlag = CliSugar.helpFlag();
        Flag flag8 = CliSugar.flag((String)"hex", (String)"HEX_PROPERTY", (String)"Use a hexadecimal representation of (binary) output.");
        Flag flag9 = CliSugar.flag((String)"prompt", (String)"PROMPT_PASSWORD_PROPERTY", (String)"Prompt for the password to use for encryption or decryption.");
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        Flag flag10 = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        Flag flag11 = CliSugar.flag((String)"copy-to", (String)"COPY_TO_PROPERTY", (String)"Copy the processed output data to the clipboard.");
        Flag flag12 = CliSugar.flag((String)"paste-from", (String)"PASTE_FROM_PROPERTY", (String)"Paste the input data to be processed from the clipboard.");
        IntOption intOption = CliSugar.intOption((String)"chain-length", (String)"CHAIN_LENGTH_PROPERTY", (String)"The length of the chaos key chain (e.g. number of nested chaos keys, defaults to <...>)");
        IntOption intOption2 = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.");
        DoubleOption doubleOption = CliSugar.doubleOption((Character)Character.valueOf('x'), (String)"start-value", (String)"X0_PROPERTY", (String)"The chaos key's <x0> start value to use: ...");
        DoubleOption doubleOption2 = CliSugar.doubleOption((Character)Character.valueOf('a'), (String)"parable-coefficient", (String)"A_PROPERTY", (String)"The chaos key's parable coefficient <a> to use: ...");
        LongOption longOption = CliSugar.longOption((Character)Character.valueOf('s'), (String)"expansion-factor", (String)"S_PROPERTY", (String)"The chaos key's expansion factor <s> to use: ...");
        StringOption stringOption4 = CliSugar.stringOption((Character)Character.valueOf('b'), (String)"bytes", (String)"BYTES_PROPERTY", (String)"The message in bytes (e.g. \"127, 128, 0x10, 0xFF\") which to process.");
        StringOption stringOption5 = CliSugar.stringOption((Character)Character.valueOf('c'), (String)"cert-file", (String)"CERT_FILE_PROPERTY", (String)"The cert file file which to use.");
        StringOption stringOption6 = CliSugar.stringOption((String)"spec-file", (String)"SPEC_FILE_PROPERTY", (String)"The spec file file which to use.");
        StringOption stringOption7 = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag, CliSugar.any((Term[])new Term[]{flag10})}), CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{stringOption7, stringOption4})}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag8, flag2, enumOption}), CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption3, enumOption4, CliSugar.and((Term[])new Term[]{doubleOption, doubleOption2, longOption})}), enumOption3}), CliSugar.and((Term[])new Term[]{stringOption5, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption3, enumOption4})})})}), verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag6, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{stringOption7, stringOption4})}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag2, enumOption}), flag8, CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption3, enumOption4, CliSugar.and((Term[])new Term[]{doubleOption, doubleOption2, longOption})}), enumOption3}), CliSugar.and((Term[])new Term[]{stringOption5, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption3, enumOption4})})})}), verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{stringOption, flag12}), CliSugar.xor((Term[])new Term[]{stringOption2, flag11}), CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag2, enumOption}), CliSugar.any((Term[])new Term[]{intOption2})}), flag10})}), CliSugar.and((Term[])new Term[]{flag6, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{stringOption, flag12}), CliSugar.xor((Term[])new Term[]{stringOption2, flag11}), CliSugar.xor((Term[])new Term[]{flag2, enumOption})})})}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption3, enumOption4, CliSugar.and((Term[])new Term[]{doubleOption, doubleOption2, longOption})}), enumOption3}), CliSugar.and((Term[])new Term[]{stringOption5, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption3, enumOption4})})})}), verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag4, CliSugar.any((Term[])new Term[]{intOption2, stringOption5, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption3, enumOption4}), CliSugar.any((Term[])new Term[]{enumOption2})}), CliSugar.xor((Term[])new Term[]{CliSugar.or((Term[])new Term[]{intOption, enumOption3}), stringOption6}), verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag3, stringOption5, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption3, enumOption4}), verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag5, CliSugar.any((Term[])new Term[]{stringOption6, verboseFlag, debugFlag})}), CliSugar.xor((Term[])new Term[]{helpFlag, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag7, sysInfoFlag}), CliSugar.any((Term[])new Term[]{verboseFlag, debugFlag})})})});
        return casesCondition;
    }
}

