/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.Term;
import org.refcodes.runtime.SystemProperty;

public class LambdaTest {
    @Test
    public void testStringOptionLambda1() throws ArgsSyntaxException {
        String[] stringArray = new String[1];
        Term[] termArray = new Term[1];
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", stringOption -> {
            System.out.println(stringOption.getAlias() + "=" + (String)stringOption.getValue());
            stringArray[0] = (String)stringOption.getValue();
        });
        termArray[0] = stringOption2;
        CasesCondition casesCondition = CliSugar.cases((Term[])termArray);
        String[] stringArray2 = new String[]{"-s", "Hello World!"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(stringArray2);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringArray[0]);
        Assertions.assertEquals((Object)stringOption2.getValue(), (Object)stringArray[0]);
    }

    @Test
    public void testStringOptionLambda2() throws ArgsSyntaxException {
        String[] stringArray = new String[1];
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", stringOption -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(stringOption.getAlias() + "=" + (String)stringOption.getValue());
            }
            stringArray[0] = (String)stringOption.getValue();
        });
        termArray2[0] = stringOption2;
        termArray2[1] = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT", (String)"Don't invoke lambda upon parsing", stringOption -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(stringOption.getAlias() + "=" + (String)stringOption.getValue());
            }
            Assertions.fail((String)"This option did NOT match any of the provided arguments!");
        });
        termArray[0] = CliSugar.any((Term[])termArray2);
        CasesCondition casesCondition = CliSugar.cases((Term[])termArray);
        String[] stringArray2 = new String[]{"-s", "Hello World!"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(stringArray2);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringArray[0]);
        Assertions.assertEquals((Object)stringOption2.getValue(), (Object)stringArray[0]);
    }

    @Test
    public void testStringOptionLambda3() throws ArgsSyntaxException {
        String[] stringArray = new String[2];
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", stringOption -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(stringOption.getAlias() + "=" + (String)stringOption.getValue());
            }
            stringArray[0] = (String)stringOption.getValue();
        });
        termArray2[0] = stringOption2;
        StringOption stringOption3 = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT", (String)"Invoke lambda upon parsing", stringOption -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(stringOption.getAlias() + "=" + (String)stringOption.getValue());
            }
            stringArray[1] = (String)stringOption.getValue();
        });
        termArray2[1] = stringOption3;
        termArray[0] = CliSugar.any((Term[])termArray2);
        CasesCondition casesCondition = CliSugar.cases((Term[])termArray);
        String[] stringArray2 = new String[]{"-s", "Hello World!", "-t", "Hallo Welt!"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(stringArray2);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringArray[0]);
        Assertions.assertEquals((Object)"Hallo Welt!", (Object)stringArray[1]);
        Assertions.assertEquals((Object)stringOption2.getValue(), (Object)stringArray[0]);
        Assertions.assertEquals((Object)stringOption3.getValue(), (Object)stringArray[1]);
    }

    @Test
    public void testStringPropertyLambda1() throws ArgsSyntaxException {
        String[] stringArray = new String[1];
        Term[] termArray = new Term[1];
        StringProperty stringProperty2 = CliSugar.stringProperty((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", stringProperty -> {
            System.out.println(stringProperty.getAlias() + "=" + (String)stringProperty.getValue());
            stringArray[0] = (String)stringProperty.getValue();
        });
        termArray[0] = stringProperty2;
        CasesCondition casesCondition = CliSugar.cases((Term[])termArray);
        String[] stringArray2 = new String[]{"-s=Hello World!"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(stringArray2);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringArray[0]);
        Assertions.assertEquals((Object)stringProperty2.getValue(), (Object)stringArray[0]);
    }

    @Test
    public void testStringPropertyLambda2() throws ArgsSyntaxException {
        String[] stringArray = new String[1];
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        StringProperty stringProperty2 = CliSugar.stringProperty((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", stringProperty -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(stringProperty.getAlias() + "=" + (String)stringProperty.getValue());
            }
            stringArray[0] = (String)stringProperty.getValue();
        });
        termArray2[0] = stringProperty2;
        termArray2[1] = CliSugar.stringProperty((Character)Character.valueOf('t'), (String)"text", (String)"TEXT", (String)"Don't invoke lambda upon parsing", stringProperty -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(stringProperty.getAlias() + "=" + (String)stringProperty.getValue());
            }
            Assertions.fail((String)"This option did NOT match any of the provided arguments!");
        });
        termArray[0] = CliSugar.any((Term[])termArray2);
        CasesCondition casesCondition = CliSugar.cases((Term[])termArray);
        String[] stringArray2 = new String[]{"-s=Hello World!"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(stringArray2);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringArray[0]);
        Assertions.assertEquals((Object)stringProperty2.getValue(), (Object)stringArray[0]);
    }

    @Test
    public void testStringPropertyLambda3() throws ArgsSyntaxException {
        String[] stringArray = new String[2];
        Term[] termArray = new Term[1];
        Term[] termArray2 = new Term[2];
        StringProperty stringProperty2 = CliSugar.stringProperty((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", stringProperty -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(stringProperty.getAlias() + "=" + (String)stringProperty.getValue());
            }
            stringArray[0] = (String)stringProperty.getValue();
        });
        termArray2[0] = stringProperty2;
        StringProperty stringProperty3 = CliSugar.stringProperty((Character)Character.valueOf('t'), (String)"text", (String)"TEXT", (String)"Invoke lambda upon parsing", stringProperty -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(stringProperty.getAlias() + "=" + (String)stringProperty.getValue());
            }
            stringArray[1] = (String)stringProperty.getValue();
        });
        termArray2[1] = stringProperty3;
        termArray[0] = CliSugar.any((Term[])termArray2);
        CasesCondition casesCondition = CliSugar.cases((Term[])termArray);
        String[] stringArray2 = new String[]{"-s=Hello World!", "-t=Hallo Welt!"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition);
        argsParser.evalArgs(stringArray2);
        Assertions.assertEquals((Object)"Hello World!", (Object)stringArray[0]);
        Assertions.assertEquals((Object)"Hallo Welt!", (Object)stringArray[1]);
        Assertions.assertEquals((Object)stringProperty2.getValue(), (Object)stringArray[0]);
        Assertions.assertEquals((Object)stringProperty3.getValue(), (Object)stringArray[1]);
    }

    @Test
    public void testIllegalArgumentLambda() throws ArgsSyntaxException {
        String string = "Unable to parse provided argument(s) [\"-s\", \"Hello World!\"] for operand \"-s --string <STRING>\"! Caused by: Bad input!";
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.stringOption((Character)Character.valueOf('s'), (String)"string", (String)"STRING", (String)"Invoke lambda upon parsing", stringOption -> {
            throw new IllegalArgumentException("Bad input!");
        })});
        String[] stringArray = new String[]{"-s", "Hello World!"};
        ArgsParser argsParser = new ArgsParser((Term)casesCondition).withEscapeCodesEnabled(false);
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expecting an exception of type <" + ArgsSyntaxException.class.getName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("Expected  = " + string);
                System.out.println("Exception = " + argsSyntaxException.toHeuristicMessage());
            }
            Assertions.assertEquals((Object)string, (Object)argsSyntaxException.toHeuristicMessage());
        }
    }
}

