/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.DoubleProperty;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.IntProperty;
import org.refcodes.cli.LongOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class MessageTest {
    @Test
    public void testHeuristicMessageA1() {
        String[] stringArray = new String[]{"--string=someString", "--token=1234567890"};
        ArgsParser argsParser = MessageTest.createArgsParserA();
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expected an exception of type <" + ArgsSyntaxException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            String string = argsSyntaxException.toMessage();
            String string2 = argsSyntaxException.toHeuristicMessage();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("toMessage() = " + string);
                System.out.println("toHeuristicMessage() = " + string2);
            }
            Assertions.assertEquals((Object)"No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched (ALL) without any surplus by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)string);
            Assertions.assertEquals((Object)"Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched (ALL) without any surplus by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)string2);
        }
    }

    @Test
    public void testHeuristicMessageA2() {
        String[] stringArray = new String[]{"--string=someString", "--email=someEmail", "--token=1234567890"};
        ArgsParser argsParser = MessageTest.createArgsParserA();
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expected an exception of type <" + ArgsSyntaxException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            String string = argsSyntaxException.toMessage();
            String string2 = argsSyntaxException.toHeuristicMessage();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("toMessage() = " + string);
                System.out.println("toHeuristicMessage() = " + string2);
            }
            Assertions.assertEquals((Object)"No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of (mutual) superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched (ALL) without any surplus by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)string);
            Assertions.assertEquals((Object)"Failed as of (mutual) superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched (ALL) without any surplus by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)string2);
        }
    }

    @Test
    public void testHeuristicMessageB1() {
        String[] stringArray = new String[]{"-d", "-t"};
        ArgsParser argsParser = MessageTest.createArgsParserB();
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expected an exception of type <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            String string = argsSyntaxException.toMessage();
            String string2 = argsSyntaxException.toHeuristicMessage();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("toMessage() = " + string);
                System.out.println("toHeuristicMessage() = " + string2);
            }
            Assertions.assertEquals((Object)"No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Also notable: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: Neither the short-option \"-e\" nor the long-option \"--encrypt\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Failed as of superfluous \"-t\" argument, though the arguments must be matched (ALL) without any surplus by the syntax branches! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--create-cert\" was found in the command line arguments, provide it to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--cert-info\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-c\" nor the long-option \"--cert-file\" were found in the command line arguments, provide at least one of them to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--create-spec\" was found in the command line arguments, provide it to match the according syntax branch! No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: No option \"--help\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: No option \"--encoded-length\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--sysinfo\" was found in the command line arguments, provide it to match the according syntax branch! Caused by: Neither the short-option \"-e\" nor the long-option \"--encrypt\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Also notable: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)string);
            Assertions.assertEquals((Object)"Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Possible cause: Failed as of superfluous \"-t\" argument, though the arguments must be matched (ALL) without any surplus by the syntax branches!", (Object)string2);
        }
    }

    private static ArgsParser createArgsParserA() {
        ArgsParser argsParser = new ArgsParser();
        Flag flag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag flag2 = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty stringProperty = CliSugar.stringProperty((String)"string", (String)"...");
        StringProperty stringProperty2 = CliSugar.stringProperty((String)"string", (String)"...");
        BooleanProperty booleanProperty = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag flag3 = CliSugar.flag((String)"bool", (String)"...");
        StringProperty stringProperty3 = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty stringProperty4 = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty stringProperty5 = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty intProperty = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty doubleProperty = CliSugar.doubleProperty((String)"double", (String)"...");
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{stringProperty, CliSugar.optional((Term[])new Term[]{stringProperty2, CliSugar.xor((Term[])new Term[]{booleanProperty, flag3, CliSugar.and((Term[])new Term[]{stringProperty3, stringProperty4, stringProperty5})}), intProperty, doubleProperty})}), flag, flag2});
        return argsParser.withArgsSyntax((Term)casesCondition).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
    }

    private static ArgsParser createArgsParserB() {
        ArgsParser argsParser = new ArgsParser();
        EnumOption enumOption = CliSugar.enumOption((String)"encoding", BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])BaseMetricsConfig.values())));
        EnumOption enumOption2 = CliSugar.enumOption((String)"cert-mode", ChaosMode.class, (String)"CERT_MODE_PROPERTY", (String)("The chaos options (mode) to be used for the cert itself: " + VerboseTextBuilder.asString((Object[])ChaosMode.values())));
        EnumOption enumOption3 = CliSugar.enumOption((String)"chaos-mode", ChaosMode.class, (String)"CERT_MODE_PROPERTY", (String)("The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString((Object[])ChaosMode.values())));
        EnumOption enumOption4 = CliSugar.enumOption((String)"context", SystemContext.class, (String)"CONTEXT_PROPERTY", (String)("The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values())));
        Flag flag = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag flag2 = CliSugar.flag((String)"cert-info", (String)"CERT_INFO_PROPERTY", (String)"Prints out information of a given cert.");
        Flag flag3 = CliSugar.flag((String)"create-cert", (String)"CREATE_CERT_PROPERTY", (String)"Create an according cert record (file).");
        Flag flag4 = CliSugar.flag((String)"create-spec", (String)"CREATE_SPEC_PROPERTY", (String)"Create an according spec record (file).");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        Flag flag5 = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the message (stream, file, text or bytes).");
        Flag flag6 = CliSugar.flag((String)"encoded-length", (String)"ENCODED_LENGTH_PROPERTY", (String)"Prints length in bytes of a single chaos key encoding (being the addional length of a salted encryption).");
        Flag flag7 = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the message (stream, file, text or bytes).");
        HelpFlag helpFlag = CliSugar.helpFlag();
        Flag flag8 = CliSugar.flag((String)"hex", (String)"HEX_PROPERTY", (String)"Use a hexadecimal representation of (binary) output.");
        Flag flag9 = CliSugar.flag((String)"prompt", (String)"PROMPT_PASSWORD_PROPERTY", (String)"Prompt for the password to use for encryption or decryption.");
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        Flag flag10 = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        Flag flag11 = CliSugar.flag((String)"copy-to", (String)"COPY_TO_PROPERTY", (String)("Copy the processed output data to the clipboard" + (Execution.isNativeImage() ? " (without warranty)" : "") + "."));
        Flag flag12 = CliSugar.flag((String)"paste-from", (String)"PASTE_FROM_PROPERTY", (String)("Paste the input data to be processed from the clipboard" + (Execution.isNativeImage() ? " (without warranty)" : "") + "."));
        IntOption intOption = CliSugar.intOption((String)"chain-length", (String)"CHAIN_LENGTH_PROPERTY", (String)"The length of the chaos key chain (e.g. number of nested chaos keys, defaults to <>)");
        IntOption intOption2 = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.");
        DoubleOption doubleOption = CliSugar.doubleOption((Character)Character.valueOf('x'), (String)"start-value", (String)"X0_PROPERTY", (String)"The chaos key's <x0> start value to use: < x0 \u2264 ");
        DoubleOption doubleOption2 = CliSugar.doubleOption((Character)Character.valueOf('a'), (String)"parable-coefficient", (String)"A_PROPERTY", (String)"The chaos key's parable coefficient <a> to use: \u2264 a \u2264 ");
        LongOption longOption = CliSugar.longOption((Character)Character.valueOf('s'), (String)"expansion-factor", (String)"S_PROPERTY", (String)"The chaos key's expansion factor <s> to use: \u2264 s \u2264 or \u2264 s \u2264 ");
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('b'), (String)"bytes", (String)"BYTES_PROPERTY", (String)"The message in bytes (e.g. \"127, 128, 0x10, 0xFF\") which to process.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('c'), (String)"cert-file", (String)"CERT_FILE_PROPERTY", (String)"The cert file file which to use.");
        StringOption stringOption3 = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption4 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        StringOption stringOption5 = CliSugar.stringOption((Character)Character.valueOf('p'), (String)"password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
        StringOption stringOption6 = CliSugar.stringOption((String)"spec-file", (String)"SPEC_FILE_PROPERTY", (String)"The spec file file which to use.");
        StringOption stringOption7 = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag7, CliSugar.xor((Term[])new Term[]{stringOption7, stringOption}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag8, flag, enumOption}), CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4, CliSugar.and((Term[])new Term[]{doubleOption, doubleOption2, longOption})}), enumOption3}), CliSugar.and((Term[])new Term[]{stringOption2, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4})})})}), flag11, flag10, verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag5, CliSugar.xor((Term[])new Term[]{stringOption7, stringOption}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag, enumOption}), flag8, CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4, CliSugar.and((Term[])new Term[]{doubleOption, doubleOption2, longOption})}), enumOption3}), CliSugar.and((Term[])new Term[]{stringOption2, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4})})})}), flag11, verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag7, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{stringOption3, flag12}), CliSugar.xor((Term[])new Term[]{stringOption4, flag11}), CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag, enumOption}), CliSugar.any((Term[])new Term[]{intOption2})}), CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4, CliSugar.and((Term[])new Term[]{doubleOption, doubleOption2, longOption})}), enumOption3}), CliSugar.and((Term[])new Term[]{stringOption2, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4})})})}), flag10, verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag5, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{stringOption3, flag12}), CliSugar.xor((Term[])new Term[]{stringOption4, flag11}), CliSugar.xor((Term[])new Term[]{flag, enumOption}), CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4, CliSugar.and((Term[])new Term[]{doubleOption, doubleOption2, longOption})}), enumOption3}), CliSugar.and((Term[])new Term[]{stringOption2, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4})})})}), verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag3, CliSugar.any((Term[])new Term[]{intOption2, stringOption2, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4}), CliSugar.any((Term[])new Term[]{enumOption2})}), CliSugar.xor((Term[])new Term[]{CliSugar.or((Term[])new Term[]{intOption, enumOption3}), stringOption6}), verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag2, stringOption2, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag9, stringOption5, enumOption4}), verboseFlag, debugFlag})}), CliSugar.and((Term[])new Term[]{flag4, CliSugar.any((Term[])new Term[]{stringOption6, verboseFlag, debugFlag})}), CliSugar.xor((Term[])new Term[]{helpFlag, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{flag6, sysInfoFlag}), CliSugar.any((Term[])new Term[]{verboseFlag, debugFlag})})})});
        return argsParser.withArgsSyntax((Term)casesCondition).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
    }

    public static enum BaseMetricsConfig {
        CONF_A,
        CONF_B,
        CONF_C;

    }

    static enum ChaosMode {
        X,
        Y,
        Z;

    }

    static enum SystemContext {
        S0,
        S1,
        S2;

    }
}

