/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class OptionalConditionTest {
    @Test
    public void testOptionalEdgeCase() {
        IntOption intOption = CliSugar.intOption((Character)Character.valueOf('w'), (String)"width", (String)"width", (String)"Sets the console width");
        IntOption intOption2 = CliSugar.intOption((Character)Character.valueOf('p'), (String)"port", (String)"port", (String)"Sets the port for the server");
        IntOption intOption3 = CliSugar.intOption((Character)Character.valueOf('c'), (String)"connections", (String)"connections", (String)"Sets the number of max. connections");
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('u'), (String)"user", (String)"username", (String)"The username for HTTP Basic-Authentication");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"secret", (String)"secret", (String)"The password for HTTP Basic-Authentication");
        Flag flag = CliSugar.flag(null, (String)"sysinfo", (String)"sysInfo", (String)"Shows some system information");
        IntOption intOption4 = CliSugar.intOption((Character)Character.valueOf('m'), (String)"management-port", (String)"management-port", (String)"The management-port on which to listen for shutdown...");
        HelpFlag helpFlag = CliSugar.helpFlag((String)"Shows this help");
        AnyCondition anyCondition = CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{intOption2, intOption3, CliSugar.and((Term[])new Term[]{stringOption, stringOption2}), intOption, intOption4}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{helpFlag, flag})})})});
        ArgsParser argsParser = new ArgsParser((Term)anyCondition);
        argsParser.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        argsParser.withName("TinyRestful").withTitle("TINYRESTFUL").withCopyright("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicense("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        argsParser.withBannerFont(new Font(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        argsParser.withDescription("Tiny evil RESTful server. TinyRestfulServer makes heavy use of the REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        String[] stringArray = new String[]{"-p", "8080", "--sysinfo"};
        try {
            argsParser.evalArgs(stringArray);
            Assertions.fail((String)("Expecting a <" + SuperfluousArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(new VerboseTextBuilder().withElements((Object[])argsSyntaxException.getArgs()).toString());
            }
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(argsSyntaxException.toHeuristicMessage());
            }
            Assertions.assertEquals((int)3, (int)argsSyntaxException.getArgs().length);
        }
    }
}

