/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsParserTest;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class SyntaxNotationTest {
    @Test
    public void testVisibility1() throws ArgsSyntaxException {
        EnumOption enumOption = CliSugar.enumOption((String)"encoding", ArgsParserTest.BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.BaseMetricsConfig.values())));
        Flag flag = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag flag2 = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the aMessage (stream, file, text or bytes).");
        Flag flag3 = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the aMessage (stream, file, text or bytes).");
        Flag flag4 = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        IntOption intOption = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.").withVisible(true);
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        AndCondition andCondition = CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag3, CliSugar.any((Term[])new Term[]{flag4, CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag, CliSugar.any((Term[])new Term[]{intOption})}), CliSugar.and((Term[])new Term[]{enumOption, CliSugar.any((Term[])new Term[]{intOption})})})})}), flag2}), CliSugar.any((Term[])new Term[]{stringOption, stringOption2})});
        ArgsParser argsParser = new ArgsParser((Term)andCondition).withConsoleWidth(180).withEscapeCodesEnabled(false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        argsParser.printSynopsis(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printDescription(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printOptions(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printExamples(printStream);
        String string = byteArrayOutputStream.toString();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(string);
        }
        Assertions.assertTrue((boolean)string.toLowerCase().contains("line-width"));
        Assertions.assertEquals((int)2495, (int)string.replaceAll("[\\n\\r]+", "\\n").length());
    }

    @Test
    public void testVisibility2() throws ArgsSyntaxException {
        EnumOption enumOption = CliSugar.enumOption((String)"encoding", ArgsParserTest.BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.BaseMetricsConfig.values())));
        Flag flag = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag flag2 = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the aMessage (stream, file, text or bytes).");
        Flag flag3 = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the aMessage (stream, file, text or bytes).");
        Flag flag4 = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        IntOption intOption = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.").withVisible(false);
        StringOption stringOption = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        AndCondition andCondition = CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag3, CliSugar.any((Term[])new Term[]{flag4, CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{flag, CliSugar.any((Term[])new Term[]{intOption})}), CliSugar.and((Term[])new Term[]{enumOption, CliSugar.any((Term[])new Term[]{intOption})})})})}), flag2}), CliSugar.any((Term[])new Term[]{stringOption, stringOption2})});
        ArgsParser argsParser = new ArgsParser((Term)andCondition).withConsoleWidth(180).withEscapeCodesEnabled(false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        argsParser.printSynopsis(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printDescription(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printOptions(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printExamples(printStream);
        String string = byteArrayOutputStream.toString();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(string);
        }
        Assertions.assertFalse((boolean)string.toLowerCase().contains("line-width"));
        Assertions.assertEquals((int)2133, (int)string.replaceAll("[\\n\\r]+", "\\n").length());
    }

    @Test
    public void testEscapeCodes1() {
        int n;
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{CliSugar.debugFlag(), CliSugar.verboseFlag()}), CliSugar.xor((Term[])new Term[]{CliSugar.helpFlag(), CliSugar.and((Term[])new Term[]{CliSugar.sysInfoFlag(), CliSugar.any((Term[])new Term[]{CliSugar.verboseFlag()})})})});
        ArgsParser argsParser = new ArgsParser((Term)casesCondition).withEscapeCodesEnabled(true).withConsoleWidth(180);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        argsParser.printBanner(printStream);
        argsParser.printLicense(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printSynopsis(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printDescription(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printOptions(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printExamples(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printCopyright(printStream);
        argsParser.printSeparatorLn(printStream);
        String string = byteArrayOutputStream.toString();
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != AnsiEscapeCode.ESCAPE) continue;
            ++n2;
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(string);
        }
        n = OperatingSystem.WINDOWS.isDetected() ? 342 : 330;
        Assertions.assertEquals((int)n, (int)n2);
    }

    @Test
    public void testEscapeCodes2() {
        CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{CliSugar.debugFlag(), CliSugar.verboseFlag()}), CliSugar.xor((Term[])new Term[]{CliSugar.helpFlag(), CliSugar.and((Term[])new Term[]{CliSugar.sysInfoFlag(), CliSugar.any((Term[])new Term[]{CliSugar.verboseFlag()})})})});
        ArgsParser argsParser = new ArgsParser((Term)casesCondition).withEscapeCodesEnabled(false).withConsoleWidth(180);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        argsParser.printBanner(printStream);
        argsParser.printLicense(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printSynopsis(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printDescription(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printOptions(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printExamples(printStream);
        argsParser.printSeparatorLn(printStream);
        argsParser.printCopyright(printStream);
        argsParser.printSeparatorLn(printStream);
        String string = byteArrayOutputStream.toString();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != AnsiEscapeCode.ESCAPE) continue;
            ++n;
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(string);
        }
        Assertions.assertEquals((int)0, (int)n);
    }

    @Test
    public void testSyntaxNotations() {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (SyntaxNotation syntaxNotation : SyntaxNotation.values()) {
                System.out.println(String.valueOf(syntaxNotation) + ".emptySymbol=" + syntaxNotation.getEmptySymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".allSymbol=" + syntaxNotation.getAllSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".andSymbol=" + syntaxNotation.getAndSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".anySymbol=" + syntaxNotation.getAnySymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".orSymbol=" + syntaxNotation.getOrSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".xorSymbol=" + syntaxNotation.getXorSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".argumentPrefix=" + syntaxNotation.getArgumentPrefix());
                System.out.println(String.valueOf(syntaxNotation) + ".argumentSuffix=" + syntaxNotation.getArgumentSuffix());
                System.out.println(String.valueOf(syntaxNotation) + ".beginArraySymbol=" + syntaxNotation.getBeginArraySymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".beginListSymbol=" + syntaxNotation.getBeginListSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".beginOptionalSymbol=" + syntaxNotation.getBeginOptionalSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".beginRangeSymbol=" + syntaxNotation.getBeginRangeSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".endArraySymbol=" + syntaxNotation.getEndArraySymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".endListSymbol=" + syntaxNotation.getEndListSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".endOptionalSymbol=" + syntaxNotation.getEndOptionalSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".endRangeSymbol=" + syntaxNotation.getEndRangeSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".intervalSymbol=" + syntaxNotation.getIntervalSymbol());
                System.out.println(String.valueOf(syntaxNotation) + ".longOptionPrefix=" + syntaxNotation.getLongOptionPrefix());
                System.out.println(String.valueOf(syntaxNotation) + ".shortOptionPrefix=" + syntaxNotation.getShortOptionPrefix());
                System.out.println();
            }
        }
    }

    @Test
    public void testSynopsis() {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            CasesCondition casesCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{CliSugar.debugFlag(), CliSugar.verboseFlag()}), CliSugar.xor((Term[])new Term[]{CliSugar.helpFlag(), CliSugar.and((Term[])new Term[]{CliSugar.sysInfoFlag(), CliSugar.any((Term[])new Term[]{CliSugar.verboseFlag()})})})});
            System.out.println(casesCondition.toSynopsis(SyntaxNotation.GNU_POSIX));
            System.out.println();
            System.out.println(casesCondition.toSchema());
        }
    }
}

