/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Term;

public abstract class AbstractCondition
extends AbstractTerm
implements Condition {
    protected Term[] _children;

    public AbstractCondition(String string, Term ... termArray) {
        super(string);
        this._children = termArray;
    }

    @Override
    public int getMatchCount() {
        int n = 0;
        for (Term term : this._children) {
            n += term.getMatchCount();
        }
        return n;
    }

    @Override
    public void reset() {
        super.reset();
        for (Term term : this._children) {
            term.reset();
        }
    }

    @Override
    public <T extends Operand<?>> T toOperand(String string, Class<T> clazz) {
        for (Term term : this._children) {
            Condition condition;
            Operand operand;
            if (term instanceof Operand) {
                operand = (Operand)term;
                boolean bl = true;
                boolean bl2 = true;
                if (string != null && string.length() != 0) {
                    bl2 = string.equals(operand.getAlias());
                }
                if (clazz != null) {
                    bl = clazz.isAssignableFrom(operand.getClass());
                }
                if (!bl || !bl2) continue;
                return (T)operand;
            }
            if (!(term instanceof Condition) || (operand = (condition = (Condition)term).toOperand(string, clazz)) == null) continue;
            return (T)operand;
        }
        return null;
    }

    @Override
    public Operand<?>[] toOperands() {
        ArrayList arrayList = new ArrayList();
        for (Term term : this._children) {
            Operand<?>[] operandArray;
            if (term instanceof Operand) {
                arrayList.add((Operand)term);
            }
            if (!(term instanceof Condition) || (operandArray = ((Condition)term).toOperands()) == null || operandArray.length == 0) continue;
            for (Operand<?> operand : operandArray) {
                arrayList.add(operand);
            }
        }
        return arrayList.toArray(new Operand[arrayList.size()]);
    }

    @Override
    public CliSchema toSchema() {
        CliSchema[] cliSchemaArray = null;
        if (this._children != null && this._children.length != 0) {
            cliSchemaArray = new CliSchema[this._children.length];
            for (int i = 0; i < cliSchemaArray.length; ++i) {
                cliSchemaArray[i] = this._children[i].toSchema();
            }
        }
        CliSchema cliSchema = new CliSchema(this.getClass(), this._description, cliSchemaArray);
        cliSchema.put("MATCH_COUNT", this.getMatchCount());
        if (this._exception != null) {
            cliSchema.put(CliSchema.EXCEPTION, this._exception);
        }
        return cliSchema;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [children=" + Arrays.toString(this._children) + "]";
    }

    @Override
    public String toSyntax(CliContext cliContext) {
        Object object = this.toSynopsis(cliContext);
        if (((String)object).length() > 0 && this._children != null && this._children.length > 1) {
            object = cliContext.getSyntaxMetrics().getBeginListSymbol() + " " + (String)object + " " + cliContext.getSyntaxMetrics().getEndListSymbol();
        }
        return object;
    }

    @Override
    public <V> V toValue(String string) {
        for (Term term : this._children) {
            Object v = term.toValue(string);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public Term[] getChildren() {
        return this._children;
    }

    @Override
    public boolean isVisible() {
        if (super.isVisible()) {
            for (Term term : this._children) {
                if (!term.isVisible()) continue;
                return true;
            }
        }
        return false;
    }
}

