/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public enum ArgsFilter {
    D(Pattern.compile("^-D[\\S\\s]*")),
    D_XX(Pattern.compile("(^-D[\\S\\s]*)|(^-XX:[\\S\\s]*)")),
    NONE(null),
    XX(Pattern.compile("^-XX:[\\S\\s]*"));

    private Pattern _pattern;

    private ArgsFilter(Pattern pattern) {
        this._pattern = pattern;
    }

    public List<String> fromFilter(List<String> list) {
        return ArgsFilter.fromFilter(list, this._pattern);
    }

    public String[] fromFilter(String[] stringArray) {
        return ArgsFilter.fromFilter(stringArray, this._pattern);
    }

    public Pattern getFilter() {
        return this._pattern;
    }

    public List<String> toFiltered(List<String> list) {
        return ArgsFilter.toFiltered(list, this._pattern);
    }

    public String[] toFiltered(String[] stringArray) {
        return ArgsFilter.toFiltered(stringArray, this._pattern);
    }

    public static List<String> fromFilter(List<String> list, Pattern pattern) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (pattern == null) {
            return arrayList;
        }
        for (String string : list) {
            if (!pattern.matcher(string).matches()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String[] fromFilter(String[] stringArray, Pattern pattern) {
        if (pattern == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (!pattern.matcher(string).matches()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static ArgsFilter toArgsFilter(String string) {
        string = string != null ? string.replaceAll("-", "").replaceAll("_", "") : string;
        for (ArgsFilter argsFilter : ArgsFilter.values()) {
            if (!argsFilter.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(string)) continue;
            return argsFilter;
        }
        return null;
    }

    public static List<String> toFiltered(List<String> list, Pattern pattern) {
        if (pattern == null) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (pattern.matcher(string).matches()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String[] toFiltered(String[] stringArray, Pattern pattern) {
        if (pattern == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (pattern.matcher(string).matches()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

