/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.schema.Schema;

public class ArrayOperand<T>
extends AbstractTerm
implements Operand<T[]> {
    private static final String MAX_LENGTH = "MAX_LENGTH";
    private static final String MIN_LENGTH = "MIN_LENGTH";
    private int _maxLength;
    private int _minLength;
    private Operand<T> _operand;
    private Class<T[]> _type;
    private T[] _values = null;

    public ArrayOperand(Operand<T> operand) {
        this(operand, -1, -1);
    }

    public ArrayOperand(Operand<T> operand, int n) {
        this(operand, n, n);
    }

    public ArrayOperand(Operand<T> operand, int n, int n2) {
        if (n2 == 0 || n != -1 && n2 != -1 && n > n2 || n2 < -1 || n2 < -1) {
            throw new IllegalArgumentException("The minimum length <" + n + "> must be less or equal than the maximum length <" + n2 + ">, both values must be greater (minimum and maximum) or equal (minimum) than <0> (or <-1> when to be ignored)!");
        }
        this._operand = operand;
        this._minLength = n;
        this._maxLength = n2;
        this._type = Array.newInstance(operand.getType(), 0).getClass();
    }

    @Override
    public int getMatchCount() {
        return this._values != null ? this._values.length : 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(Operand<?> operand) {
        return this._operand.compareTo(operand);
    }

    @Override
    public String getAlias() {
        return this._operand.getAlias();
    }

    @Override
    public String getDescription() {
        return this._operand.getDescription();
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public Class<T[]> getType() {
        return this._type;
    }

    @Override
    public T[] getValue() {
        return this._values;
    }

    @Override
    public Operand<?>[] parseArgs(String[] stringArray, String[] stringArray2, CliContext cliContext) throws ArgsSyntaxException {
        int n;
        ArrayList<Operand> arrayList;
        ArrayList<T> arrayList2;
        block7: {
            arrayList2 = new ArrayList<T>();
            arrayList = new ArrayList<Operand>();
            try {
                for (n = 0; this._maxLength == -1 || n < this._maxLength; ++n) {
                    Operand<?>[] operandArray;
                    for (Operand<?> operand : operandArray = this._operand.parseArgs(stringArray, stringArray2, cliContext)) {
                        Object object;
                        try {
                            object = operand.clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            this._exception = new ParseArgsException("The type <" + this._operand.getType().getSimpleName() + "> does not support cloning!", stringArray, (Term)this, cloneNotSupportedException);
                            throw this._exception;
                        }
                        arrayList.add((Operand)object);
                    }
                    arrayList2.add(this._operand.getValue());
                    stringArray = AbstractTerm.toArgsDiff(stringArray, operandArray);
                }
            }
            catch (AmbiguousArgsException | ParseArgsException | UnknownArgsException argsSyntaxException) {
                if (this._maxLength == -1 || n <= this._maxLength) break block7;
                this._exception = argsSyntaxException;
                throw this._exception;
            }
        }
        if (arrayList2.size() == 0 || this._minLength != -1 && n < this._minLength) {
            this._exception = new UnknownArgsException("Not one argument matched (as of \"" + this.toUsage(cliContext) + "\")", stringArray, this);
            throw this._exception;
        }
        this._values = arrayList2.toArray((Object[])Array.newInstance(this._operand.getType(), arrayList2.size()));
        return arrayList.toArray(new Operand[arrayList.size()]);
    }

    @Override
    public void reset() {
        super.reset();
        this._operand.reset();
        this._values = null;
    }

    @Override
    public String[] getParsedArgs() {
        return this._operand.getParsedArgs();
    }

    @Override
    public CliSchema toSchema() {
        CliSchema cliSchema = new CliSchema(this._operand.getDescription(), this.getClass(), this.getValue(), this._operand.getAlias(), new Schema[0]);
        cliSchema.put(MAX_LENGTH, this._maxLength);
        cliSchema.put(MIN_LENGTH, this._minLength);
        if (this._exception != null) {
            cliSchema.put(CliSchema.EXCEPTION, this._exception);
        }
        return cliSchema;
    }

    @Override
    public String toSyntax(CliContext cliContext) {
        return cliContext.toArgumentSpec(this, this._minLength, this._maxLength);
    }

    public ArrayOperand<T> withVisible(boolean bl) {
        this.setVisible(bl);
        return this;
    }

    protected Operand<T> getOperand() {
        return this._operand;
    }
}

