/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Flag;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.exception.MessageDetails;
import org.refcodes.runtime.SystemProperty;

public class StackOverflowTest {
    @Test
    public void testParserStackOverflow1() throws ArgsSyntaxException {
        StringOption r = new StringOption(Character.valueOf('r'), null, "opt1", "Your description for option r with argument opt1");
        StringOption s = new StringOption(Character.valueOf('S'), null, "opt2", "Your description for option S with argument opt2");
        StringOperand arg1 = new StringOperand("arg1", "Your description for arg1");
        StringOperand arg2 = new StringOperand("arg2", "Your description for arg2");
        StringOperand arg3 = new StringOperand("arg3", "Your description for arg3");
        StringOperand arg4 = new StringOperand("arg4", "Your description for arg4");
        Flag test = new Flag("test", null, "Your description for test");
        StringOption a = new StringOption(Character.valueOf('A'), null, "opt3", "Your description for option A with argument opt3");
        AndCondition theRoot = new AndCondition(new Term[]{r, s, a, arg1, arg2, arg3, arg4, test});
        ArgsParser theParseArgs = new ArgsParser((Term)theRoot);
        theParseArgs.withName("MyProgramm");
        theParseArgs.withSyntaxMetrics(SyntaxNotation.GNU_POSIX);
        theParseArgs.printSynopsis();
        theParseArgs.printSeparatorLn();
        theParseArgs.printOptions();
        theParseArgs.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "--test", "-A", "AAAAA"});
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("r    :=" + (String)r.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("S    :=" + (String)s.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("arg1 :=" + (String)arg1.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("arg2 :=" + (String)arg2.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("arg3 :=" + (String)arg3.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("arg4 :=" + (String)arg4.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("test :=" + String.valueOf(test.getValue()));
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("A    :=" + (String)a.getValue());
        }
        Assertions.assertEquals((Object)r.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)s.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)arg1.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)arg2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)arg3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)arg4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)test.getValue(), (Object)true);
        Assertions.assertEquals((Object)a.getValue(), (Object)"AAAAA");
    }

    @Test
    public void testParserStackOverflow2() throws ArgsSyntaxException {
        StringOption r = new StringOption(Character.valueOf('r'), null, "opt1", "Your description for option r with argument opt1");
        StringOption s = new StringOption(Character.valueOf('S'), null, "opt2", "Your description for option S with argument opt2");
        StringOperand arg1 = new StringOperand("arg1", "Your description for arg1");
        StringOperand arg2 = new StringOperand("arg2", "Your description for arg2");
        StringOperand arg3 = new StringOperand("arg3", "Your description for arg3");
        StringOperand arg4 = new StringOperand("arg4", "Your description for arg4");
        Flag test = new Flag(null, "test", null, "Your description for test");
        StringOption a = new StringOption(Character.valueOf('A'), null, "opt3", "Your description for option A with argument opt3");
        AndCondition theRoot = new AndCondition(new Term[]{r, s, a, arg1, arg2, arg3, arg4, new AnyCondition(new Term[]{test})});
        ArgsParser theParseArgs = new ArgsParser((Term)theRoot);
        theParseArgs.withName("MyProgramm");
        theParseArgs.withSyntaxMetrics(SyntaxNotation.GNU_POSIX);
        theParseArgs.printSynopsis();
        theParseArgs.printSeparatorLn();
        theParseArgs.printOptions();
        theParseArgs.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "-A", "AAAAA"});
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("r    :=" + (String)r.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("S    :=" + (String)s.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("arg1 :=" + (String)arg1.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("arg2 :=" + (String)arg2.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("arg3 :=" + (String)arg3.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("arg4 :=" + (String)arg4.getValue());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("test :=" + String.valueOf(test.getValue()));
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("A    :=" + (String)a.getValue());
        }
        Assertions.assertEquals((Object)r.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)s.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)arg1.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)arg2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)arg3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)arg4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)test.getValue(), (Object)false);
        Assertions.assertEquals((Object)a.getValue(), (Object)"AAAAA");
    }

    @Test
    public void testParserStackOverflow3() throws ArgsSyntaxException {
        CasesCondition syntax = CliSugar.cases((Term[])new Term[]{CliSugar.none((String)"none"), CliSugar.optional((Term[])new Term[]{CliSugar.helpFlag()}), CliSugar.stringOperand((String)"operand", (String)"description")});
        ArgsParser parser = new ArgsParser().withArgsSyntax((Term)syntax);
        try {
            parser.evalArgs(new String[0]);
            Assertions.fail((String)("Expecting a <" + AmbiguousArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            String eMessage = e.toMessage();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("toMessage(): " + eMessage);
            }
            eMessage = e.toHeuristicMessage();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("toHeuristicMessage(): " + eMessage);
            }
            for (MessageDetails eDetails : MessageDetails.values()) {
                eMessage = e.toMessage(eDetails);
                if (!SystemProperty.LOG_TESTS.isEnabled()) continue;
                System.out.println("toMessage(" + String.valueOf(eDetails) + "): " + eMessage);
            }
        }
    }
}

