// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import java.util.Collection;

import org.refcodes.schema.Schema;

/**
 * The purpose of a {@link CliSchema} is automatically generate documentation of
 * {@link Term} structures.
 */
public class CliSchema extends Schema {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	public static final String MATCH_COUNT = "MATCH_COUNT";
	public static final String HAS_VALUE_KEY = "HAS_VALUE";

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	private CliSchema( Builder aBuilder ) {
		super( aBuilder );
	}

	/**
	 * Constructs a {@link CliSchema} with the provided arguments.
	 *
	 * @param aIdentifier The identifier being the label for the {@link Schema},
	 *        when null the <code>alias</code>, the <code>key</code> or the
	 *        <code>type</code>'s simple name prefixed with the <code>@</code>
	 *        character alongside the <code>hash</code> (or this instance's
	 *        identity has code when null).
	 * @param aAlias The alias (name) describing this {@link Schema}, when
	 *        <code>null</code>, then the alias is extrapolated from the
	 *        identifier's portion till the last <code>@</code> character (if
	 *        any).
	 * @param aKey The key (of a value) provided with this {@link Schema}
	 * @param aType The type described by this {@link Schema}.
	 * @param aHash The hash if the instance described by this {@link Schema}.
	 * @param aStereotype The stereotype related with this {@link Schema}.
	 * @param aValue The value representing this {@link Schema}.
	 * @param aException The {@link Throwable} related with this {@link Schema}.
	 * @param aDescription The description for this {@link Schema}.
	 * @param aSchema The {@link Schema} from which to copy from (in case of not
	 *        being explicitly set by the arguments).
	 * @param aChildren The {@link Schema}'s children (aggregation structure).
	 */
	public CliSchema( String aIdentifier, String aAlias, String aKey, Class<?> aType, Integer aHash, String aStereotype, Object aValue, Throwable aException, String aDescription, Schema aSchema, Schema[] aChildren ) {
		super( aIdentifier, aAlias, aKey, aType, aHash, aStereotype, aValue, aException, aDescription, aSchema, aChildren );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Creates builder to build {@link CliSchema}.
	 * 
	 * @return created builder
	 */
	public static Builder builder() {
		return new Builder();
	}

	// /////////////////////////////////////////////////////////////////////////
	// BUILDER:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@link Builder} to build {@link CliSchema}.
	 */
	@SuppressWarnings("rawtypes")
	public static final class Builder extends org.refcodes.schema.Schema.Builder {

		private Builder() {}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withIdentifier( String aIdentifier ) {
			return (Builder) super.withIdentifier( aIdentifier );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withAlias( String aAlias ) {
			return (Builder) super.withAlias( aAlias );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withKey( String aKey ) {
			return (Builder) super.withKey( aKey );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withType( Class aType ) {
			return (Builder) super.withType( aType );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withHash( int aHash ) {
			return (Builder) super.withHash( aHash );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withInstance( Object aInstance ) {
			return (Builder) super.withInstance( aInstance );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withStereotype( String aStereotype ) {
			return (Builder) super.withStereotype( aStereotype );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withValue( Object aValue ) {
			return (Builder) super.withValue( aValue );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withException( Throwable aException ) {
			return (Builder) super.withException( aException );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withDescription( String aDescription ) {
			return (Builder) super.withDescription( aDescription );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withSchema( Schema aSchema ) {
			return (Builder) super.withSchema( aSchema );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withChildren( Schema... aChildren ) {
			return (Builder) super.withChildren( aChildren );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withChildren( Collection<? extends Schema> aChildren ) {
			return (Builder) super.withChildren( aChildren );
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Builder withProperty( String aKey, Object aValue ) {
			return (Builder) super.withProperty( aKey, aValue );
		}

		/**
		 * Builder method of the builder.
		 * 
		 * @return The built instance.
		 */
		public CliSchema build() {
			return new CliSchema( this );
		}
	}
}