/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Term;

public abstract class AbstractCondition
extends AbstractTerm
implements Condition {
    protected Term[] _children;

    public AbstractCondition(String aDescription, Term ... aElements) {
        super(aDescription);
        this._children = aElements;
    }

    @Override
    public int getMatchCount() {
        int theMatchCount = 0;
        Term[] termArray = this._children;
        int n = this._children.length;
        int n2 = 0;
        while (n2 < n) {
            Term eTerm = termArray[n2];
            theMatchCount += eTerm.getMatchCount();
            ++n2;
        }
        return theMatchCount;
    }

    @Override
    public void reset() {
        super.reset();
        Term[] termArray = this._children;
        int n = this._children.length;
        int n2 = 0;
        while (n2 < n) {
            Term eTerm = termArray[n2];
            eTerm.reset();
            ++n2;
        }
    }

    @Override
    public <T extends Operand<?>> T toOperand(String aAlias, Class<T> aType) {
        Term[] termArray = this._children;
        int n = this._children.length;
        int n2 = 0;
        while (n2 < n) {
            Condition eCondition;
            Operand eOperand;
            Term eSyntaxable = termArray[n2];
            if (eSyntaxable instanceof Operand) {
                eOperand = (Operand)eSyntaxable;
                boolean eTypeMatch = true;
                boolean eAliasMatch = true;
                if (aAlias != null && aAlias.length() != 0) {
                    eAliasMatch = aAlias.equals(eOperand.getAlias());
                }
                if (aType != null) {
                    eTypeMatch = aType.isAssignableFrom(eOperand.getClass());
                }
                if (eTypeMatch && eAliasMatch) {
                    return (T)eOperand;
                }
            } else if (eSyntaxable instanceof Condition && (eOperand = (eCondition = (Condition)eSyntaxable).toOperand(aAlias, aType)) != null) {
                return (T)eOperand;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Operand<?>[] toOperands() {
        ArrayList theResult = new ArrayList();
        Term[] termArray = this._children;
        int n = this._children.length;
        int n2 = 0;
        while (n2 < n) {
            Operand<?>[] theOperands;
            Term eSyntaxable = termArray[n2];
            if (eSyntaxable instanceof Operand) {
                theResult.add((Operand)eSyntaxable);
            }
            if (eSyntaxable instanceof Condition && (theOperands = ((Condition)eSyntaxable).toOperands()) != null && theOperands.length != 0) {
                Operand<?>[] operandArray = theOperands;
                int n3 = theOperands.length;
                int n4 = 0;
                while (n4 < n3) {
                    Operand<?> eOperand = operandArray[n4];
                    theResult.add(eOperand);
                    ++n4;
                }
            }
            ++n2;
        }
        return theResult.toArray(new Operand[theResult.size()]);
    }

    @Override
    public CliSchema toSchema() {
        CliSchema[] theSchemas = null;
        if (this._children != null && this._children.length != 0) {
            theSchemas = new CliSchema[this._children.length];
            int i = 0;
            while (i < theSchemas.length) {
                theSchemas[i] = this._children[i].toSchema();
                ++i;
            }
        }
        CliSchema theSchema = CliSchema.builder().withInstance(this).withDescription(this._description).withChildren(theSchemas).build();
        theSchema.put("MATCH_COUNT", this.getMatchCount());
        if (this._exception != null) {
            theSchema.put("EXCEPTION", this._exception);
        }
        return theSchema;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [children=" + Arrays.toString(this._children) + "]";
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        Object theSyntax = this.toSynopsis(aCliCtx);
        if (((String)theSyntax).length() > 0 && this._children != null && this._children.length > 1) {
            theSyntax = aCliCtx.getSyntaxMetrics().getBeginListSymbol() + " " + (String)theSyntax + " " + aCliCtx.getSyntaxMetrics().getEndListSymbol();
        }
        return theSyntax;
    }

    @Override
    public <V> V toValue(String aAlias) {
        Term[] termArray = this._children;
        int n = this._children.length;
        int n2 = 0;
        while (n2 < n) {
            Term eElement = termArray[n2];
            Object eValue = eElement.toValue(aAlias);
            if (eValue != null) {
                return eValue;
            }
            ++n2;
        }
        return null;
    }

    public Term[] getChildren() {
        return this._children;
    }

    @Override
    public boolean isVisible() {
        if (super.isVisible()) {
            Term[] termArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                Term eChild = termArray[n2];
                if (eChild.isVisible()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

