/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.refcodes.cli.ArgumentEscapeCodeAccessor;
import org.refcodes.cli.ArrayOperand;
import org.refcodes.cli.CliMetrics;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Directive;
import org.refcodes.cli.Flag;
import org.refcodes.cli.KeywordEscapeCodeAccessor;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Operation;
import org.refcodes.cli.Option;
import org.refcodes.cli.Optionable;
import org.refcodes.cli.Property;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxMetricsAccessor;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.runtime.Terminal;

public class CliContext
implements CliMetrics,
Optionable {
    private boolean _isEscapeCodesEnabled = Terminal.isAnsiTerminalEnabled();
    private String _keywordEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _argumentEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC});
    private String _resetEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private SyntaxMetrics _syntaxMetrics = SyntaxNotation.LOGICAL;

    public CliContext() {
    }

    public CliContext(boolean isEscapeCodesEnabled) {
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
    }

    public CliContext(CliMetrics aCliMetrics) {
        this._syntaxMetrics = aCliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = aCliMetrics.isEscapeCodesEnabled();
        this._argumentEscapeCode = aCliMetrics.getArgumentEscapeCode();
        this._keywordEscapeCode = aCliMetrics.getKeywordEscapeCode();
        this._resetEscapeCode = aCliMetrics.getResetEscapeCode();
    }

    public CliContext(CliMetrics aCliMetrics, SyntaxMetrics aSyntaxMetrics) {
        this._syntaxMetrics = aSyntaxMetrics != null ? aSyntaxMetrics : aCliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = aCliMetrics.isEscapeCodesEnabled();
        this._argumentEscapeCode = aCliMetrics.getArgumentEscapeCode();
        this._keywordEscapeCode = aCliMetrics.getKeywordEscapeCode();
        this._resetEscapeCode = aCliMetrics.getResetEscapeCode();
    }

    public CliContext(CliMetrics aCliMetrics, SyntaxMetrics aSyntaxMetrics, boolean isEscapeCodesEnabled) {
        this._syntaxMetrics = aSyntaxMetrics != null ? aSyntaxMetrics : aCliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
        this._argumentEscapeCode = aCliMetrics.getArgumentEscapeCode();
        this._keywordEscapeCode = aCliMetrics.getKeywordEscapeCode();
        this._resetEscapeCode = aCliMetrics.getResetEscapeCode();
    }

    public CliContext(String aArgumentEscapeCode, String aKeywordEscapeCode, String aResetEscapeCode) {
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._keywordEscapeCode = aKeywordEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics) {
        this._syntaxMetrics = aSyntaxMetrics;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, boolean isEscapeCodesEnabled) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, Character aShortOptionPrefix, String aLongOptionPrefix, boolean isEscapeCodesEnabled, String aArgumentEscapeCode, String aKeywordEscapeCode, String aResetEscapeCode) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._keywordEscapeCode = aKeywordEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, String aArgumentEscapeCode, String aKeywordEscapeCode, String aResetEscapeCode) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._keywordEscapeCode = aKeywordEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    private CliContext(Builder builder) {
        this._syntaxMetrics = builder.syntaxMetrics;
        this._argumentEscapeCode = builder.argumentEscapeCode;
        this._keywordEscapeCode = builder.keywordEscapeCode;
        this._resetEscapeCode = builder.resetEscapeCode;
        this._isEscapeCodesEnabled = builder.isEscapeCodesEnabled;
    }

    @Override
    public String getArgumentEscapeCode() {
        return this._argumentEscapeCode;
    }

    @Override
    public String getKeywordEscapeCode() {
        return this._keywordEscapeCode;
    }

    public String getResetEscapeCode() {
        return this._resetEscapeCode;
    }

    @Override
    public SyntaxMetrics getSyntaxMetrics() {
        return this._syntaxMetrics;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscapeCodesEnabled;
    }

    public boolean isOption(String aArg) {
        if (aArg != null && aArg.length() != 0) {
            if (this._syntaxMetrics.getLongOptionPrefix() != null && aArg.startsWith(this._syntaxMetrics.getLongOptionPrefix())) {
                return true;
            }
            if (this._syntaxMetrics.getShortOptionPrefix() != null && this._syntaxMetrics.getShortOptionPrefix().equals(Character.valueOf(aArg.charAt(0)))) {
                return true;
            }
        }
        return false;
    }

    public String[] toKeywords(Term aTerm) {
        HashSet<String> theOptions = new HashSet<String>();
        if (aTerm instanceof Condition) {
            Condition theCondition = (Condition)aTerm;
            Operand<?>[] operandArray = theCondition.toOperands();
            int n = operandArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operand<?> eOperand = operandArray[n2];
                String[] eOptions = this.toKeywords(eOperand);
                if (eOptions != null && eOptions.length != 0) {
                    theOptions.addAll(Arrays.asList(eOptions));
                }
                ++n2;
            }
        }
        if (aTerm instanceof Option) {
            Option theOption = (Option)aTerm;
            String theShortOption = this.toShortOption(theOption);
            String theLongOption = this.toLongOption(theOption);
            if (theShortOption != null) {
                theOptions.add(theShortOption);
            }
            if (theLongOption != null) {
                theOptions.add(theLongOption);
            }
        }
        return theOptions.toArray(new String[theOptions.size()]);
    }

    public String toArgumentEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._argumentEscapeCode != null ? this._argumentEscapeCode : "") : "";
    }

    public String toArgumentSpec(Operand<?> aOperand) {
        if (aOperand instanceof ArrayOperand) {
            ArrayOperand theArrayOperand = (ArrayOperand)aOperand;
            return this.toArgumentSpec(aOperand, theArrayOperand.getMinLength(), theArrayOperand.getMaxLength());
        }
        return this.toArgumentSpec(aOperand, -1, -1);
    }

    public String toArgumentSpec(Operand<?> aOperand, int aMin, int aMax) {
        if (aOperand.getAlias() == null) {
            return "";
        }
        StringBuilder theBuilder = new StringBuilder();
        if (!(aOperand instanceof Flag) && !(aOperand instanceof Operation) && aOperand.getAlias() != null) {
            if (aOperand instanceof Option || aOperand instanceof Directive) {
                theBuilder.append(this.getSyntaxMetrics().getArgumentPrefix());
            }
            theBuilder.append((String)(aOperand instanceof NoneOperand ? aOperand.toSyntax(this) : this.toArgumentEscapeCode() + aOperand.getAlias()) + this.toResetEscapeCode());
            if (aOperand.getType().isArray()) {
                theBuilder.append(this._syntaxMetrics.getBeginArraySymbol());
            } else if (aMin != -1 || aMax != -1) {
                theBuilder.append(this._syntaxMetrics.getBeginRangeSymbol());
            }
            if (aMin != -1 && aMin == aMax) {
                theBuilder.append(aMin);
            } else {
                if (aMin != -1) {
                    theBuilder.append(aMin);
                }
                if (aOperand.getType().isArray() || aMin != -1 || aMax != -1) {
                    theBuilder.append(this._syntaxMetrics.getIntervalSymbol());
                }
                if (aMax != -1) {
                    theBuilder.append(aMax);
                }
            }
            if (aOperand.getType().isArray()) {
                theBuilder.append(this._syntaxMetrics.getEndArraySymbol());
            } else if (aMin != -1 || aMax != -1) {
                theBuilder.append(this._syntaxMetrics.getEndRangeSymbol());
            }
            if (aOperand instanceof Option || aOperand instanceof Directive) {
                theBuilder.append(this._syntaxMetrics.getArgumentSuffix());
            }
        }
        return theBuilder.toString();
    }

    public String[] toExpandOptions(String[] aArgs) {
        ArrayList<Object> theArgs = new ArrayList<Object>();
        if (this.getSyntaxMetrics().getShortOptionPrefix() != null) {
            String[] stringArray = aArgs;
            int n = aArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String eArg = stringArray[n2];
                if (eArg.length() > 2 && eArg.charAt(2) != '=' && (this.getSyntaxMetrics().getLongOptionPrefix() == null || this.getSyntaxMetrics().getLongOptionPrefix().isEmpty() || !eArg.startsWith(this.getSyntaxMetrics().getLongOptionPrefix())) && eArg.charAt(0) == this.getSyntaxMetrics().getShortOptionPrefix().charValue()) {
                    int i = 1;
                    while (i < eArg.length()) {
                        theArgs.add(this.getSyntaxMetrics().getShortOptionPrefix().toString() + eArg.charAt(i));
                        ++i;
                    }
                } else {
                    theArgs.add(eArg);
                }
                ++n2;
            }
        }
        return theArgs.toArray(new String[theArgs.size()]);
    }

    public String toLongOption(Option<?> aOption) {
        return aOption != null && aOption.getLongOption() != null ? this._syntaxMetrics.getLongOptionPrefix() + aOption.getLongOption() : null;
    }

    public String toOptionUsage(Option<?> aOption) {
        String theOption = this.toShortOption(aOption);
        return theOption != null ? theOption : this.toLongOption(aOption);
    }

    public String toOptionSpec(Option<?> aOption) {
        String theShortOption = this.toShortOption(aOption);
        String theLongOption = this.toLongOption(aOption);
        if (theShortOption != null && theLongOption != null) {
            return theShortOption + " " + theLongOption;
        }
        return theShortOption != null ? theShortOption : theLongOption;
    }

    public String toKeywordEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._keywordEscapeCode != null ? this._keywordEscapeCode : "") : "";
    }

    @Override
    public String[] toOptions(Option<?> aOption) {
        return CliContext.toOptions(aOption, this._syntaxMetrics.getShortOptionPrefix(), this._syntaxMetrics.getLongOptionPrefix());
    }

    public String toResetEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._resetEscapeCode != null ? this._resetEscapeCode : "") : "";
    }

    public String toShortOption(Option<?> aOption) {
        return aOption != null && aOption.getShortOption() != null ? this._syntaxMetrics.getShortOptionPrefix().toString() + String.valueOf(aOption.getShortOption()) : null;
    }

    public String toSpec(Operand<?> aOperand) {
        return this.toNotation(aOperand, UsageMode.SPEC);
    }

    public String toUsage(Operand<?> aOperand) {
        return this.toNotation(aOperand, UsageMode.USAGE);
    }

    public static Builder builder() {
        return new Builder();
    }

    static String[] toOptions(Option<?> aOption, Character aShortOptionPrefix, String aLongOptionPrefix) {
        String theLongOption;
        String theShortOption;
        int i = 0;
        String string = aOption != null && aOption.getShortOption() != null ? (aShortOptionPrefix != null ? aShortOptionPrefix.toString() : "") + String.valueOf(aOption.getShortOption()) : (theShortOption = null);
        String string2 = aOption != null && aOption.getLongOption() != null ? (aLongOptionPrefix != null ? aLongOptionPrefix : "") + aOption.getLongOption() : (theLongOption = null);
        if (theShortOption != null) {
            ++i;
        }
        if (theLongOption != null) {
            ++i;
        }
        String[] theResult = new String[i];
        i = 0;
        if (theShortOption != null) {
            theResult[i] = theShortOption;
            ++i;
        }
        if (theLongOption != null) {
            theResult[i] = theLongOption;
        }
        return theResult;
    }

    private String toNotation(Operand<?> aOperand, UsageMode aUsageMode) {
        StringBuilder theBuilder = new StringBuilder();
        if (aOperand instanceof Option) {
            Option theOption = (Option)aOperand;
            String theUsage = switch (aUsageMode) {
                case UsageMode.SPEC -> this.toOptionSpec(theOption);
                case UsageMode.USAGE -> this.toOptionUsage(theOption);
                default -> throw new MatchException(null, null);
            };
            theBuilder.append(this.toKeywordEscapeCode() + theUsage + this.toResetEscapeCode());
        } else if (aOperand instanceof Directive) {
            Directive theDirective = (Directive)aOperand;
            theBuilder.append(this.toKeywordEscapeCode() + theDirective.getOperation() + this.toResetEscapeCode());
        } else if (aOperand instanceof Operation) {
            Operation theOperation = (Operation)aOperand;
            theBuilder.append(this.toKeywordEscapeCode() + theOperation.getOperation() + this.toResetEscapeCode());
        }
        String theArgumentSpec = this.toArgumentSpec(aOperand);
        if (theArgumentSpec != null && theArgumentSpec.length() != 0 && theBuilder.length() > 0) {
            if (aOperand instanceof Property) {
                theBuilder.append('=');
            } else {
                theBuilder.append(' ');
            }
        }
        theBuilder.append(theArgumentSpec);
        return theBuilder.toString();
    }

    public static final class Builder
    implements SyntaxMetricsAccessor.SyntaxMetricsBuilder<Builder>,
    ArgumentEscapeCodeAccessor.ArgumentEscapeCodeBuilder<Builder>,
    KeywordEscapeCodeAccessor.KeywordEscapeCodeBuilder<Builder>,
    ResetEscapeCodeAccessor.ResetEscapeCodeBuilder<Builder>,
    EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<Builder> {
        private String argumentEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC});
        private boolean isEscapeCodesEnabled = Terminal.isAnsiTerminalEnabled();
        private String keywordEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
        private String resetEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
        private SyntaxMetrics syntaxMetrics = SyntaxNotation.LOGICAL;

        private Builder() {
        }

        public CliContext build() {
            return new CliContext(this);
        }

        @Override
        public Builder withArgumentEscapeCode(String aArgumentEscapeCode) {
            this.argumentEscapeCode = aArgumentEscapeCode;
            return this;
        }

        public Builder withEscapeCodesEnabled(boolean isEscapeCodesEnabled) {
            this.isEscapeCodesEnabled = isEscapeCodesEnabled;
            return this;
        }

        @Override
        public Builder withKeywordEscapeCode(String aKeywordEscapeCode) {
            this.keywordEscapeCode = aKeywordEscapeCode;
            return this;
        }

        public Builder withResetEscapeCode(String aResetEscapeCode) {
            this.resetEscapeCode = aResetEscapeCode;
            return this;
        }

        @Override
        public Builder withSyntaxMetrics(SyntaxMetrics aSyntaxMetrics) {
            this.syntaxMetrics = aSyntaxMetrics;
            return this;
        }
    }

    private static enum UsageMode {
        USAGE,
        SPEC;

    }
}

