/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.refcodes.cli.ArgsFilter;
import org.refcodes.cli.ArgsParserBuilder;
import org.refcodes.cli.ArgsProcessorBuilder;
import org.refcodes.cli.ArgsSyntaxAccessor;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.ArgumentEscapeCodeAccessor;
import org.refcodes.cli.BannerBorderEscapeCodeAccessor;
import org.refcodes.cli.BannerEscapeCodeAccessor;
import org.refcodes.cli.BannerFontAccessor;
import org.refcodes.cli.BannerFontPaletteAccessor;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliMetrics;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.CommandEscapeCodeAccessor;
import org.refcodes.cli.CopyrightAccessor;
import org.refcodes.cli.DescriptionEscapeCodeAccessor;
import org.refcodes.cli.Example;
import org.refcodes.cli.ExamplesAccessor;
import org.refcodes.cli.KeywordEscapeCodeAccessor;
import org.refcodes.cli.LicenseAccessor;
import org.refcodes.cli.LineSeparatorEscapeCodeAccessor;
import org.refcodes.cli.LongOptionPrefixAccessor;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.Optionable;
import org.refcodes.cli.ShortOptionPrefixAccessor;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxMetricsAccessor;
import org.refcodes.cli.Term;
import org.refcodes.mixin.ConsoleWidthAccessor;
import org.refcodes.mixin.DescriptionAccessor;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.LineBreakAccessor;
import org.refcodes.mixin.MaxConsoleWidthAccessor;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.mixin.Resetable;
import org.refcodes.mixin.TitleAccessor;
import org.refcodes.schema.Schemable;
import org.refcodes.textual.Font;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxGridAccessor;
import org.refcodes.textual.TextBoxStyle;

public interface ParseArgs
extends Schemable,
Optionable,
CliMetrics,
LineBreakAccessor.LineBreakProperty,
LineSeparatorEscapeCodeAccessor.LineSeparatorEscapeCodeProperty,
DescriptionEscapeCodeAccessor.DescriptionEscapeCodeProperty,
LicenseAccessor.LicenseProperty,
CopyrightAccessor.CopyrightProperty,
ConsoleWidthAccessor.ConsoleWidthProperty,
MaxConsoleWidthAccessor.MaxConsoleWidthProperty,
BannerFontPaletteAccessor.BannerFontPaletteProperty,
BannerFontAccessor.BannerFontProperty,
CommandEscapeCodeAccessor.CommandEscapeCodeProperty,
BannerEscapeCodeAccessor.BannerEscapeCodeProperty,
BannerBorderEscapeCodeAccessor.BannerBorderEscapeCodeProperty,
ExamplesAccessor.ExamplesProperty,
TitleAccessor.TitleProperty,
NameAccessor.NameProperty,
DescriptionAccessor.DescriptionProperty,
EscapeCodesStatusAccessor.EscapeCodeStatusProperty,
ResetEscapeCodeAccessor.ResetEscapeCodeProperty,
KeywordEscapeCodeAccessor.KeywordEscapeCodeProperty,
ArgumentEscapeCodeAccessor.ArgumentEscapeCodeProperty,
SyntaxMetricsAccessor.SyntaxMetricsProperty,
ShortOptionPrefixAccessor.ShortOptionPrefixProperty,
LongOptionPrefixAccessor.LongOptionPrefixProperty,
TextBoxGridAccessor.TextBoxGridProperty,
ArgsSyntaxAccessor.ArgsSyntaxProperty,
ArgsProcessorBuilder<ParseArgs>,
ArgsParserBuilder<ParseArgs>,
Resetable {
    public void addExample(Example var1);

    default public void addExample(String aDescription, Operand<?> ... aOperands) {
        this.addExample(new Example(aDescription, aOperands));
    }

    public void errorLn(String var1);

    default public Operand<?>[] evalArgs(List<String> aArgs) throws ArgsSyntaxException {
        return this.evalArgs(aArgs.toArray(new String[aArgs.size()]));
    }

    default public Operand<?>[] evalArgs(List<String> aArgs, ArgsFilter aArgsFilter) throws ArgsSyntaxException {
        return this.evalArgs(aArgsFilter.toFiltered(aArgs));
    }

    default public Operand<?>[] evalArgs(List<String> aArgs, Pattern aFilterExp) throws ArgsSyntaxException {
        return this.evalArgs(ArgsFilter.toFiltered(aArgs, aFilterExp));
    }

    public Operand<?>[] evalArgs(String[] var1) throws ArgsSyntaxException;

    default public Operand<?>[] evalArgs(String[] aArgs, ArgsFilter aArgsFilter) throws ArgsSyntaxException {
        return this.evalArgs(aArgsFilter.toFiltered(aArgs));
    }

    default public Operand<?>[] evalArgs(String[] aArgs, Pattern aFilterExp) throws ArgsSyntaxException {
        return this.evalArgs(ArgsFilter.toFiltered(aArgs, aFilterExp));
    }

    @Override
    public Term getArgsSyntax();

    @Override
    public String getArgumentEscapeCode();

    @Override
    public String getBannerBorderEscapeCode();

    @Override
    public String getBannerEscapeCode();

    @Override
    public String getCommandEscapeCode();

    @Override
    public String getCopyright();

    public String getDescription();

    @Override
    public String getDescriptionEscapeCode();

    @Override
    public Example[] getExamples();

    @Override
    public String getLicense();

    @Override
    public String getLineSeparatorEscapeCode();

    @Override
    public String getKeywordEscapeCode();

    public char getSeparatorLnChar();

    public void printBanner();

    default public void printBody() {
        if (this.getLicense() != null) {
            this.printLicense();
            this.printSeparatorLn();
        }
        this.printSynopsis();
        this.printSeparatorLn();
        if (this.getDescription() != null) {
            this.printDescription();
            this.printSeparatorLn();
        }
        if (this.getArgsSyntax() != null) {
            this.printOptions();
            this.printSeparatorLn();
        }
        if (this.getExamples() != null && this.getExamples().length != 0) {
            this.printExamples();
            this.printSeparatorLn();
        }
        if (this.getCopyright() != null) {
            this.printCopyright();
            this.printSeparatorLn();
        }
    }

    public void printCopyright();

    public void printDescription();

    public void printExamples();

    public void printHeader();

    default public void printHelp() {
        this.printBanner();
        this.printBody();
    }

    public void printLicense();

    public void printLn();

    public void printLn(String var1);

    public void printOptions();

    public void printSeparatorLn();

    public void printSynopsis();

    public void setErrorOut(PrintStream var1);

    @Override
    public void setLineSeparatorEscapeCode(String var1);

    public void setSeparatorLnChar(char var1);

    public void setStandardOut(PrintStream var1);

    @Override
    public void setSyntaxMetrics(SyntaxMetrics var1);

    @Override
    default public String[] toOptions(Option<?> aOption) {
        return CliContext.toOptions(aOption, this.getShortOptionPrefix(), this.getLongOptionPrefix());
    }

    default public CliSchema toSchema() {
        if (this.getArgsSyntax() != null) {
            return CliSchema.builder().withAlias(this.getName()).withInstance(this).withDescription(this.getDescription()).withChildren(this.getArgsSyntax().toSchema()).build();
        }
        return CliSchema.builder().withAlias(this.getName()).withInstance(this).withDescription(this.getDescription()).build();
    }

    @Override
    default public ParseArgs withAddExample(Example aExample) {
        this.addExample(aExample);
        return this;
    }

    @Override
    default public ParseArgs withAddExample(String aDescription, Operand<?> ... aOperands) {
        this.addExample(aDescription, aOperands);
        return this;
    }

    @Override
    default public ParseArgs withArgumentEscapeCode(String aParamEscCode) {
        this.setArgumentEscapeCode(aParamEscCode);
        return this;
    }

    @Override
    default public ParseArgs withBannerBorderEscapeCode(String aBannerBorderEscCode) {
        this.setBannerEscapeCode(aBannerBorderEscCode);
        return this;
    }

    @Override
    default public ParseArgs withBannerEscapeCode(String aBannerEscCode) {
        this.setBannerEscapeCode(aBannerEscCode);
        return this;
    }

    @Override
    default public ParseArgs withBannerFont(Font aBannerFont) {
        this.setBannerFont(aBannerFont);
        return this;
    }

    @Override
    default public ParseArgs withBannerFontPalette(char[] aColorPalette) {
        this.setBannerFontPalette(aColorPalette);
        return this;
    }

    @Override
    default public ParseArgs withCommandEscapeCode(String aCommandEscCode) {
        this.setCommandEscapeCode(aCommandEscCode);
        return this;
    }

    default public ParseArgs withConsoleWidth(int aConsoleWidth) {
        this.setConsoleWidth(aConsoleWidth);
        return this;
    }

    @Override
    default public ParseArgs withCopyright(String aCopyright) {
        this.setCopyright(aCopyright);
        return this;
    }

    default public ParseArgs withDescription(String aDescription) {
        this.setDescription(aDescription);
        return this;
    }

    @Override
    default public ParseArgs withDescriptionEscapeCode(String aDescriptionEscCode) {
        this.setDescriptionEscapeCode(aDescriptionEscCode);
        return this;
    }

    @Override
    default public ParseArgs withErrorOut(PrintStream aErrorOut) {
        this.setErrorOut(aErrorOut);
        return this;
    }

    default public ParseArgs withEscapeCodesEnabled(boolean isEscCodeEnabled) {
        this.setEscapeCodesEnabled(isEscCodeEnabled);
        return this;
    }

    @Override
    default public ParseArgs withEvalArgs(List<String> aArgs) throws ArgsSyntaxException {
        this.evalArgs(aArgs.toArray(new String[aArgs.size()]));
        return this;
    }

    @Override
    default public ParseArgs withEvalArgs(String[] aArgs) throws ArgsSyntaxException {
        this.evalArgs(aArgs);
        return this;
    }

    @Override
    default public ParseArgs withExamples(Collection<Example> aExamples) {
        for (Example eExample : aExamples) {
            this.addExample(eExample);
        }
        return this;
    }

    @Override
    default public ParseArgs withExamples(Example[] aExamples) {
        Example[] exampleArray = aExamples;
        int n = aExamples.length;
        int n2 = 0;
        while (n2 < n) {
            Example eExample = exampleArray[n2];
            this.addExample(eExample);
            ++n2;
        }
        return this;
    }

    @Override
    default public ParseArgs withLicense(String aLicense) {
        this.setLicense(aLicense);
        return this;
    }

    default public ParseArgs withLineBreak(String aLineBreak) {
        this.setLineBreak(aLineBreak);
        return this;
    }

    @Override
    default public ParseArgs withLineSeparatorEscapeCode(String aLineSeparatorEscCode) {
        this.setLineSeparatorEscapeCode(aLineSeparatorEscCode);
        return this;
    }

    @Override
    default public ParseArgs withLongOptionPrefix(String aLongOptionPrefix) {
        this.setLongOptionPrefix(aLongOptionPrefix);
        return this;
    }

    default public ParseArgs withMaxConsoleWidth(int aMaxConsoleWidth) {
        this.setMaxConsoleWidth(aMaxConsoleWidth);
        return this;
    }

    default public ParseArgs withName(String aName) {
        this.setName(aName);
        return this;
    }

    @Override
    default public ParseArgs withKeywordEscapeCode(String aOptEscCode) {
        this.setKeywordEscapeCode(aOptEscCode);
        return this;
    }

    default public ParseArgs withResetEscapeCode(String aResetEscCode) {
        this.setResetEscapeCode(aResetEscCode);
        return this;
    }

    @Override
    default public ParseArgs withSeparatorLnChar(char aSeparatorLnChar) {
        this.setSeparatorLnChar(aSeparatorLnChar);
        return this;
    }

    @Override
    default public ParseArgs withShortOptionPrefix(Character aShortOptionPrefix) {
        this.setShortOptionPrefix(aShortOptionPrefix);
        return this;
    }

    @Override
    default public ParseArgs withStandardOut(PrintStream aStandardOut) {
        this.setStandardOut(aStandardOut);
        return this;
    }

    @Override
    default public ParseArgs withSyntaxMetrics(SyntaxMetrics aSyntaxMetrics) {
        this.setSyntaxMetrics(aSyntaxMetrics);
        return this;
    }

    default public ParseArgs withTextBoxGrid(TextBoxGrid aTextBoxGrid) {
        this.setTextBoxGrid(aTextBoxGrid);
        return this;
    }

    default public ParseArgs withTextBoxGrid(TextBoxStyle aTextBoxStyle) {
        this.setTextBoxGrid(aTextBoxStyle);
        return this;
    }

    default public ParseArgs withTitle(String aTitle) {
        this.setTitle(aTitle);
        return this;
    }
}

