/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.Arrays;
import java.util.function.Consumer;
import org.refcodes.cli.AbstractTerm;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.struct.Relation;

public abstract class AbstractOperand<T>
extends AbstractTerm
implements Operand<T> {
    private String _alias;
    private String[] _args = null;
    private Class<T> _type;
    private Consumer<Operand<T>> _consumer;
    private T _value = null;
    protected int _matchCount = 0;

    public AbstractOperand(Class<T> aType, String aAlias, String aDescription) {
        this(aType, aAlias, aDescription, null);
    }

    public AbstractOperand(Class<T> aType, String aAlias, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aDescription);
        this._type = aType;
        this._alias = aAlias;
        this._consumer = aConsumer;
    }

    public AbstractOperand(Relation<String, T> aProperty, Class<T> aType) {
        this(aProperty, aType, null);
    }

    public AbstractOperand(Relation<String, T> aProperty, Class<T> aType, Consumer<? extends Operand<T>> aConsumer) {
        this._alias = (String)aProperty.getKey();
        this._value = aProperty.getValue();
        this._consumer = aConsumer;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(Operand<?> obj) {
        if (obj instanceof Option) {
            Option aOption = (Option)obj;
            AbstractOperand abstractOperand = this;
            if (abstractOperand instanceof Option) {
                Option theOption = (Option)((Object)abstractOperand);
                String otherOption = aOption.getShortOption() != null ? aOption.getShortOption().toString() : aOption.getLongOption();
                String thisOption = theOption.getShortOption() != null ? theOption.getShortOption().toString() : theOption.getLongOption();
                return thisOption.compareTo(otherOption);
            }
            if (this instanceof Operand) {
                return 1;
            }
        }
        if (obj instanceof Operand && this instanceof Option) {
            return -11;
        }
        if (this.getAlias() != null && obj.getAlias() != null) {
            return this.getAlias().compareTo(obj.getAlias());
        }
        return this.toSyntax().compareTo(obj.toSyntax());
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public T getValue() {
        return this._value;
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aKeywords, CliContext aCliCtx) throws ArgsSyntaxException {
        int first = -1;
        for (int i = aArgs.length - 1; i >= 0; --i) {
            if (aCliCtx.isOption(aArgs[i]) || first != -1 && first + -1 != i) continue;
            first = i;
        }
        if (first != -1) {
            this.setValue(this.toType(aArgs[first]));
            this.setParsedArgs(new String[]{aArgs[first]});
            this._matchCount = 1;
            return new Operand[]{this};
        }
        this._exception = new UnknownArgsException("Unable to parse any args (neither being prefixed with \"" + aCliCtx.getSyntaxMetrics().getShortOptionPrefix() + "\" nor being prefixed with \"" + aCliCtx.getSyntaxMetrics().getLongOptionPrefix() + "\")!", aArgs, this);
        throw this._exception;
    }

    @Override
    public int getMatchCount() {
        return this._matchCount;
    }

    @Override
    public void reset() {
        super.reset();
        this._matchCount = 0;
        this._args = null;
        this._value = null;
    }

    @Override
    public String[] getParsedArgs() {
        return this._args;
    }

    @Override
    public CliSchema toSchema() {
        CliSchema theSchema = CliSchema.builder().withAlias(this._alias).withInstance(this).withValue(this._value).withDescription(this._description).build();
        theSchema.put("MATCH_COUNT", this._matchCount);
        theSchema.put("HAS_VALUE", this.hasValue());
        if (this._exception != null) {
            theSchema.put("EXCEPTION", this._exception);
        }
        return theSchema;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", args=" + Arrays.toString(this._args) + ", type=" + String.valueOf(this._type) + ", value=" + String.valueOf(this._value) + ", matchCount=" + this._matchCount + "]";
    }

    protected void approve() {
        if (this._consumer != null) {
            this._consumer.accept(this);
        }
    }

    protected void setParsedArgs(String[] aArgs) {
        this._args = aArgs;
    }

    protected void setValue(T aValue) {
        this._value = aValue;
    }

    protected abstract T toType(String var1) throws ParseArgsException;
}

