/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.Term;

public class AllCondition
extends AbstractCondition {
    public AllCondition(Term aArg) {
        super("All (ALL) command line arguments passed are to be consumed by the according syntax branches.", aArg);
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aKeywords, CliContext aCliCtx) throws ArgsSyntaxException {
        Operand<?>[] theResult;
        try {
            theResult = this._children[0].parseArgs(aArgs, aKeywords, aCliCtx);
        }
        catch (ArgsSyntaxException e) {
            this._exception = e;
            throw this._exception;
        }
        String[] theRemainderArgs = AllCondition.toArgsDiff(aArgs, theResult);
        if (theRemainderArgs != null && theRemainderArgs.length != 0) {
            Object thePossibleCause = this.toPossibleCause(theRemainderArgs);
            thePossibleCause = ((String)thePossibleCause).length() > 0 ? " " + (String)thePossibleCause : thePossibleCause;
            this._exception = new SuperfluousArgsException("Failed as of " + (theRemainderArgs.length > 1 ? "(mutual) " : "") + "superfluous " + this.toString(theRemainderArgs) + (theRemainderArgs.length == 1 ? " argument" : " arguments") + ", though the arguments must be matched (ALL) without any surplus by the syntax branches!" + (String)thePossibleCause, theRemainderArgs, this);
            throw this._exception;
        }
        return theResult;
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        if (this._children != null && this._children.length > 0) {
            if (this._children.length == 1) {
                return this._children[0].toSynopsis(aCliCtx);
            }
            Object theSynopsis = "";
            for (Term eChild : this._children) {
                if (!eChild.isVisible()) continue;
                if (((String)theSynopsis).length() != 0) {
                    theSynopsis = (String)theSynopsis + " ";
                }
                theSynopsis = (String)theSynopsis + eChild.toSyntax(aCliCtx);
            }
            return theSynopsis;
        }
        return "";
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        if (this._children != null && this._children.length > 0) {
            Object theSyntax = "";
            for (Term eChild : this._children) {
                if (((String)theSyntax).length() != 0) {
                    theSyntax = (String)theSyntax + " ";
                }
                if (aCliCtx.getSyntaxMetrics().getAllSymbol() != null && aCliCtx.getSyntaxMetrics().getAllSymbol().length() != 0) {
                    theSyntax = (String)theSyntax + aCliCtx.getSyntaxMetrics().getAllSymbol() + aCliCtx.getSyntaxMetrics().getBeginListSymbol() + " ";
                }
                theSyntax = (String)theSyntax + eChild.toSyntax(aCliCtx);
                if (aCliCtx.getSyntaxMetrics().getAllSymbol() == null || aCliCtx.getSyntaxMetrics().getAllSymbol().length() == 0) continue;
                theSyntax = (String)theSyntax + " " + aCliCtx.getSyntaxMetrics().getEndListSymbol();
            }
            return theSyntax;
        }
        return "";
    }

    public AllCondition withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return this;
    }

    protected Term getChild() {
        return this._children[0];
    }

    private String toPossibleCause(String[] aRemainderArgs) {
        Object theMessage = "";
        Condition[] theParents = this.toConditions(aRemainderArgs);
        if (theParents != null && theParents.length != 0) {
            for (Condition eCondition : theParents) {
                ArgsSyntaxException eException = eCondition.getException();
                if (eException == null) continue;
                eException = eException.toRootMatchCause();
                theMessage = (String)theMessage + (((String)theMessage).length() != 0 ? " " : "") + "Possible cause: " + eException.toShortMessage();
                if (eException.getSuppressed() == null || eException.getSuppressed().length == 0) continue;
                for (Throwable eSuppressed : eException.getSuppressed()) {
                    if (!(eSuppressed instanceof ArgsSyntaxException)) continue;
                    ArgsSyntaxException eSyntaxException = (ArgsSyntaxException)((Object)eSuppressed);
                    theMessage = (String)theMessage + " " + eSyntaxException.toRootMatchCause().toShortMessage();
                }
            }
        }
        return theMessage;
    }

    private String toString(String[] aArgs) {
        StringBuilder theBuilder = new StringBuilder();
        for (int i = 0; i < aArgs.length; ++i) {
            theBuilder.append("\"" + aArgs[i] + "\"");
            if (i >= aArgs.length - 1) continue;
            theBuilder.append(", ");
        }
        return theBuilder.toString();
    }
}

