/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.function.Consumer;
import org.refcodes.cli.AbstractDirective;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.Term;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.struct.Relation;

public class BooleanDirective
extends AbstractDirective<Boolean> {
    public BooleanDirective(String aOperation, String aDescription) {
        super(aOperation, Boolean.class, aDescription);
    }

    public BooleanDirective(String aOperation, String aDescription, Consumer<BooleanDirective> aConsumer) {
        super(aOperation, Boolean.class, aDescription, aConsumer);
    }

    public BooleanDirective(String aOperation, String aAlias, String aDescription) {
        super(aOperation, Boolean.class, aAlias, aDescription);
    }

    public BooleanDirective(String aOperation, String aAlias, String aDescription, Consumer<BooleanDirective> aConsumer) {
        super(aOperation, Boolean.class, aAlias, aDescription, aConsumer);
    }

    public BooleanDirective(Relation<String, Boolean> aProperty) {
        super(aProperty, Boolean.class);
    }

    public BooleanDirective(Relation<String, Boolean> aProperty, Consumer<BooleanDirective> aConsumer) {
        super(aProperty, Boolean.class, aConsumer);
    }

    @Override
    public Boolean getValue() {
        return super.getValue() != null ? (Boolean)super.getValue() : Boolean.FALSE;
    }

    public BooleanDirective withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return this;
    }

    @Override
    protected Boolean toType(String aArg) throws ParseArgsException {
        try {
            if (BooleanLiterals.isTrue((String)aArg)) {
                this._matchCount = 1;
                return true;
            }
            if (BooleanLiterals.isFalse((String)aArg)) {
                this._matchCount = 1;
                return false;
            }
            Boolean theValue = Boolean.valueOf(aArg);
            this._matchCount = 1;
            return theValue;
        }
        catch (NumberFormatException e) {
            ParseArgsException theException = new ParseArgsException("Unable to parse the argument <" + aArg + "> of option \"" + this.getAlias() + "\" to a <boolean> value.", new String[]{aArg}, (Term)this, e);
            this._exception = theException;
            throw theException;
        }
    }
}

