/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.exception.BugException;

public interface Option<T>
extends Operand<T> {
    public String getLongOption();

    public Character getShortOption();

    @Override
    default public String[] toKeywords(CliContext aCliCtx) {
        if (this.getShortOption() != null && this.getLongOption() != null) {
            return new String[]{this.toShortOption(aCliCtx), this.toLongOption(aCliCtx)};
        }
        if (this.getShortOption() != null) {
            return new String[]{this.toShortOption(aCliCtx)};
        }
        if (this.getLongOption() != null) {
            return new String[]{this.toLongOption(aCliCtx)};
        }
        throw new BugException("An option must have either a short or a long option, though neither is set!");
    }

    default public String toShortOption(CliContext aCliCtx) {
        return this.getShortOption() != null ? aCliCtx.getSyntaxMetrics().getShortOptionPrefix().toString() + this.getShortOption() : null;
    }

    default public String toLongOption(CliContext aCliCtx) {
        return this.getLongOption() != null ? aCliCtx.getSyntaxMetrics().getLongOptionPrefix() + this.getLongOption() : null;
    }

    @Override
    default public String toUsage(CliContext aCliCtx) {
        String theShortOption = this.toShortOption(aCliCtx);
        return theShortOption != null ? theShortOption : this.toLongOption(aCliCtx);
    }

    @Override
    default public String toSpec(CliContext aCliCtx) {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append(aCliCtx.toKeywordEscapeCode());
        String theShortOption = this.toShortOption(aCliCtx);
        String theLongOption = this.toLongOption(aCliCtx);
        if (theShortOption != null) {
            theBuilder.append(theShortOption);
        }
        if (theLongOption != null) {
            if (theShortOption != null) {
                theBuilder.append(' ');
            }
            theBuilder.append(theLongOption);
        }
        theBuilder.append(aCliCtx.toResetEscapeCode());
        theBuilder.append(' ');
        theBuilder.append(aCliCtx.getSyntaxMetrics().getArgumentPrefix());
        theBuilder.append(aCliCtx.toArgumentEscapeCode()).append(this.getAlias() != null ? this.getAlias() : aCliCtx.getSyntaxMetrics().getUndefinedSymbol()).append(aCliCtx.toResetEscapeCode());
        theBuilder.append(aCliCtx.getSyntaxMetrics().getArgumentSuffix());
        return theBuilder.toString();
    }

    @Override
    default public String toSyntax(CliContext aCliCtx) {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append(aCliCtx.toKeywordEscapeCode());
        theBuilder.append(this.toUsage(aCliCtx));
        theBuilder.append(aCliCtx.toResetEscapeCode());
        theBuilder.append(' ');
        theBuilder.append(aCliCtx.getSyntaxMetrics().getArgumentPrefix());
        theBuilder.append(aCliCtx.toArgumentEscapeCode()).append(this.getAlias() != null ? this.getAlias() : aCliCtx.getSyntaxMetrics().getUndefinedSymbol()).append(aCliCtx.toResetEscapeCode());
        theBuilder.append(aCliCtx.getSyntaxMetrics().getArgumentSuffix());
        return theBuilder.toString();
    }
}

