/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Term;

public class OrCondition
extends AbstractCondition {
    public OrCondition(Term ... aArgs) {
        super("At least one (OR) syntax branch must match from the command line arguments.", aArgs);
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aKeywords, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList theResult = null;
        ArgsSyntaxException theCause = null;
        for (Term eChild : this._children) {
            try {
                Operand<?>[] eOperands = eChild.parseArgs(aArgs, aKeywords, aCliCtx);
                if (eOperands != null) {
                    if (theResult == null) {
                        theResult = new ArrayList();
                    }
                    for (Operand<?> eOperand : eOperands) {
                        theResult.add(eOperand);
                    }
                }
                aArgs = OrCondition.toArgsDiff(aArgs, eOperands);
            }
            catch (ArgsSyntaxException e) {
                if (theCause == null) {
                    theCause = e;
                    continue;
                }
                theCause.addSuppressed((Throwable)((Object)e));
            }
        }
        if (theResult != null) {
            return theResult.toArray(new Operand[theResult.size()]);
        }
        this._exception = new ArgsSyntaxException("Not any syntax branch matched the command line arguments, though at least one (OR) syntax branch must be matched by the command line arguments!", aArgs, (Term)this, (Throwable)((Object)theCause));
        throw this._exception;
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        Object theSynopsis = "";
        for (Term eChild : this._children) {
            if (!eChild.isVisible()) continue;
            if (((String)theSynopsis).length() != 0) {
                theSynopsis = (String)theSynopsis + (String)(aCliCtx.getSyntaxMetrics().getOrSymbol() != null && aCliCtx.getSyntaxMetrics().getOrSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getOrSymbol() + " " : " ");
            }
            theSynopsis = (String)theSynopsis + eChild.toSyntax(aCliCtx);
        }
        return theSynopsis;
    }

    public OrCondition withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return this;
    }
}

