/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.IOException;
import org.refcodes.codec.BaseConfig;
import org.refcodes.codec.BaseEncoder;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.component.Openable;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.io.ByteConsumer;
import org.refcodes.io.ByteReceiver;
import org.refcodes.io.ByteSender;
import org.refcodes.io.ByteSenderDecorator;

public abstract class AbstractBaseEncoder
extends AbstractConnectableAutomaton
implements BaseEncoder {
    private static final int BYTE_MASK = 255;
    private static final int BYTES_PER_INT = 4;
    private static final int BITS_PER_BYTE = 8;
    private static final int BITS_PER_INT = 32;
    private ByteSender _byteSender;
    private BaseMetrics _baseCodecMetrics = BaseConfig.BASE64;
    private byte[] _buffer = new byte[this._baseCodecMetrics.getBytesPerInt()];
    private int _index = 0;

    @Override
    public BaseMetrics getBaseMetrics() {
        return this._baseCodecMetrics;
    }

    @Override
    public void setBaseMetrics(BaseMetrics aBaseMetrics) {
        this._baseCodecMetrics = aBaseMetrics;
        this._buffer = new byte[this._baseCodecMetrics.getBytesPerInt()];
    }

    @Override
    public BaseEncoder withBaseMetrics(BaseMetrics _baseCodecMetrics) {
        this.setBaseMetrics(_baseCodecMetrics);
        return this;
    }

    public void writeDatagram(byte aDatagram) throws OpenException {
        this._buffer[this._index % this._baseCodecMetrics.getBytesPerInt()] = aDatagram;
        ++this._index;
        if (this._index % this._baseCodecMetrics.getBytesPerInt() == 0) {
            this.toEncodedText(0);
        }
    }

    public void writeDatagrams(byte[] aDatagram) throws OpenException {
        for (byte eData : aDatagram) {
            this.writeDatagram(eData);
        }
    }

    public void writeDatagrams(byte[] aDatagram, int aOffset, int aLength) throws OpenException {
        for (int i = aOffset; i < aOffset + aLength; ++i) {
            this.writeDatagram(aDatagram[i]);
        }
    }

    public void flush() throws OpenException {
        this._byteSender.flush();
    }

    public synchronized void close() throws CloseException {
        int theMod = this._index % this._baseCodecMetrics.getBytesPerInt();
        int theTrailingBytes = theMod == 0 ? 0 : this._baseCodecMetrics.getBytesPerInt() - theMod;
        try {
            if (theTrailingBytes != 0) {
                while (this._index % this._baseCodecMetrics.getBytesPerInt() != 0) {
                    this._buffer[this._index % this._baseCodecMetrics.getBytesPerInt()] = 0;
                    ++this._index;
                }
                this.toEncodedText(theTrailingBytes);
                for (int i = 0; i < theTrailingBytes; ++i) {
                    this._byteSender.writeDatagram((byte)(this._baseCodecMetrics.getPaddingChar() & 0xFF));
                }
            }
        }
        catch (IOException e) {
            throw new CloseException("Unable to finish off encoding.", (Throwable)e);
        }
        try {
            this._byteSender.flush();
            this._byteSender.close();
        }
        catch (IOException e) {
            throw new CloseException("Unable to close the output stream <" + this._byteSender + ">.", (Throwable)e);
        }
        super.close();
    }

    protected void open(ByteConsumer aConnection) throws OpenException {
        this._byteSender = aConnection instanceof ByteReceiver ? (ByteSender)aConnection : new ByteSenderDecorator(aConnection);
        if (!this._byteSender.isOpened()) {
            if (this._byteSender instanceof Openable) {
                ((Openable)this._byteSender).open();
            } else {
                throw new OpenException("The provided connection is in status <" + this._byteSender.getConnectionStatus() + "> but does not provide the <" + Openable.class.getName() + "> interface.");
            }
        }
        this.open();
    }

    private void toEncodedText(int aTrailingBytes) throws OpenException {
        int theWord = AbstractBaseEncoder.toWord(this._buffer, 0, this._baseCodecMetrics);
        theWord <<= 8 * (4 - this._baseCodecMetrics.getBytesPerInt());
        for (int i = 0; i < this._baseCodecMetrics.getDigitsPerInt() - aTrailingBytes; ++i) {
            int eByte = theWord >> 32 - this._baseCodecMetrics.getBitsPerDigit() & this._baseCodecMetrics.getDigitMask();
            try {
                this._byteSender.writeDatagram((byte)(this._baseCodecMetrics.toChar(eByte) & 0xFF));
            }
            catch (IOException e) {
                throw new OpenException("Unable to write to the provided output stream <" + this._byteSender + ">: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            }
            theWord <<= this._baseCodecMetrics.getBitsPerDigit();
        }
    }

    private static int toWord(byte[] aDecodedData, int aOffset, BaseMetrics aBaseMetrics) {
        int eWord = 0;
        for (int i = 0; i < aBaseMetrics.getBytesPerInt(); ++i) {
            eWord <<= 8;
            if (aOffset + i >= aDecodedData.length) continue;
            eWord |= aDecodedData[aOffset + i] & 0xFF;
        }
        return eWord;
    }
}

