/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.data.Binary;
import org.refcodes.data.BitMask;
import org.refcodes.numerical.NumericalUtility;

public class BaseBuilderImpl
implements BaseBuilder {
    private static final boolean IS_USE_SINGLE_CODE_BASE = false;
    private BaseMetrics _baseCodecMetrics = null;
    private String _encodedText = null;
    private byte[] _decodedData = null;

    @Override
    public BaseMetrics getBaseMetrics() {
        return this._baseCodecMetrics;
    }

    @Override
    public void setBaseMetrics(BaseMetrics aBaseMetrics) {
        this._baseCodecMetrics = aBaseMetrics;
    }

    @Override
    public String getEncodedText() {
        this._encodedText = BaseBuilderImpl.toEncodedText(this._decodedData, this._baseCodecMetrics);
        this._decodedData = null;
        return this._encodedText;
    }

    @Override
    public void setEncodedText(String aEncodedText) {
        this._encodedText = aEncodedText;
        this._decodedData = null;
    }

    @Override
    public byte[] getDecodedData() {
        this._decodedData = BaseBuilderImpl.toDecodedData(this._encodedText, this._baseCodecMetrics);
        this._encodedText = null;
        return this._decodedData;
    }

    @Override
    public void setDecodedData(byte[] aDecodedData) {
        this._decodedData = aDecodedData;
        this._encodedText = null;
    }

    @Override
    public void setDecodedData(long aDecodedData) {
        this.setDecodedData(NumericalUtility.toBytes((long)aDecodedData));
    }

    @Override
    public String toEncodedText(byte[] aDecodedData) {
        return BaseBuilderImpl.toEncodedText(aDecodedData, this._baseCodecMetrics);
    }

    @Override
    public byte[] toDecodedData(String aEncodedText) {
        return BaseBuilderImpl.toDecodedData(aEncodedText, this._baseCodecMetrics);
    }

    @Override
    public String toEncodedText(long aDecodedData) {
        return this.toEncodedText(NumericalUtility.toBytes((long)aDecodedData));
    }

    protected static String toEncodedText(byte[] aDecodedData, BaseMetrics aBaseMetrics) {
        int theMod = aDecodedData.length % aBaseMetrics.getBytesPerInt();
        int theTrailingBytes = 0;
        int theEncodedSize = BaseBuilderImpl.toEncodedSize(aDecodedData, aBaseMetrics);
        char[] theEncodedText = new char[theEncodedSize];
        int theIndex = 0;
        for (int theOffset = 0; theOffset < aDecodedData.length; theOffset += aBaseMetrics.getBytesPerInt()) {
            int i;
            int eWord = BaseBuilderImpl.toWord(aDecodedData, theOffset, aBaseMetrics);
            if (theOffset + aBaseMetrics.getBytesPerInt() >= aDecodedData.length) {
                theTrailingBytes = theMod == 0 ? 0 : aBaseMetrics.getBytesPerInt() - theMod;
            }
            int eTrailingUnused = Binary.BITS_PER_BYTE.getValue() * (Binary.BYTES_PER_INT.getValue() - aBaseMetrics.getBytesPerInt());
            eWord <<= eTrailingUnused;
            for (i = 0; i < aBaseMetrics.getDigitsPerInt() - theTrailingBytes; ++i) {
                int eByte = eWord >> Binary.BITS_PER_INT.getValue() - aBaseMetrics.getBitsPerDigit() & aBaseMetrics.getDigitMask();
                theEncodedText[theIndex++] = aBaseMetrics.toChar(eByte);
                eWord <<= aBaseMetrics.getBitsPerDigit();
            }
            for (i = 0; i < theTrailingBytes; ++i) {
                theEncodedText[theIndex++] = aBaseMetrics.getPaddingChar();
            }
        }
        String theResult = new String(theEncodedText);
        return theResult;
    }

    private static int toEncodedSize(byte[] aDecodedData, BaseMetrics aBaseMetrics) {
        int theMod = aDecodedData.length % aBaseMetrics.getBytesPerInt();
        int theTrailingBytes = theMod == 0 ? 0 : aBaseMetrics.getBytesPerInt() - theMod;
        double d = (double)aBaseMetrics.getDigitsPerInt() / (double)aBaseMetrics.getBytesPerInt();
        int theAdd = (int)Math.ceil(d * (double)theTrailingBytes);
        return aDecodedData.length * aBaseMetrics.getDigitsPerInt() / aBaseMetrics.getBytesPerInt() + theAdd;
    }

    private static int toWord(byte[] aDecodedData, int aOffset, BaseMetrics aBaseMetrics) {
        int eWord = 0;
        for (int i = 0; i < aBaseMetrics.getBytesPerInt(); ++i) {
            eWord <<= Binary.BITS_PER_BYTE.getValue().intValue();
            if (aOffset + i >= aDecodedData.length) continue;
            eWord = (int)((long)eWord | (long)aDecodedData[aOffset + i] & BitMask.MASK_8.getValue());
        }
        return eWord;
    }

    protected static byte[] toDecodedData(String aEncodedText, BaseMetrics aBaseMetrics) {
        if (aEncodedText.length() % aBaseMetrics.getDigitsPerInt() != 0) {
            throw new IllegalArgumentException("The length of <" + aEncodedText.length() + "> of the encoded text cannot be divided (modulo = 0) by <" + aBaseMetrics.getDigitsPerByte() + "> which is required by the codec <" + aBaseMetrics + ">.");
        }
        int thePaddingIndex = aEncodedText.indexOf(aBaseMetrics.getPaddingChar());
        int theTrailingBytes = 0;
        int theDecodedSize = BaseBuilderImpl.toDecodedSize(aEncodedText, aBaseMetrics);
        byte[] theDecodedData = new byte[theDecodedSize];
        int theIndex = 0;
        for (int theOffset = 0; theOffset < aEncodedText.length(); theOffset += aBaseMetrics.getDigitsPerInt()) {
            if (theOffset + aBaseMetrics.getDigitsPerInt() >= aEncodedText.length()) {
                theTrailingBytes = thePaddingIndex > 0 ? aEncodedText.length() - thePaddingIndex : 0;
            }
            int eWord = 0;
            for (int i = 0; i < aBaseMetrics.getDigitsPerInt(); ++i) {
                eWord <<= aBaseMetrics.getBitsPerDigit();
                eWord = (int)((long)eWord | (long)aBaseMetrics.toValue(aEncodedText.charAt(theOffset + i)) & BitMask.MASK_8.getValue());
            }
            theIndex = BaseBuilderImpl.toBytes(theDecodedData, theIndex, eWord, theTrailingBytes, aBaseMetrics);
        }
        return theDecodedData;
    }

    protected static int toDecodedSize(String aEncodedText, BaseMetrics aBaseMetrics) {
        int thePaddingIndex = aEncodedText.indexOf(aBaseMetrics.getPaddingChar());
        int theTrailingDigits = thePaddingIndex == -1 ? 0 : aEncodedText.length() - thePaddingIndex;
        return aEncodedText.length() * aBaseMetrics.getBytesPerInt() / aBaseMetrics.getDigitsPerInt() - theTrailingDigits;
    }

    protected static int toBytes(byte[] aDecodedBytes, int aOffset, int aWord, int aTrailingBytes, BaseMetrics aBaseMetrics) {
        for (int i = 0; i < aBaseMetrics.getBytesPerInt(); ++i) {
            if (i >= aTrailingBytes) {
                int theIndex = aOffset + aBaseMetrics.getBytesPerInt() - i - 1;
                aDecodedBytes[theIndex] = (byte)aWord;
            }
            aWord >>= Binary.BITS_PER_BYTE.getValue().intValue();
        }
        return aOffset + aBaseMetrics.getBytesPerInt();
    }

    private static byte[] toPrimitiveType(Byte[] aBytes) {
        if (aBytes == null) {
            return null;
        }
        byte[] thePrimitives = new byte[aBytes.length];
        for (int i = 0; i < aBytes.length; ++i) {
            thePrimitives[i] = aBytes[i];
        }
        return thePrimitives;
    }
}

