/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.ChannelSelector;
import org.refcodes.codec.FrequencyThreshold;
import org.refcodes.codec.ModemDecoderImpl;
import org.refcodes.codec.ModemEncoderImpl;
import org.refcodes.codec.ModemMetrics;
import org.refcodes.codec.ModemMetricsImpl;
import org.refcodes.codec.ModemMode;
import org.refcodes.codec.ModulationFormat;
import org.refcodes.codec.SampleRate;
import org.refcodes.component.OpenException;
import org.refcodes.data.SystemProperty;
import org.refcodes.data.Text;
import org.refcodes.io.LoopbackShortReceiverImpl;
import org.refcodes.io.LoopbackShortSenderImpl;
import org.refcodes.io.ShortArrayReceiverImpl;
import org.refcodes.io.ShortConsumer;
import org.refcodes.io.ShortReceiver;
import org.refcodes.io.ShortSender;

public class ModemTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testModem1() throws OpenException, InterruptedException {
        String[] theLines;
        ModemMetricsImpl theModemMetrics = new ModemMetricsImpl(SampleRate.STEREO, ModulationFormat.SHORT, ChannelSelector.MONO, ModemMode.SOFT_MODEM_4, FrequencyThreshold.THRESHOLD_20);
        final ArrayList theEncoded = new ArrayList();
        ModemEncoderImpl theEncoder = new ModemEncoderImpl((ModemMetrics)theModemMetrics, new ShortConsumer(){

            public void writeDatagrams(short[] aDatagrams, int aOffset, int aLength) throws OpenException {
                for (int i = 0; i < aLength; ++i) {
                    theEncoded.add(aDatagrams[i + aOffset]);
                }
            }
        });
        theEncoder.writeDatagrams(Text.ARECIBO_MESSAGE.toString().getBytes());
        ModemDecoderImpl theDecoder = new ModemDecoderImpl((ModemMetrics)theModemMetrics, (ShortReceiver)new ShortArrayReceiverImpl(theEncoded));
        ArrayList<Byte> theDecoded = new ArrayList<Byte>();
        while (theDecoder.hasDatagram()) {
            if (!theDecoder.hasDatagram()) continue;
            theDecoded.add(theDecoder.readDatagram());
        }
        String theMessage = new String(ModemTest.toPrimitiveType(theDecoded.toArray(new Byte[theDecoded.size()])));
        for (String eLine : theLines = theMessage.split(SystemProperty.LINE_SEPARATOR.getValue())) {
            if (!IS_LOG_TESTS) continue;
            System.out.println(eLine);
        }
        Assertions.assertEquals((Object)Text.ARECIBO_MESSAGE.toString(), (Object)theMessage);
    }

    @Test
    public void testModem2() throws OpenException, InterruptedException {
        String[] theLines;
        ModemMetricsImpl theModemMetrics = new ModemMetricsImpl(SampleRate.STEREO, ModulationFormat.SHORT, ChannelSelector.MONO, ModemMode.SOFT_MODEM_4, FrequencyThreshold.THRESHOLD_20);
        String theMessage = Text.ARECIBO_MESSAGE.toString();
        LoopbackShortReceiverImpl theReceiver = new LoopbackShortReceiverImpl(656532);
        LoopbackShortSenderImpl theSender = new LoopbackShortSenderImpl();
        theReceiver.open((Object)theSender);
        theSender.open((Object)theReceiver);
        ModemEncoderImpl theEncoder = new ModemEncoderImpl((ModemMetrics)theModemMetrics, (ShortSender)theSender);
        theEncoder.writeDatagrams(theMessage.getBytes());
        ModemDecoderImpl theDecoder = new ModemDecoderImpl((ModemMetrics)theModemMetrics, (ShortReceiver)theReceiver);
        ArrayList<Byte> theDecoded = new ArrayList<Byte>();
        while (theDecoder.hasDatagram()) {
            if (!theDecoder.hasDatagram()) continue;
            theDecoded.add(theDecoder.readDatagram());
        }
        String theReceived = new String(ModemTest.toPrimitiveType(theDecoded.toArray(new Byte[theDecoded.size()])));
        for (String eLine : theLines = theReceived.split(SystemProperty.LINE_SEPARATOR.getValue())) {
            if (!IS_LOG_TESTS) continue;
            System.out.println(eLine);
        }
        Assertions.assertEquals((Object)theMessage, (Object)theMessage);
    }

    @Test
    public void testModem3() throws OpenException, InterruptedException {
        String[] theLines;
        ModemMetricsImpl theModemMetrics = new ModemMetricsImpl(SampleRate.STEREO, ModulationFormat.SHORT, ChannelSelector.MONO, ModemMode.SOFT_MODEM_4, FrequencyThreshold.THRESHOLD_20);
        String theMessage = Text.ARECIBO_MESSAGE.toString();
        LoopbackShortReceiverImpl theReceiver = new LoopbackShortReceiverImpl(656532);
        LoopbackShortSenderImpl theSender = new LoopbackShortSenderImpl();
        theReceiver.open((Object)theSender);
        theSender.open((Object)theReceiver);
        ModemEncoderImpl theEncoder = new ModemEncoderImpl((ModemMetrics)theModemMetrics, (ShortSender)theSender);
        theEncoder.writeDatagrams(theMessage.getBytes());
        ModemDecoderImpl theDecoder = new ModemDecoderImpl((ModemMetrics)theModemMetrics, (ShortReceiver)theReceiver);
        byte[] theData = null;
        byte[] eData = null;
        while (theDecoder.hasDatagram()) {
            eData = theDecoder.readDatagrams();
            if (theData == null) {
                theData = eData;
                continue;
            }
            byte[] tmpData = new byte[theData.length + eData.length];
            System.arraycopy(theData, 0, tmpData, 0, theData.length);
            System.arraycopy(eData, 0, tmpData, theData.length, eData.length);
            theData = tmpData;
        }
        for (String eLine : theLines = new String(theData).split(SystemProperty.LINE_SEPARATOR.getValue())) {
            if (!IS_LOG_TESTS) continue;
            System.out.println(eLine);
        }
    }

    private static byte[] toPrimitiveType(Byte[] aBytes) {
        if (aBytes == null) {
            return null;
        }
        byte[] thePrimitives = new byte[aBytes.length];
        for (int i = 0; i < aBytes.length; ++i) {
            thePrimitives[i] = aBytes[i];
        }
        return thePrimitives;
    }
}

