/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseEncoder;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;

public class OutputStreamBaseEncoderTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");
    private static final int WEAK_INTENSITY_LOOPS = 4096;
    private static final int MAX_DATA_LENGTH = 4096;

    @Test
    public void testAllRandomText() throws IOException {
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            this.runRandomTextTest((BaseMetrics)eCodec);
        }
    }

    @Test
    public void testAllRandomBytes() throws IOException {
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            this.runRandomBytesTest((BaseMetrics)eCodec);
        }
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugBaseEncodeOutputStream1() throws IOException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        BaseMetricsConfig theCodecMetrics = BaseMetricsConfig.BASE64;
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics((BaseMetrics)theCodecMetrics);
        byte[] theDecodedBytes = "Hello world!".getBytes();
        theBaseCodeBuilder.withDecodedData(theDecodedBytes);
        String theEncodedText = theBaseCodeBuilder.getEncodedText();
        BaseEncoder theEncodeSender = new BaseEncoder((OutputStream)theOutputStream).withBaseMetrics((BaseMetrics)theCodecMetrics);
        theEncodeSender.transmitAllBytes(theDecodedBytes);
        theEncodeSender.close();
        String theResult = new String(theOutputStream.toByteArray());
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Expecting <" + theResult + "> to be <" + theEncodedText + "> ...");
        }
        Assertions.assertEquals((Object)theEncodedText, (Object)theResult);
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugBaseEncodeOutputStream2() throws IOException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        BaseMetricsConfig theCodecMetrics = BaseMetricsConfig.BASE64;
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics((BaseMetrics)theCodecMetrics);
        byte[] theDecodedBytes = "Hello world!!".getBytes();
        theBaseCodeBuilder.withDecodedData(theDecodedBytes);
        String theEncodedText = theBaseCodeBuilder.getEncodedText();
        BaseEncoder theEncodeSender = new BaseEncoder((OutputStream)theOutputStream).withBaseMetrics((BaseMetrics)theCodecMetrics);
        theEncodeSender.transmitAllBytes(theDecodedBytes);
        theEncodeSender.close();
        String theResult = new String(theOutputStream.toByteArray());
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Expecting <" + theResult + "> to be <" + theEncodedText + "> ...");
        }
        Assertions.assertEquals((Object)theEncodedText, (Object)theResult);
    }

    private String toRandomText(int aLength) {
        return RandomTextGenerartor.asString((int)aLength, (RandomTextMode)RandomTextMode.ASCII);
    }

    private void runRandomTextTest(BaseMetrics aBaseMetrics) throws IOException {
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Running random text tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            ByteArrayOutputStream eOutputStream = new ByteArrayOutputStream();
            BaseEncoder eBaseEncodeOutputStream = new BaseEncoder((OutputStream)eOutputStream).withBaseMetrics(aBaseMetrics);
            String eRndText = this.toRandomText(i % 4096);
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            eBaseEncodeOutputStream.transmitAllBytes(eInputBytes);
            eBaseEncodeOutputStream.close();
            String theResult = new String(eOutputStream.toByteArray());
            Assertions.assertEquals((Object)eEncodedText, (Object)theResult);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseMetrics != BaseMetricsConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assertions.assertEquals((Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }

    private void runRandomBytesTest(BaseMetrics aBaseMetrics) throws IOException {
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Running random bytes tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            ByteArrayOutputStream eOutputStream = new ByteArrayOutputStream();
            BaseEncoder eBaseEncodeOutputStream = new BaseEncoder((OutputStream)eOutputStream).withBaseMetrics(aBaseMetrics);
            int eMod = i % 4096;
            byte[] eInputBytes = new byte[eMod];
            new SecureRandom().nextBytes(eInputBytes);
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            eBaseEncodeOutputStream.transmitAllBytes(eInputBytes);
            eBaseEncodeOutputStream.close();
            String theResult = new String(eOutputStream.toByteArray());
            Assertions.assertEquals((Object)eEncodedText, (Object)theResult);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseMetrics != BaseMetricsConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assertions.assertEquals((Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }
}

