/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.codec.BaseMetricsImpl;
import org.refcodes.data.CharSet;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;

public class BaseBuilderTest {
    private static final int WEAK_INTENSITY_LOOPS = 10240;
    private static final int STRONG_INTENSITY_LOOPS = 150000;
    private static final int MAX_DATA_LENGTH = 8192;
    private static final char[] CHAR_SET = CharSet.ALPHANUMERIC.getCharSet();
    private static final Random RND = new SecureRandom();

    @Test
    public void testAllRandomText() {
        boolean isTestSideEffectFreeCall = true;
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            this.runRandomTextTest((BaseMetrics)eCodec, isTestSideEffectFreeCall);
            isTestSideEffectFreeCall = !isTestSideEffectFreeCall;
        }
    }

    @Test
    public void testAllRandomBytes() {
        boolean isTestSideEffectFreeCall = true;
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            this.runRandomBytesTest((BaseMetrics)eCodec, isTestSideEffectFreeCall);
            isTestSideEffectFreeCall = !isTestSideEffectFreeCall;
        }
    }

    @Test
    public void testBlockSize() {
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println(eCodec.toString());
            }
            BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics((BaseMetrics)eCodec);
            for (int i = 1; i < 64; ++i) {
                String eEncoded = theBaseCodeBuilder.toEncodedText(RandomTextGenerartor.asString((int)i, (RandomTextMode)RandomTextMode.ALPHANUMERIC));
                int eCount = this.count(eEncoded, eCodec.getPaddingChar());
                int ePaddingNumber = eCodec.toPaddingCharsNumber(i);
                if (SystemProperty.LOG_TESTS.isEnabled()) {
                    System.out.println("[" + (eCount != ePaddingNumber ? "X" : "\u2713") + "] " + ePaddingNumber + " ? " + eCount + ": " + eEncoded + " (" + i + ")");
                }
                Assertions.assertEquals((int)eCount, (int)ePaddingNumber);
            }
        }
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugeEdgeCase() {
        BaseMetricsConfig theMetrics = BaseMetricsConfig.ENCODED_AS_NUMBER;
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theMetrics);
        }
        BaseBuilder theBuilder = new BaseBuilder().withBaseMetrics((BaseMetrics)theMetrics);
        String theEncoded = theBuilder.toEncodedText("Hallo welt! 1234567890 ABC".getBytes());
        byte[] theDecoded = theBuilder.toDecodedData(theEncoded);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theEncoded);
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(new String(theDecoded));
        }
    }

    @Test
    public void debugEncodedAsNumberCodec() {
        this.runRandomTextTest((BaseMetrics)BaseMetricsConfig.ENCODED_AS_NUMBER, false);
    }

    @Test
    public void debugBase64Codec() {
        BaseMetricsImpl theBase64 = new BaseMetricsImpl(64, CharSet.BASE64.getCharSet());
        this.runRandomTextTest((BaseMetrics)theBase64, true);
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugGetBytesFromText() {
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics((BaseMetrics)BaseMetricsConfig.BASE64);
        theBaseCodeBuilder.withDecodedData("Hello world!".getBytes());
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theBaseCodeBuilder.getEncodedText());
        }
    }

    @Disabled(value="Just for throughput measurement")
    @Test
    public void testEncodeRefcodes() {
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics((BaseMetrics)BaseMetricsConfig.BASE64);
        for (int i = 0; i < 150000; ++i) {
            String theRndText = this.toRandom(i % 8192);
            byte[] eBytes = theRndText.getBytes();
            theBaseCodeBuilder.withDecodedData(eBytes).getEncodedText();
        }
    }

    @Disabled(value="Just for throughput measurement")
    @Test
    public void testEncodeJava() {
        for (int i = 0; i < 150000; ++i) {
            String theRndText = this.toRandom(i % 8192);
            byte[] eBytes = theRndText.getBytes();
            Base64.getEncoder().encodeToString(eBytes);
        }
    }

    private void runRandomTextTest(BaseMetrics aBaseMetrics, boolean isWithSideEffectFreeShortcut) {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Running random text tests for base <" + (aBaseMetrics.getNumberBase() < 10 ? "0" : "") + aBaseMetrics.getNumberBase() + "> (" + (isWithSideEffectFreeShortcut ? "*" : "?") + ") ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 10240; ++i) {
            String eRndText = this.toRandom(i % 8192);
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = !isWithSideEffectFreeShortcut ? theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText() : theBaseCodeBuilder.toEncodedText(eInputBytes);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseMetrics != BaseMetricsConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assertions.assertEquals((Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }

    private void runRandomBytesTest(BaseMetrics aBaseMetrics, boolean isWithSideEffectFreeShortcut) {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Running random bytes tests for base <" + (aBaseMetrics.getNumberBase() < 10 ? "0" : "") + aBaseMetrics.getNumberBase() + "> (" + (isWithSideEffectFreeShortcut ? "*" : "?") + ") ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 10240; ++i) {
            int eMod = i % 8192;
            byte[] eInputBytes = new byte[eMod];
            new SecureRandom().nextBytes(eInputBytes);
            String eEncodedText = !isWithSideEffectFreeShortcut ? theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText() : theBaseCodeBuilder.toEncodedText(eInputBytes);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseMetrics != BaseMetricsConfig.BASE64) continue;
            String eReferenceEncodedText = Base64.getEncoder().encodeToString(eInputBytes);
            Assertions.assertEquals((Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }

    private String toRandom(int aColumnWidth) {
        int theBound = CHAR_SET.length;
        char[] theRandom = new char[aColumnWidth];
        for (int i = 0; i < aColumnWidth; ++i) {
            theRandom[i] = CHAR_SET[RND.nextInt(theBound)];
        }
        return new String(theRandom);
    }

    private int count(String aString, char aChar) {
        int theCount = 0;
        int eIndexOf = aString.indexOf(aChar);
        while (eIndexOf != -1) {
            aString = aString.substring(eIndexOf + 1);
            ++theCount;
            eIndexOf = aString.indexOf(aChar);
        }
        return theCount;
    }
}

