/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseDecoder;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;

public class InputStreamBaseDecoderTest {
    private static final int WEAK_INTENSITY_LOOPS = 4096;
    private static final int MAX_DATA_LENGTH = 4096;

    @Test
    public void testAllRandomText() throws IOException, InterruptedException {
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            this.runRandomTextTest((BaseMetrics)eCodec);
        }
    }

    @Test
    public void testAllRandomBytes() throws IOException, InterruptedException {
        for (BaseMetricsConfig eCodec : BaseMetricsConfig.values()) {
            this.runRandomBytesTest((BaseMetrics)eCodec);
        }
    }

    @Disabled(value="Just for debugging purposes")
    @Test
    public void debugBaseDecodeInputStreamTest1() throws IOException, InterruptedException {
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics((BaseMetrics)BaseMetricsConfig.BINARY);
        String theInputText = "Hello World!?";
        byte[] theInputBytes = "Hello World!?".getBytes();
        String theEncodedText = theBaseCodeBuilder.withDecodedData(theInputBytes).getEncodedText();
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theEncodedText.getBytes());
        BaseDecoder theDecodeReceiver = new BaseDecoder((InputStream)theInputStream).withBaseMetrics((BaseMetrics)BaseMetricsConfig.BINARY);
        ArrayList<Byte> theDecodedBytes = new ArrayList<Byte>();
        while (theDecodeReceiver.hasAvailable()) {
            byte[] eDecodedBytes;
            byte[] byArray = eDecodedBytes = theDecodeReceiver.receiveAllBytes();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte eByte = byArray[i];
                theDecodedBytes.add(eByte);
            }
        }
        theDecodeReceiver.close();
        String theDecodedText = new String(InputStreamBaseDecoderTest.toPrimitiveType(theDecodedBytes.toArray(new Byte[theDecodedBytes.size()])));
        Assertions.assertEquals((Object)"Hello World!?", (Object)theDecodedText);
    }

    private void runRandomTextTest(BaseMetrics aBaseMetrics) throws IOException, InterruptedException {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Running random text tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            String eRndText = this.toRandomText(i % 4096);
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            ByteArrayInputStream eInputStream = new ByteArrayInputStream(eEncodedText.getBytes());
            BaseDecoder eDecodeReceiver = new BaseDecoder((InputStream)eInputStream).withBaseMetrics(aBaseMetrics);
            ArrayList<Byte> eDecodedBytes = new ArrayList<Byte>();
            while (eDecodeReceiver.hasAvailable()) {
                byte[] eDecodedBlock;
                byte[] byArray = eDecodedBlock = eDecodeReceiver.receiveAllBytes();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    Byte eByte = byArray[j];
                    eDecodedBytes.add(eByte);
                }
            }
            eDecodeReceiver.close();
            String eDecodedText = new String(InputStreamBaseDecoderTest.toPrimitiveType(eDecodedBytes.toArray(new Byte[eDecodedBytes.size()])));
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("Expecting <" + eDecodedText + "> to be <" + eRndText + "> ...");
            }
            Assertions.assertEquals((Object)eRndText, (Object)eDecodedText);
        }
    }

    private void runRandomBytesTest(BaseMetrics aBaseMetrics) throws IOException, InterruptedException {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Running random text tests for base <" + aBaseMetrics.getNumberBase() + "> ...");
        }
        BaseBuilder theBaseCodeBuilder = new BaseBuilder().withBaseMetrics(aBaseMetrics);
        for (int i = 0; i < 4096; ++i) {
            int eMod = i % 4096;
            byte[] eInputBytes = new byte[eMod];
            new SecureRandom().nextBytes(eInputBytes);
            String eEncodedText = theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText();
            ByteArrayInputStream eInputStream = new ByteArrayInputStream(eEncodedText.getBytes());
            BaseDecoder eDecodeReceiver = new BaseDecoder((InputStream)eInputStream).withBaseMetrics(aBaseMetrics);
            ArrayList<Byte> eDecodedByteList = new ArrayList<Byte>();
            while (eDecodeReceiver.hasAvailable()) {
                byte[] eDecodedBlock;
                byte[] byArray = eDecodedBlock = eDecodeReceiver.receiveAllBytes();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    Byte eByte = byArray[j];
                    eDecodedByteList.add(eByte);
                }
            }
            eDecodeReceiver.close();
            byte[] eDecodedBytes = InputStreamBaseDecoderTest.toPrimitiveType(eDecodedByteList.toArray(new Byte[eDecodedByteList.size()]));
            Assertions.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
        }
    }

    private static byte[] toPrimitiveType(Byte[] aBytes) {
        if (aBytes == null) {
            return null;
        }
        byte[] thePrimitives = new byte[aBytes.length];
        for (int i = 0; i < aBytes.length; ++i) {
            thePrimitives[i] = aBytes[i];
        }
        return thePrimitives;
    }

    private String toRandomText(int aLength) {
        return RandomTextGenerartor.asString((int)aLength, (RandomTextMode)RandomTextMode.ASCII);
    }
}

