/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.command.impls;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.refcodes.command.TestCommand;
import org.refcodes.command.impls.AddCommandImpl;
import org.refcodes.command.impls.MulCommandImpl;
import org.refcodes.command.impls.SubCommandImpl;

public class UndoableTest {
    @Test
    public void testUnduable() throws Exception {
        List<Integer> theRef = this.createReferenceList();
        ArrayDeque<TestCommand> theStack = new ArrayDeque<TestCommand>();
        List<Integer> theCtx = this.createReferenceList();
        AddCommandImpl incBy2 = new AddCommandImpl(2);
        AddCommandImpl incBy4 = new AddCommandImpl(4);
        AddCommandImpl incBy8 = new AddCommandImpl(8);
        SubCommandImpl decBy1 = new SubCommandImpl(1);
        SubCommandImpl decBy2 = new SubCommandImpl(2);
        SubCommandImpl decBy3 = new SubCommandImpl(3);
        MulCommandImpl mulBy2 = new MulCommandImpl(2);
        MulCommandImpl mulBy5 = new MulCommandImpl(5);
        this.execute(incBy2, theCtx, theStack);
        Assert.assertNotEquals(theCtx, theRef);
        this.execute(incBy4, theCtx, theStack);
        Assert.assertNotEquals(theCtx, theRef);
        this.execute(incBy8, theCtx, theStack);
        Assert.assertNotEquals(theCtx, theRef);
        this.execute(mulBy2, theCtx, theStack);
        Assert.assertNotEquals(theCtx, theRef);
        this.execute(decBy1, theCtx, theStack);
        Assert.assertNotEquals(theCtx, theRef);
        this.execute(decBy2, theCtx, theStack);
        Assert.assertNotEquals(theCtx, theRef);
        this.execute(decBy3, theCtx, theStack);
        Assert.assertNotEquals(theCtx, theRef);
        this.execute(mulBy5, theCtx, theStack);
        Assert.assertNotEquals(theCtx, theRef);
        Iterator e = theStack.iterator();
        while (e.hasNext()) {
            ((TestCommand)e.next()).undo(theCtx);
            e.remove();
            if (!e.hasNext()) continue;
            Assert.assertNotEquals(theCtx, theRef);
        }
        Assert.assertEquals(theCtx, theRef);
    }

    private void execute(TestCommand aCommand, List<Integer> aCtx, Deque<TestCommand> aStack) throws Exception {
        aCommand.execute(aCtx);
        aStack.addFirst(aCommand);
    }

    private List<Integer> createReferenceList() {
        ArrayList<Integer> theList = new ArrayList<Integer>();
        for (int i = 1; i < 100; ++i) {
            theList.add(i * 1000);
        }
        return theList;
    }
}

