// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.command;

import org.refcodes.exception.AbstractException;

/**
 * The Class CommandRuntimeException.
 */
public abstract class CommandRuntimeException extends AbstractException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aMessage the a message
	 * @param aErrorCode the a error code
	 */
	public CommandRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aMessage the a message
	 * @param aCause the a cause
	 * @param aErrorCode the a error code
	 */
	public CommandRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public CommandRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param message the message
	 */
	public CommandRuntimeException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aCause the a cause
	 * @param aErrorCode the a error code
	 */
	public CommandRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param cause the cause
	 */
	public CommandRuntimeException( Throwable cause ) {
		super( cause );
	}

	/**
	 * The Class CommandCommandRuntimeException.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class CommandCommandRuntimeException extends CommandRuntimeException implements UndoableAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private Undoable _command;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the a command
		 * @param aMessage the a message
		 * @param aErrorCode the a error code
		 */
		public CommandCommandRuntimeException( Undoable aCommand, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the a command
		 * @param aMessage the a message
		 * @param aCause the a cause
		 * @param aErrorCode the a error code
		 */
		public CommandCommandRuntimeException( Undoable aCommand, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the a command
		 * @param message the message
		 * @param cause the cause
		 */
		public CommandCommandRuntimeException( Undoable aCommand, String message, Throwable cause ) {
			super( message, cause );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the a command
		 * @param message the message
		 */
		public CommandCommandRuntimeException( Undoable aCommand, String message ) {
			super( message );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the a command
		 * @param aCause the a cause
		 * @param aErrorCode the a error code
		 */
		public CommandCommandRuntimeException( Undoable aCommand, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the a command
		 * @param cause the cause
		 */
		public CommandCommandRuntimeException( Undoable aCommand, Throwable cause ) {
			super( cause );
			_command = aCommand;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Gets the undoable.
		 *
		 * @return the undoable
		 */
		@Override
		public Undoable getUndoable() {
			return _command;
		}
	}
}
