// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * This package provides means to implement your custom commands as of the
 * command pattern:
 * <p>
 * "... (in) the command pattern ... an object is used to represent and
 * encapsulate all the information needed to call a method at a later time. This
 * ... includes the ... method parameters ..." [Command pattern, see
 * http://en.wikipedia.org/wiki/Command_pattern (Wikipedia)]
 * <p>
 * A command can be seen as a method and its context (variables1) all
 * transformed to an object (e.g a method turned inside out).
 * <p>
 * Given you define a command's interface with an “execute” and an “undo” method
 * and you strictly make use of commands: Then you easily can provide undo
 * functionality by putting your executed commands onto a stack ...
 * <h2>Command:</h2> A {@link org.refcodes.command.Command} (respectively an
 * {@link org.refcodes.command.Undoable}) represents an (atomic) operation
 * applied to a context encapsulated in an object (as of object oriented
 * programming). Usually a command ({@link org.refcodes.command.Undoable}) also
 * provides means to undo its operation applied before. The
 * {@link org.refcodes.command.Command} ({@link org.refcodes.command.Undoable})
 * is created by a client (e.g. the business logic) and passed e.g. to a command
 * bus for execution (or executed "manually" at required / desired time). (a
 * command bus implementation you can find in the "<code>refcodes-jobbus</code>"
 * artifact, see <code>org.refcodes.jobbus.JobBus</code>).
 * <h2>Client:</h2> The client may be the business logic creating a
 * {@link org.refcodes.command.Undoable} (job) to be executed.
 * <h2>Context:</h2> The context can be a service, a service-bus (providing a
 * handful of services), a component or a plain POJO (this depends on your
 * requirements and your implementation).
 */
package org.refcodes.command;
