// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * This artifact provides you means to implement your custom commands as of the
 * command pattern. Basically a <a href=
 * "https://www.javadoc.io/doc/org.refcodes/refcodes-command/latest/org/refcodes/command/Command.html">command</a>
 * can be seen as a <code>method</code> turned inside out. In case you enrich
 * this command with undo functionality, you can create an undo stack for your
 * applications.
 * 
 * <p style="font-style: plain; font-weight: normal; background-color: #f8f8ff;
 * padding: 1.5rem; border-style: solid; border-width: 1pt; border-radius: 10pt;
 * border-color: #cccccc;text-align: center;">
 * Please refer to the <a href=
 * "https://www.metacodes.pro/refcodes/blog/refcodes-command"><strong>refcodes-command:
 * Do the undo</strong></a> documentation for an up-to-date and detailed
 * description on the usage of this artifact.
 * </p>
 */
package org.refcodes.command;
