// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.command;

import org.refcodes.command.CommandRuntimeException.CommandCommandRuntimeException;

/**
 * The Class NotUndoableRuntimeException.
 */
public class NotUndoableRuntimeException extends CommandCommandRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new not undoable runtime exception.
	 *
	 * @param aCommand the command
	 * @param aMessage The aMessage describing this exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public NotUndoableRuntimeException( Undoable<?, ?, ?> aCommand, String aMessage, String aErrorCode ) {
		super( aCommand, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new not undoable runtime exception.
	 *
	 * @param aCommand the command
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public NotUndoableRuntimeException( Undoable<?, ?, ?> aCommand, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aCommand, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new not undoable runtime exception.
	 *
	 * @param aCommand the command
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public NotUndoableRuntimeException( Undoable<?, ?, ?> aCommand, String aMessage, Throwable aCause ) {
		super( aCommand, aMessage, aCause );
	}

	/**
	 * Instantiates a new not undoable runtime exception.
	 *
	 * @param aCommand the command
	 * @param aMessage The aMessage describing this exception.
	 */
	public NotUndoableRuntimeException( Undoable<?, ?, ?> aCommand, String aMessage ) {
		super( aCommand, aMessage );
	}

	/**
	 * Instantiates a new not undoable runtime exception.
	 *
	 * @param aCommand the command
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public NotUndoableRuntimeException( Undoable<?, ?, ?> aCommand, Throwable aCause, String aErrorCode ) {
		super( aCommand, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new not undoable runtime exception.
	 *
	 * @param aCommand the command
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public NotUndoableRuntimeException( Undoable<?, ?, ?> aCommand, Throwable aCause ) {
		super( aCommand, aCause );
	}
}