// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.command;

import org.refcodes.exception.AbstractRuntimeException;

/**
 * The Class CommandRuntimeException.
 */
public abstract class CommandRuntimeException extends AbstractRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aMessage The aMessage describing this exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public CommandRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public CommandRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public CommandRuntimeException( String aMessage, Throwable aCause ) {
		super( aMessage, aCause );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aMessage The aMessage describing this exception.
	 */
	public CommandRuntimeException( String aMessage ) {
		super( aMessage );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public CommandRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new command runtime exception.
	 *
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public CommandRuntimeException( Throwable aCause ) {
		super( aCause );
	}

	/**
	 * The Class CommandCommandRuntimeException.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class CommandCommandRuntimeException extends CommandRuntimeException implements UndoableAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private Undoable _command;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the command
		 * @param aMessage The aMessage describing this exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public CommandCommandRuntimeException( Undoable aCommand, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the command
		 * @param aMessage The aMessage describing this exception.
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public CommandCommandRuntimeException( Undoable aCommand, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the command
		 * @param aMessage The aMessage describing this exception.
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 */
		public CommandCommandRuntimeException( Undoable aCommand, String aMessage, Throwable aCause ) {
			super( aMessage, aCause );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the command
		 * @param aMessage The aMessage describing this exception.
		 */
		public CommandCommandRuntimeException( Undoable aCommand, String aMessage ) {
			super( aMessage );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the command
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public CommandCommandRuntimeException( Undoable aCommand, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_command = aCommand;
		}

		/**
		 * Instantiates a new command command runtime exception.
		 *
		 * @param aCommand the command
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 */
		public CommandCommandRuntimeException( Undoable aCommand, Throwable aCause ) {
			super( aCause );
			_command = aCommand;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Gets the undoable.
		 *
		 * @return the undoable
		 */
		@Override
		public Undoable getUndoable() {
			return _command;
		}
	}
}
