/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

public enum EscapeCode {
    TAB('\t', "\\t"),
    BACKSPACE('\b', "\\b"),
    NEWLINE('\n', "\\n"),
    CARRIAGE_RETURN('\r', "\\r"),
    FORM_FEED('\f', "\\f"),
    SINGLE_QUOTE('\'', "\\'"),
    DOUBLE_QUOTE('\"', "\\\""),
    BASCKSLASH('\\', "\\\\");

    private char _escapeCode;
    private String _escapeSequence;

    private EscapeCode(char aEscapeChar, String aEscapedSequence) {
        this._escapeCode = aEscapeChar;
        this._escapeSequence = aEscapedSequence;
    }

    public String getEscapeSequence() {
        return this._escapeSequence;
    }

    public char getEscapeCode() {
        return this._escapeCode;
    }

    public static EscapeCode toEscapeCode(char aEscapeCode) {
        for (EscapeCode eCode : EscapeCode.values()) {
            if (eCode.getEscapeCode() != aEscapeCode) continue;
            return eCode;
        }
        return null;
    }

    public static EscapeCode toEscapeCode(String aEscapeSequence) {
        for (EscapeCode eCode : EscapeCode.values()) {
            if (!eCode.getEscapeSequence().equals(aEscapeSequence)) continue;
            return eCode;
        }
        return null;
    }
}

